/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.compat.emi;

import cy.jdkdigital.productivebees.client.helper.RecipeHelper;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredient;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredientFactory;
import cy.jdkdigital.productivebees.common.crafting.ingredient.ComponentIngredient;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.recipe.AdvancedBeehiveRecipe;
import cy.jdkdigital.productivebees.common.recipe.BeeBreedingRecipe;
import cy.jdkdigital.productivebees.common.recipe.BeeConversionRecipe;
import cy.jdkdigital.productivebees.common.recipe.BeeFishingRecipe;
import cy.jdkdigital.productivebees.common.recipe.BeeFloweringRecipe;
import cy.jdkdigital.productivebees.common.recipe.BeeSpawningRecipe;
import cy.jdkdigital.productivebees.common.recipe.BlockConversionRecipe;
import cy.jdkdigital.productivebees.common.recipe.CentrifugeRecipe;
import cy.jdkdigital.productivebees.common.recipe.ConfigurableHoneycombRecipe;
import cy.jdkdigital.productivebees.common.recipe.IncubationRecipe;
import cy.jdkdigital.productivebees.common.recipe.ItemConversionRecipe;
import cy.jdkdigital.productivebees.compat.emi.BeeBreedingEmiRecipe;
import cy.jdkdigital.productivebees.compat.emi.BeeConversionEmiRecipe;
import cy.jdkdigital.productivebees.compat.emi.BeeEmiStack;
import cy.jdkdigital.productivebees.compat.emi.BeeEmiStackSerializer;
import cy.jdkdigital.productivebees.compat.emi.BeeFishingEmiRecipe;
import cy.jdkdigital.productivebees.compat.emi.BeeFloweringEmiRecipe;
import cy.jdkdigital.productivebees.compat.emi.BeeProduceEmiRecipe;
import cy.jdkdigital.productivebees.compat.emi.BeeSpawningEmiRecipe;
import cy.jdkdigital.productivebees.compat.emi.BlockCentrifugeEmiRecipe;
import cy.jdkdigital.productivebees.compat.emi.BlockConversionEmiRecipe;
import cy.jdkdigital.productivebees.compat.emi.CentrifugeEmiRecipe;
import cy.jdkdigital.productivebees.compat.emi.IncubationEmiRecipe;
import cy.jdkdigital.productivebees.compat.emi.ItemConversionEmiRecipe;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModDataComponents;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.BeeCreator;
import cy.jdkdigital.productivebees.util.BeeHelper;
import cy.jdkdigital.productivelib.common.recipe.TagOutputRecipe;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiInitRegistry;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

@EmiEntrypoint
public class ProductiveBeesEmiPlugin
implements EmiPlugin {
    public static final EmiRecipeCategory BEE_PRODUCE_CATEGORY = new EmiRecipeCategory(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"bee_produce"), (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)ModBlocks.HIVES.get("advanced_oak_beehive").get())), (EmiRenderable)new EmiTexture(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/emi/icon/bee_produce.png"), 0, 0, 16, 16, 16, 16, 16, 16));
    public static final EmiRecipeCategory BEE_BREEDING_CATEGORY = new EmiRecipeCategory(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"bee_breeding"), (EmiRenderable)BeeEmiStack.of(BeeIngredientFactory.getIngredient("productivebees:iron").get()), (EmiRenderable)new EmiTexture(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/emi/icon/bee_breeding.png"), 0, 0, 16, 16, 16, 16, 16, 16));
    public static final EmiRecipeCategory BEE_CONVERSION_CATEGORY = new EmiRecipeCategory(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"bee_conversion"), (EmiRenderable)BeeEmiStack.of(BeeIngredientFactory.getIngredient("productivebees:diamond").get()), (EmiRenderable)new EmiTexture(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/emi/icon/bee_conversion.png"), 0, 0, 16, 16, 16, 16, 16, 16));
    public static final EmiRecipeCategory BEE_FISHING_CATEGORY = new EmiRecipeCategory(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"bee_fishing"), (EmiRenderable)EmiStack.of((ItemLike)Items.FISHING_ROD), (EmiRenderable)new EmiTexture(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/emi/icon/bee_fishing.png"), 0, 0, 16, 16, 16, 16, 16, 16));
    public static final EmiRecipeCategory BEE_SPAWNING_CATEGORY = new EmiRecipeCategory(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"bee_spawning"), (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)ModBlocks.COARSE_DIRT_NEST.get())), (EmiRenderable)new EmiTexture(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/emi/icon/bee_spawning.png"), 0, 0, 16, 16, 16, 16, 16, 16));
    public static final EmiRecipeCategory BLOCK_CONVERSION_CATEGORY = new EmiRecipeCategory(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"block_conversion"), (EmiRenderable)EmiStack.of((ItemLike)Items.COBBLESTONE), (EmiRenderable)new EmiTexture(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/emi/icon/block_conversion.png"), 0, 0, 16, 16, 16, 16, 16, 16));
    public static final EmiRecipeCategory ITEM_CONVERSION_CATEGORY = new EmiRecipeCategory(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"item_conversion"), (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)ModBlocks.FEEDER.get())), (EmiRenderable)new EmiTexture(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/emi/icon/item_conversion.png"), 0, 0, 16, 16, 16, 16, 16, 16));
    public static final EmiRecipeCategory CENTRIFUGE_CATEGORY = new EmiRecipeCategory(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"centrifuge"), (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)ModBlocks.CENTRIFUGE.get())), (EmiRenderable)new EmiTexture(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/emi/icon/centrifuge.png"), 0, 0, 16, 16, 16, 16, 16, 16));
    public static final EmiRecipeCategory BLOCK_CENTRIFUGE_CATEGORY = new EmiRecipeCategory(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"block_centrifuge"), (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)ModBlocks.HEATED_CENTRIFUGE.get())), (EmiRenderable)new EmiTexture(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/emi/icon/centrifuge.png"), 0, 0, 16, 16, 16, 16, 16, 16));
    public static final EmiRecipeCategory BEE_FLOWERING_CATEGORY = new EmiRecipeCategory(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"bee_flowering"), (EmiRenderable)EmiStack.of((ItemLike)Items.POPPY), (EmiRenderable)new EmiTexture(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/emi/icon/bee_flowering.png"), 0, 0, 16, 16, 16, 16, 16, 16));
    public static final EmiRecipeCategory INCUBATION_CATEGORY = new EmiRecipeCategory(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"incubator"), (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)ModBlocks.INCUBATOR.get())), (EmiRenderable)new EmiTexture(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/emi/icon/bee_flowering.png"), 0, 0, 16, 16, 16, 16, 16, 16));

    public void initialize(EmiInitRegistry registry) {
        registry.addIngredientSerializer(BeeEmiStack.class, (EmiIngredientSerializer)new BeeEmiStackSerializer());
    }

    public void register(EmiRegistry registry) {
        BeeIngredientFactory.getOrCreateList(true).values().forEach(beeIngredient -> registry.addEmiStack((EmiStack)BeeEmiStack.of(beeIngredient)));
        registry.removeEmiStacks(EmiStack.of((ItemLike)((ItemLike)ModItems.ADV_BREED_BEE.get())));
        registry.removeEmiStacks(EmiStack.of((ItemLike)((ItemLike)ModItems.ADV_BREED_ALL_BEES.get())));
        registry.removeEmiStacks(EmiStack.of((ItemLike)((ItemLike)ModBlocks.INVISIBLE_REDSTONE_BLOCK.get())));
        registry.addCategory(BEE_PRODUCE_CATEGORY);
        registry.addCategory(BEE_BREEDING_CATEGORY);
        registry.addCategory(BEE_CONVERSION_CATEGORY);
        registry.addCategory(BEE_FISHING_CATEGORY);
        registry.addCategory(BEE_SPAWNING_CATEGORY);
        registry.addCategory(BLOCK_CONVERSION_CATEGORY);
        registry.addCategory(ITEM_CONVERSION_CATEGORY);
        registry.addCategory(CENTRIFUGE_CATEGORY);
        registry.addCategory(BLOCK_CENTRIFUGE_CATEGORY);
        registry.addCategory(BEE_FLOWERING_CATEGORY);
        registry.addCategory(INCUBATION_CATEGORY);
        registry.addWorkstation(BEE_PRODUCE_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModBlocks.HIVES.get("advanced_oak_beehive").get())));
        registry.addWorkstation(BEE_BREEDING_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModBlocks.BREEDING_CHAMBER.get())));
        registry.addWorkstation(CENTRIFUGE_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModBlocks.CENTRIFUGE.get())));
        registry.addWorkstation(CENTRIFUGE_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModBlocks.POWERED_CENTRIFUGE.get())));
        registry.addWorkstation(CENTRIFUGE_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModBlocks.HEATED_CENTRIFUGE.get())));
        registry.addWorkstation(BLOCK_CENTRIFUGE_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModBlocks.HEATED_CENTRIFUGE.get())));
        registry.addWorkstation(BEE_SPAWNING_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModBlocks.COARSE_DIRT_NEST.get())));
        registry.addWorkstation(ITEM_CONVERSION_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModBlocks.FEEDER.get())));
        registry.addWorkstation(INCUBATION_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModBlocks.INCUBATOR.get())));
        registry.setDefaultComparison(ModItems.CONFIGURABLE_HONEYCOMB.get(), Comparison.compareData(stack -> (ResourceLocation)stack.get(ModDataComponents.BEE_TYPE.get())));
        registry.setDefaultComparison(ModItems.CONFIGURABLE_COMB_BLOCK.get(), Comparison.compareData(stack -> (ResourceLocation)stack.get(ModDataComponents.BEE_TYPE.get())));
        registry.setDefaultComparison(ModItems.CONFIGURABLE_SPAWN_EGG.get(), Comparison.compareData(stack -> (CustomData)stack.get(DataComponents.ENTITY_DATA)));
        RecipeManager recipeManager = registry.getRecipeManager();
        List produceRecipeList = recipeManager.getAllRecipesFor((RecipeType)ModRecipeTypes.ADVANCED_BEEHIVE_TYPE.get());
        produceRecipeList.forEach(recipeHolder -> registry.addRecipe((EmiRecipe)new BeeProduceEmiRecipe((RecipeHolder<AdvancedBeehiveRecipe>)recipeHolder)));
        List breedingRecipeList = recipeManager.getAllRecipesFor((RecipeType)ModRecipeTypes.BEE_BREEDING_TYPE.get());
        breedingRecipeList.forEach(recipeHolder -> registry.addRecipe((EmiRecipe)new BeeBreedingEmiRecipe((RecipeHolder<BeeBreedingRecipe>)recipeHolder)));
        List beeConversionRecipeList = recipeManager.getAllRecipesFor((RecipeType)ModRecipeTypes.BEE_CONVERSION_TYPE.get());
        beeConversionRecipeList.forEach(recipeHolder -> registry.addRecipe((EmiRecipe)new BeeConversionEmiRecipe((RecipeHolder<BeeConversionRecipe>)recipeHolder)));
        List beeFishingRecipeList = recipeManager.getAllRecipesFor((RecipeType)ModRecipeTypes.BEE_FISHING_TYPE.get());
        beeFishingRecipeList.forEach(recipeHolder -> registry.addRecipe((EmiRecipe)new BeeFishingEmiRecipe((RecipeHolder<BeeFishingRecipe>)recipeHolder)));
        List beeSpawningRecipeList = recipeManager.getAllRecipesFor((RecipeType)ModRecipeTypes.BEE_SPAWNING_TYPE.get());
        beeSpawningRecipeList.forEach(recipeHolder -> registry.addRecipe((EmiRecipe)new BeeSpawningEmiRecipe((RecipeHolder<BeeSpawningRecipe>)recipeHolder)));
        List blockConversionRecipeList = recipeManager.getAllRecipesFor((RecipeType)ModRecipeTypes.BLOCK_CONVERSION_TYPE.get());
        blockConversionRecipeList.forEach(recipeHolder -> registry.addRecipe((EmiRecipe)new BlockConversionEmiRecipe((RecipeHolder<BlockConversionRecipe>)recipeHolder)));
        List itemConversionRecipeList = recipeManager.getAllRecipesFor((RecipeType)ModRecipeTypes.ITEM_CONVERSION_TYPE.get());
        itemConversionRecipeList.forEach(recipeHolder -> registry.addRecipe((EmiRecipe)new ItemConversionEmiRecipe((RecipeHolder<ItemConversionRecipe>)recipeHolder)));
        List centrifugeRecipeList = recipeManager.getAllRecipesFor((RecipeType)ModRecipeTypes.CENTRIFUGE_TYPE.get());
        centrifugeRecipeList.forEach(recipeHolder -> registry.addRecipe((EmiRecipe)new CentrifugeEmiRecipe((RecipeHolder<CentrifugeRecipe>)recipeHolder)));
        List<RecipeHolder> blockCentrifugeRecipesMap = centrifugeRecipeList.stream().map(recipe -> {
            ItemStack item = ((CentrifugeRecipe)recipe.value()).ingredient.getItems()[0];
            if (item.getItem() instanceof HoneycombItem) {
                ArrayList<TagOutputRecipe.ChancedOutput> outputs = new ArrayList<TagOutputRecipe.ChancedOutput>();
                ((CentrifugeRecipe)recipe.value()).itemOutput.forEach(chanceOutput -> outputs.add(new TagOutputRecipe.ChancedOutput(chanceOutput.ingredient(), chanceOutput.min() * 4, chanceOutput.max() * 4, chanceOutput.chance())));
                SizedFluidIngredient fluid = new SizedFluidIngredient(((CentrifugeRecipe)recipe.value()).fluidOutput.ingredient(), ((CentrifugeRecipe)recipe.value()).fluidOutput.amount() * 4);
                return new RecipeHolder(recipe.id().withPath(p -> "/" + p + "_block"), (Recipe)new CentrifugeRecipe(ComponentIngredient.of(BeeHelper.getCombBlockFromHoneyComb(item)), outputs, fluid, ((CentrifugeRecipe)recipe.value()).getProcessingTime()));
            }
            return null;
        }).filter(Objects::nonNull).toList();
        blockCentrifugeRecipesMap.forEach(recipeHolder -> registry.addRecipe((EmiRecipe)new BlockCentrifugeEmiRecipe((RecipeHolder<CentrifugeRecipe>)recipeHolder)));
        Map<String, BeeIngredient> beeList = BeeIngredientFactory.getOrCreateList();
        RecipeHelper.getFlowersRecipes(beeList).forEach(recipeHolder -> registry.addRecipe((EmiRecipe)new BeeFloweringEmiRecipe((BeeFloweringRecipe)recipeHolder)));
        RecipeHelper.getRecipes(beeList).forEach(recipeHolder -> registry.addRecipe((EmiRecipe)new IncubationEmiRecipe((RecipeHolder<IncubationRecipe>)recipeHolder)));
        this.addSelfBreedingRecipes(registry, beeList);
        this.addBlockDupeRecipes(registry);
        this.addBeeInfo(registry);
        this.addCombRecipeAndInfo(registry);
        this.addNestInfo(registry);
    }

    private void addSelfBreedingRecipes(EmiRegistry registry, Map<String, BeeIngredient> beeList) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft != null) {
            ArrayList<RecipeHolder> beeSelfBreedingRecipeMap = new ArrayList<RecipeHolder>();
            for (Map.Entry<String, BeeIngredient> entry : beeList.entrySet()) {
                ConfigurableBee configurableBee;
                Entity entity = entry.getValue().getCachedEntity((Level)minecraft.level);
                if (!(entity instanceof ConfigurableBee) || !(configurableBee = (ConfigurableBee)entity).canSelfBreed()) continue;
                beeSelfBreedingRecipeMap.add(new RecipeHolder(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("self_breeding/" + ResourceLocation.parse((String)entry.getKey()).getPath())), (Recipe)new BeeBreedingRecipe(() -> (BeeIngredient)entry.getValue(), () -> (BeeIngredient)entry.getValue(), () -> (BeeIngredient)entry.getValue(), 0.0f)));
            }
            beeSelfBreedingRecipeMap.forEach(recipeHolder -> registry.addRecipe((EmiRecipe)new BeeBreedingEmiRecipe((RecipeHolder<BeeBreedingRecipe>)recipeHolder)));
        }
    }

    private void addBlockDupeRecipes(EmiRegistry registry) {
        ArrayList chipHiveRecipes = new ArrayList();
        BuiltInRegistries.BLOCK.getTagOrEmpty(ModTags.QUARRY).forEach(blockHolder -> {
            Block b = (Block)blockHolder.value();
            if (!b.builtInRegistryHolder().is(ModTags.DUPE_BLACKLIST)) {
                ArrayList<TagOutputRecipe.ChancedOutput> blockItemOutput = new ArrayList<TagOutputRecipe.ChancedOutput>();
                blockItemOutput.add(new TagOutputRecipe.ChancedOutput(Ingredient.of((ItemLike[])new ItemLike[]{b.asItem()}), 1, 1, 1.0f));
                registry.addRecipe((EmiRecipe)new BeeProduceEmiRecipe((RecipeHolder<AdvancedBeehiveRecipe>)new RecipeHolder(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("/quarry_bee/" + blockHolder.getRegisteredName().replace(":", "_"))), (Recipe)new AdvancedBeehiveRecipe(BeeIngredientFactory.getIngredient("productivebees:quarry_bee"), blockItemOutput))));
            }
        });
        BuiltInRegistries.BLOCK.getTagOrEmpty(ModTags.LUMBER).forEach(blockHolder -> {
            Block b = (Block)blockHolder.value();
            if (!b.builtInRegistryHolder().is(ModTags.DUPE_BLACKLIST)) {
                ArrayList<TagOutputRecipe.ChancedOutput> blockItemOutput = new ArrayList<TagOutputRecipe.ChancedOutput>();
                blockItemOutput.add(new TagOutputRecipe.ChancedOutput(Ingredient.of((ItemLike[])new ItemLike[]{b.asItem()}), 1, 1, 1.0f));
                registry.addRecipe((EmiRecipe)new BeeProduceEmiRecipe((RecipeHolder<AdvancedBeehiveRecipe>)new RecipeHolder(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("/lumber_bee/" + blockHolder.getRegisteredName().replace(":", "_"))), (Recipe)new AdvancedBeehiveRecipe(BeeIngredientFactory.getIngredient("productivebees:lumber_bee"), blockItemOutput))));
            }
        });
    }

    private void addBeeInfo(EmiRegistry registry) {
        Map<String, BeeIngredient> beeList = BeeIngredientFactory.getOrCreateList();
        for (Map.Entry<String, BeeIngredient> entry : beeList.entrySet()) {
            if (!entry.getKey().contains("productivebees")) continue;
            String beeId = entry.getKey().replace("productivebees:", "");
            ArrayList<MutableComponent> descriptions = new ArrayList<MutableComponent>();
            if (entry.getValue().isConfigurable()) {
                CompoundTag nbt = BeeReloadListener.INSTANCE.getData(entry.getKey());
                if (nbt.contains("description")) {
                    descriptions.add(Component.translatable((String)nbt.getString("description")));
                } else {
                    MutableComponent description = Component.translatable((String)("productivebees.ingredient.description." + beeId + "_bee"));
                    if (!description.getString().equals("productivebees.ingredient.description." + beeId + "_bee")) {
                        descriptions.add(description);
                    }
                }
                if (!nbt.getBoolean("selfbreed")) {
                    descriptions.add(Component.translatable((String)"productivebees.ingredient.description.selfbreed", (Object[])new Object[]{""}));
                }
            } else {
                descriptions.add(Component.translatable((String)("productivebees.ingredient.description." + beeId)));
                if (beeId.equals("lumber_bee") || beeId.equals("quarry_bee") || beeId.equals("rancher_bee") || beeId.equals("collector_bee") || beeId.equals("hoarder_bee") || beeId.equals("farmer_bee") || beeId.equals("cupid_bee")) {
                    descriptions.add(Component.translatable((String)"productivebees.ingredient.description.selfbreed", (Object[])new Object[]{""}));
                }
            }
            if (descriptions.isEmpty()) continue;
            registry.addRecipe((EmiRecipe)new EmiInfoRecipe(List.of(BeeEmiStack.of(entry.getValue())), descriptions, null));
        }
    }

    private void addNestInfo(EmiRegistry registry) {
        List<String> itemInfos = Arrays.asList("inactive_dragon_egg", "dragon_egg_hive", "bumble_bee_nest", "sugar_cane_nest", "slimy_nest", "stone_nest", "sand_nest", "snow_nest", "gravel_nest", "coarse_dirt_nest", "oak_wood_nest", "spruce_wood_nest", "acacia_wood_nest", "dark_oak_wood_nest", "jungle_wood_nest", "birch_wood_nest", "end_stone_nest", "obsidian_nest", "glowstone_nest", "soul_sand_nest", "nether_brick_nest", "nether_quartz_nest");
        for (String itemName : itemInfos) {
            Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)itemName));
            registry.addRecipe((EmiRecipe)new EmiInfoRecipe(List.of(EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item}))), List.of(Component.translatable((String)("productivebees.ingredient.description." + itemName))), null));
        }
    }

    private void addCombRecipeAndInfo(EmiRegistry registry) {
        RecipeManager recipeManager = registry.getRecipeManager();
        Optional honeycombRecipe = recipeManager.byKey(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"comb_block/configurable_honeycomb"));
        int count = 4;
        if (honeycombRecipe.isPresent()) {
            count = ((ConfigurableHoneycombRecipe)((RecipeHolder)honeycombRecipe.get()).value()).count;
        }
        for (Map.Entry<ResourceLocation, CompoundTag> entry : BeeReloadListener.INSTANCE.getData().entrySet()) {
            ResourceLocation beeType = entry.getKey();
            ResourceLocation idComb = beeType.withPath(p -> p + "_honeycomb");
            ResourceLocation idCombBlock = beeType.withPath(p -> p + "_comb");
            ItemStack comb = new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get());
            BeeCreator.setType(beeType, comb);
            NonNullList combInput = NonNullList.create();
            for (int i = 0; i < count; ++i) {
                combInput.add((Object)EmiIngredient.of((Ingredient)ComponentIngredient.of(comb)));
            }
            ItemStack combBlock = new ItemStack((ItemLike)ModItems.CONFIGURABLE_COMB_BLOCK.get());
            BeeCreator.setType(beeType, combBlock);
            registry.addRecipe((EmiRecipe)new EmiCraftingRecipe(List.of(EmiIngredient.of((List)combInput), EmiIngredient.of((List)combInput), EmiIngredient.of((Ingredient)Ingredient.EMPTY), EmiIngredient.of((List)combInput), EmiIngredient.of((List)combInput)), EmiStack.of((ItemStack)combBlock), idComb, false));
            ItemStack combOutput = comb.copy();
            combOutput.setCount(count);
            registry.addRecipe((EmiRecipe)new EmiCraftingRecipe(List.of(EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{combBlock}))), EmiStack.of((ItemStack)combOutput), idCombBlock));
        }
    }
}

