/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.compat.jei;

import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredientFactory;
import cy.jdkdigital.productivebees.common.recipe.BeeConversionRecipe;
import cy.jdkdigital.productivebees.compat.jei.ProductiveBeesJeiPlugin;
import java.util.Arrays;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class BeeConversionRecipeCategory
implements IRecipeCategory<BeeConversionRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public BeeConversionRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/jei/bee_conversion_recipe.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 126, 70);
        this.icon = guiHelper.createDrawableIngredient(ProductiveBeesJeiPlugin.BEE_INGREDIENT, (Object)BeeIngredientFactory.getOrCreateList().get("productivebees:quarry_bee"));
    }

    public RecipeType<BeeConversionRecipe> getRecipeType() {
        return ProductiveBeesJeiPlugin.BEE_CONVERSION_TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return Component.translatable((String)"jei.productivebees.bee_conversion");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BeeConversionRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 42, 27).addIngredient(ProductiveBeesJeiPlugin.BEE_INGREDIENT, (Object)recipe.source.get())).setSlotName("source");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 100, 28).addIngredient(ProductiveBeesJeiPlugin.BEE_INGREDIENT, (Object)recipe.result.get())).setSlotName("result");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 10, 26).addItemStacks(Arrays.stream(recipe.item.getItems()).toList())).setSlotName("conversionItems");
    }

    public void draw(BeeConversionRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (recipe.chance < 1.0f) {
            Minecraft minecraft = Minecraft.getInstance();
            guiGraphics.drawString(minecraft.font, Language.getInstance().getVisualOrder((FormattedText)Component.translatable((String)"jei.productivebees.block_conversion.chance", (Object[])new Object[]{Float.valueOf(recipe.chance * 100.0f)})), 0, 60, -16777216, false);
        }
    }
}

