/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.compat.jei;

import cy.jdkdigital.productivebees.common.recipe.CentrifugeRecipe;
import cy.jdkdigital.productivebees.compat.jei.ProductiveBeesJeiPlugin;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModTags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;

public class CentrifugeRecipeCategory
implements IRecipeCategory<CentrifugeRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public CentrifugeRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/jei/centrifuge_recipe.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 126, 70);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.CENTRIFUGE.get()));
    }

    public RecipeType<CentrifugeRecipe> getRecipeType() {
        return ProductiveBeesJeiPlugin.CENTRIFUGE_TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return Component.translatable((String)"jei.productivebees.centrifuge");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CentrifugeRecipe recipe, IFocusGroup focuses) {
        this.setRecipe(builder, recipe, focuses, false);
    }

    protected void setRecipe(IRecipeLayoutBuilder builder, CentrifugeRecipe recipe, IFocusGroup focuses, boolean stripWax) {
        FluidStack fluid;
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 5, 27).addItemStacks(Arrays.stream(recipe.ingredient.getItems()).toList())).setSlotName("ingredient");
        int startX = 68;
        int startY = 26;
        int[] i = new int[]{0};
        if (recipe.getRecipeOutputs().size() > 0) {
            recipe.getRecipeOutputs().forEach((stack, value) -> {
                if (!stripWax || !stack.is(ModTags.Common.WAXES)) {
                    ArrayList innerList = new ArrayList();
                    IntStream.range(value.min(), value.max() + 1).forEach(u -> {
                        ItemStack newStack = stack.copy();
                        newStack.setCount(u);
                        innerList.add(newStack);
                    });
                    ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, startX + i[0] * 18 + 1, startY + (int)Math.floor((float)i[0] / 3.0f) * 18 + 1).addItemStacks(innerList)).addTooltipCallback((recipeSlotView, tooltip) -> {
                        float chance = value.chance() * 100.0f;
                        if (chance < 100.0f) {
                            tooltip.add(Component.translatable((String)"productivebees.centrifuge.tooltip.chance", (Object[])new Object[]{chance < 1.0f ? "<1%" : chance + "%"}));
                        }
                        if (value.min() != value.max()) {
                            tooltip.add(Component.translatable((String)"productivebees.centrifuge.tooltip.amount", (Object[])new Object[]{value.min() + " - " + value.max()}));
                        }
                    }).setSlotName("output" + i[0]);
                    i[0] = i[0] == 2 ? 0 : i[0] + 1;
                }
            });
        }
        if (!(fluid = recipe.getFluidOutputs()).isEmpty()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, startX + i[0] * 18 + 1, startY + (int)Math.floor((float)i[0] / 3.0f) * 18 + 1).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)fluid)).addTooltipCallback((recipeSlotView, tooltip) -> tooltip.add(Component.translatable((String)"productivebees.centrifuge.tooltip.amount", (Object[])new Object[]{fluid.getAmount() + "mB"}))).setSlotName("output" + i[0]);
        }
    }
}

