/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.common.block.entity.BreedingChamberBlockEntity;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import cy.jdkdigital.productivelib.common.block.entity.ICapabilityBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.container.AbstractContainer;
import cy.jdkdigital.productivelib.container.ManualSlotItemHandler;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;

public class BreedingChamberContainer
extends AbstractContainer<BreedingChamberBlockEntity> {
    public static final int SLOT_CAGE = 0;
    public static final int SLOT_BEE_1 = 1;
    public static final int SLOT_BEE_2 = 2;
    public static final int SLOT_BREED_ITEM_1 = 3;
    public static final int SLOT_BREED_ITEM_2 = 4;
    public static final int SLOT_OUTPUT = 5;

    public BreedingChamberContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, BreedingChamberContainer.getTileEntity(playerInventory, data));
    }

    public BreedingChamberContainer(int windowId, Inventory playerInventory, final BreedingChamberBlockEntity blockEntity) {
        super((MenuType)ModContainerTypes.BREEDING_CHAMBER.get(), (ICapabilityBlockEntity)blockEntity, windowId);
        this.addDataSlot(new DataSlot(this){

            public int get() {
                return blockEntity.energyHandler.getEnergyStored();
            }

            public void set(int value) {
                if (blockEntity.energyHandler.getEnergyStored() > 0) {
                    blockEntity.energyHandler.extractEnergy(blockEntity.energyHandler.getEnergyStored(), false);
                }
                if (value > 0) {
                    blockEntity.energyHandler.receiveEnergy(value, false);
                }
            }
        });
        this.addDataSlot(new DataSlot(this){

            public int get() {
                return blockEntity.recipeProgress;
            }

            public void set(int value) {
                blockEntity.recipeProgress = value;
            }
        });
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((BreedingChamberBlockEntity)this.getBlockEntity()).getItemHandler(), 0, 134, 41));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((BreedingChamberBlockEntity)this.getBlockEntity()).getItemHandler(), 1, 26, 17));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((BreedingChamberBlockEntity)this.getBlockEntity()).getItemHandler(), 2, 62, 17));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((BreedingChamberBlockEntity)this.getBlockEntity()).getItemHandler(), 3, 26, 37));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((BreedingChamberBlockEntity)this.getBlockEntity()).getItemHandler(), 4, 62, 37));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((BreedingChamberBlockEntity)this.getBlockEntity()).getItemHandler(), 5, 152, 41));
        this.addSlotBox((IItemHandler)((BreedingChamberBlockEntity)this.getBlockEntity()).getUpgradeHandler(), 0, 178, 8, 1, 18, 4, 18);
        this.layoutPlayerInventorySlots(playerInventory, 0, 8, 84);
    }

    private static BreedingChamberBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof BreedingChamberBlockEntity) {
            return (BreedingChamberBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(tileAtPos));
    }
}

