/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.common.block.entity.CentrifugeBlockEntity;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.container.AbstractContainer;
import cy.jdkdigital.productivelib.container.ManualSlotItemHandler;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public class CentrifugeContainer<T extends CentrifugeBlockEntity>
extends AbstractContainer<T> {
    public CentrifugeContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, CentrifugeContainer.getBlockEntity(playerInventory, data));
    }

    public CentrifugeContainer(int windowId, Inventory playerInventory, T blockEntity) {
        this((MenuType)ModContainerTypes.CENTRIFUGE.get(), windowId, playerInventory, blockEntity);
    }

    public CentrifugeContainer(@Nullable MenuType<?> type, int windowId, Inventory playerInventory, T blockEntity) {
        super(type, blockEntity, windowId);
        this.addDataSlots(new ContainerData(){
            final /* synthetic */ CentrifugeBlockEntity val$blockEntity;
            {
                this.val$blockEntity = centrifugeBlockEntity;
            }

            public int get(int i) {
                return i == 0 ? this.val$blockEntity.fluidId : this.val$blockEntity.fluidHandler.getFluidInTank(0).getAmount();
            }

            public void set(int i, int value) {
                switch (i) {
                    case 0: {
                        this.val$blockEntity.fluidId = value;
                    }
                    case 1: {
                        FluidStack fluid = this.val$blockEntity.fluidHandler.getFluidInTank(0);
                        if (fluid.isEmpty()) {
                            this.val$blockEntity.fluidHandler.fill(new FluidStack((Fluid)BuiltInRegistries.FLUID.byId(this.val$blockEntity.fluidId), value), IFluidHandler.FluidAction.EXECUTE);
                            break;
                        }
                        fluid.setAmount(value);
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        });
        this.addDataSlot(new DataSlot(this, (CentrifugeBlockEntity)blockEntity){
            final /* synthetic */ CentrifugeBlockEntity val$blockEntity;
            {
                this.val$blockEntity = centrifugeBlockEntity;
            }

            public int get() {
                return this.val$blockEntity.recipeProgress;
            }

            public void set(int value) {
                this.val$blockEntity.recipeProgress = value;
            }
        });
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((CentrifugeBlockEntity)this.getBlockEntity()).getItemHandler(), 1, 26, 35));
        this.addSlotBox(((CentrifugeBlockEntity)this.getBlockEntity()).getItemHandler(), InventoryHandlerHelper.OUTPUT_SLOTS[0], 80, 17, 3, 18, 3, 18);
        this.addSlotBox((IItemHandler)((CentrifugeBlockEntity)this.getBlockEntity()).getUpgradeHandler(), 0, 178, 8, 1, 18, 4, 18);
        this.layoutPlayerInventorySlots(playerInventory, 0, 8, 84);
    }

    private static CentrifugeBlockEntity getBlockEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof CentrifugeBlockEntity) {
            return (CentrifugeBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(tileAtPos));
    }
}

