/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.common.block.entity.HoneyGeneratorBlockEntity;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import cy.jdkdigital.productivelib.common.block.entity.ICapabilityBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.container.AbstractContainer;
import cy.jdkdigital.productivelib.container.ManualSlotItemHandler;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public class HoneyGeneratorContainer
extends AbstractContainer<HoneyGeneratorBlockEntity> {
    public HoneyGeneratorContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, HoneyGeneratorContainer.getTileEntity(playerInventory, data));
    }

    public HoneyGeneratorContainer(int windowId, Inventory playerInventory, final HoneyGeneratorBlockEntity tileEntity) {
        super((MenuType)ModContainerTypes.HONEY_GENERATOR.get(), (ICapabilityBlockEntity)tileEntity, windowId);
        this.addDataSlot(new DataSlot(this){

            public int get() {
                return tileEntity.energyHandler.getEnergyStored();
            }

            public void set(int value) {
                if (tileEntity.energyHandler.getEnergyStored() > 0) {
                    tileEntity.energyHandler.extractEnergy(tileEntity.energyHandler.getEnergyStored(), false);
                }
                if (value > 0) {
                    tileEntity.energyHandler.receiveEnergy(value, false);
                }
            }
        });
        this.addDataSlots(new ContainerData(){

            public int get(int i) {
                return i == 0 ? tileEntity.fluidId : tileEntity.fluidHandler.getFluidInTank(0).getAmount();
            }

            public void set(int i, int value) {
                switch (i) {
                    case 0: {
                        tileEntity.fluidId = value;
                    }
                    case 1: {
                        FluidStack fluid = tileEntity.fluidHandler.getFluidInTank(0);
                        if (fluid.isEmpty()) {
                            tileEntity.fluidHandler.fill(new FluidStack((Fluid)BuiltInRegistries.FLUID.byId(tileEntity.fluidId), value), IFluidHandler.FluidAction.EXECUTE);
                            break;
                        }
                        fluid.setAmount(value);
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        });
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((HoneyGeneratorBlockEntity)this.getBlockEntity()).getItemHandler(), 0, 152, 17));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((HoneyGeneratorBlockEntity)this.getBlockEntity()).getItemHandler(), 1, 152, 53));
        this.addSlotBox((IItemHandler)((HoneyGeneratorBlockEntity)this.getBlockEntity()).getUpgradeHandler(), 0, 178, 8, 1, 18, 4, 18);
        this.layoutPlayerInventorySlots(playerInventory, 0, 8, 84);
    }

    private static HoneyGeneratorBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof HoneyGeneratorBlockEntity) {
            return (HoneyGeneratorBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(tileAtPos));
    }
}

