/*
 * Decompiled with CFR 0.152.
 */
package net.toopa.unusualfurniture.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.toopa.unusualfurniture.procedures.IronLampOnTickUpdateProcedure;

public class IronLampBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final IntegerProperty BLOCKSTATE = IntegerProperty.create((String)"blockstate", (int)0, (int)5);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public IronLampBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.NETHERITE_BLOCK).strength(1.0f, 10.0f).lightLevel(s -> new Object((BlockState)s){
            final /* synthetic */ BlockState val$s;
            {
                this.val$s = blockState;
            }

            public int getLightLevel() {
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 1) {
                    return 0;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 2) {
                    return 15;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 3) {
                    return 0;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 4) {
                    return 15;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 5) {
                    return 0;
                }
                return 15;
            }
        }.getLightLevel()).noOcclusion().isRedstoneConductor((bs, br, bp) -> false).dynamicShape());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"block.unusual_furniture.iron_lamp.description_0"));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 2) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                default -> Shapes.or((VoxelShape)IronLampBlock.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{IronLampBlock.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), IronLampBlock.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), IronLampBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0)});
                case Direction.NORTH -> Shapes.or((VoxelShape)IronLampBlock.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{IronLampBlock.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), IronLampBlock.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), IronLampBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0)});
                case Direction.EAST -> Shapes.or((VoxelShape)IronLampBlock.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{IronLampBlock.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), IronLampBlock.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), IronLampBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0)});
                case Direction.WEST -> Shapes.or((VoxelShape)IronLampBlock.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{IronLampBlock.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), IronLampBlock.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), IronLampBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0)});
            };
        }
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 3) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                default -> Shapes.or((VoxelShape)IronLampBlock.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{IronLampBlock.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), IronLampBlock.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), IronLampBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0)});
                case Direction.NORTH -> Shapes.or((VoxelShape)IronLampBlock.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{IronLampBlock.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), IronLampBlock.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), IronLampBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0)});
                case Direction.EAST -> Shapes.or((VoxelShape)IronLampBlock.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{IronLampBlock.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), IronLampBlock.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), IronLampBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0)});
                case Direction.WEST -> Shapes.or((VoxelShape)IronLampBlock.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{IronLampBlock.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), IronLampBlock.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), IronLampBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0)});
            };
        }
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 4) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                default -> Shapes.or((VoxelShape)IronLampBlock.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{IronLampBlock.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), IronLampBlock.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)6.0, (double)8.0), IronLampBlock.box((double)6.0, (double)16.0, (double)6.0, (double)10.0, (double)17.0, (double)10.0), IronLampBlock.box((double)6.0, (double)2.0, (double)0.0, (double)10.0, (double)6.0, (double)2.0), IronLampBlock.box((double)6.0, (double)2.0, (double)2.0, (double)10.0, (double)6.0, (double)6.0)});
                case Direction.NORTH -> Shapes.or((VoxelShape)IronLampBlock.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{IronLampBlock.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), IronLampBlock.box((double)6.0, (double)4.0, (double)8.0, (double)10.0, (double)6.0, (double)10.0), IronLampBlock.box((double)6.0, (double)16.0, (double)6.0, (double)10.0, (double)17.0, (double)10.0), IronLampBlock.box((double)6.0, (double)2.0, (double)14.0, (double)10.0, (double)6.0, (double)16.0), IronLampBlock.box((double)6.0, (double)2.0, (double)10.0, (double)10.0, (double)6.0, (double)14.0)});
                case Direction.EAST -> Shapes.or((VoxelShape)IronLampBlock.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{IronLampBlock.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), IronLampBlock.box((double)6.0, (double)4.0, (double)6.0, (double)8.0, (double)6.0, (double)10.0), IronLampBlock.box((double)6.0, (double)16.0, (double)6.0, (double)10.0, (double)17.0, (double)10.0), IronLampBlock.box((double)0.0, (double)2.0, (double)6.0, (double)2.0, (double)6.0, (double)10.0), IronLampBlock.box((double)2.0, (double)2.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0)});
                case Direction.WEST -> Shapes.or((VoxelShape)IronLampBlock.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{IronLampBlock.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), IronLampBlock.box((double)8.0, (double)4.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), IronLampBlock.box((double)6.0, (double)16.0, (double)6.0, (double)10.0, (double)17.0, (double)10.0), IronLampBlock.box((double)14.0, (double)2.0, (double)6.0, (double)16.0, (double)6.0, (double)10.0), IronLampBlock.box((double)10.0, (double)2.0, (double)6.0, (double)14.0, (double)6.0, (double)10.0)});
            };
        }
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 5) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                default -> Shapes.or((VoxelShape)IronLampBlock.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{IronLampBlock.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), IronLampBlock.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)6.0, (double)8.0), IronLampBlock.box((double)6.0, (double)16.0, (double)6.0, (double)10.0, (double)17.0, (double)10.0), IronLampBlock.box((double)6.0, (double)2.0, (double)0.0, (double)10.0, (double)6.0, (double)2.0), IronLampBlock.box((double)6.0, (double)2.0, (double)2.0, (double)10.0, (double)6.0, (double)6.0)});
                case Direction.NORTH -> Shapes.or((VoxelShape)IronLampBlock.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{IronLampBlock.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), IronLampBlock.box((double)6.0, (double)4.0, (double)8.0, (double)10.0, (double)6.0, (double)10.0), IronLampBlock.box((double)6.0, (double)16.0, (double)6.0, (double)10.0, (double)17.0, (double)10.0), IronLampBlock.box((double)6.0, (double)2.0, (double)14.0, (double)10.0, (double)6.0, (double)16.0), IronLampBlock.box((double)6.0, (double)2.0, (double)10.0, (double)10.0, (double)6.0, (double)14.0)});
                case Direction.EAST -> Shapes.or((VoxelShape)IronLampBlock.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{IronLampBlock.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), IronLampBlock.box((double)6.0, (double)4.0, (double)6.0, (double)8.0, (double)6.0, (double)10.0), IronLampBlock.box((double)6.0, (double)16.0, (double)6.0, (double)10.0, (double)17.0, (double)10.0), IronLampBlock.box((double)0.0, (double)2.0, (double)6.0, (double)2.0, (double)6.0, (double)10.0), IronLampBlock.box((double)2.0, (double)2.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0)});
                case Direction.WEST -> Shapes.or((VoxelShape)IronLampBlock.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{IronLampBlock.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), IronLampBlock.box((double)8.0, (double)4.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), IronLampBlock.box((double)6.0, (double)16.0, (double)6.0, (double)10.0, (double)17.0, (double)10.0), IronLampBlock.box((double)14.0, (double)2.0, (double)6.0, (double)16.0, (double)6.0, (double)10.0), IronLampBlock.box((double)10.0, (double)2.0, (double)6.0, (double)14.0, (double)6.0, (double)10.0)});
            };
        }
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)IronLampBlock.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{IronLampBlock.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), IronLampBlock.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)IronLampBlock.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{IronLampBlock.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), IronLampBlock.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)IronLampBlock.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{IronLampBlock.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), IronLampBlock.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)IronLampBlock.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{IronLampBlock.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), IronLampBlock.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED, BLOCKSTATE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag;
        boolean bl = flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        if (context.getClickedFace().getAxis() == Direction.Axis.Y) {
            return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        }
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getClickedFace())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        world.scheduleTick(pos, (Block)this, 60);
    }

    public void neighborChanged(BlockState blockstate, Level world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.neighborChanged(blockstate, world, pos, neighborBlock, fromPos, moving);
        IronLampOnTickUpdateProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), blockstate);
    }

    public void tick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(blockstate, world, pos, random);
        IronLampOnTickUpdateProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), blockstate);
        world.scheduleTick(pos, (Block)this, 60);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState blockstate, LivingEntity entity, ItemStack itemstack) {
        super.setPlacedBy(world, pos, blockstate, entity, itemstack);
        IronLampOnTickUpdateProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), blockstate);
    }
}

