/*
 * Decompiled with CFR 0.152.
 */
package net.toopa.unusualfurniture.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.toopa.unusualfurniture.procedures.BroomOnBlockRightClickedProcedure;
import net.toopa.unusualfurniture.procedures.PlaceSmokeProcedure;
import net.toopa.unusualfurniture.procedures.RakesInTheFaceProcedure;

public class RakesBlock
extends Block {
    public static final IntegerProperty BLOCKSTATE = IntegerProperty.create((String)"blockstate", (int)0, (int)2);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public RakesBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(1.0f, 10.0f).lightLevel(s -> new Object((BlockState)s){
            final /* synthetic */ BlockState val$s;
            {
                this.val$s = blockState;
            }

            public int getLightLevel() {
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 1) {
                    return 0;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 2) {
                    return 0;
                }
                return 0;
            }
        }.getLightLevel()).noOcclusion().isRedstoneConductor((bs, br, bp) -> false).dynamicShape());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"block.unusual_furniture.rakes.description_0"));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 1) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                default -> Shapes.or((VoxelShape)RakesBlock.box((double)6.8, (double)6.85, (double)5.25, (double)8.8, (double)24.85, (double)7.25), (VoxelShape[])new VoxelShape[]{RakesBlock.box((double)6.7, (double)19.75, (double)5.15, (double)8.9, (double)23.95, (double)7.35), RakesBlock.box((double)6.7, (double)4.75, (double)5.15, (double)8.9, (double)8.95, (double)7.35)});
                case Direction.NORTH -> Shapes.or((VoxelShape)RakesBlock.box((double)7.2, (double)6.85, (double)8.75, (double)9.2, (double)24.85, (double)10.75), (VoxelShape[])new VoxelShape[]{RakesBlock.box((double)7.1, (double)19.75, (double)8.65, (double)9.3, (double)23.95, (double)10.85), RakesBlock.box((double)7.1, (double)4.75, (double)8.65, (double)9.3, (double)8.95, (double)10.85)});
                case Direction.EAST -> Shapes.or((VoxelShape)RakesBlock.box((double)5.25, (double)6.85, (double)7.2, (double)7.25, (double)24.85, (double)9.2), (VoxelShape[])new VoxelShape[]{RakesBlock.box((double)5.15, (double)19.75, (double)7.1, (double)7.35, (double)23.95, (double)9.3), RakesBlock.box((double)5.15, (double)4.75, (double)7.1, (double)7.35, (double)8.95, (double)9.3)});
                case Direction.WEST -> Shapes.or((VoxelShape)RakesBlock.box((double)8.75, (double)6.85, (double)6.8, (double)10.75, (double)24.85, (double)8.8), (VoxelShape[])new VoxelShape[]{RakesBlock.box((double)8.65, (double)19.75, (double)6.7, (double)10.85, (double)23.95, (double)8.9), RakesBlock.box((double)8.65, (double)4.75, (double)6.7, (double)10.85, (double)8.95, (double)8.9)});
            };
        }
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 2) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                default -> Shapes.or((VoxelShape)RakesBlock.box((double)6.8, (double)0.2, (double)-5.2, (double)8.8, (double)2.2, (double)12.8), (VoxelShape[])new VoxelShape[]{RakesBlock.box((double)6.7, (double)0.1, (double)-4.3, (double)8.9, (double)2.3, (double)-0.1), RakesBlock.box((double)6.7, (double)0.1, (double)10.7, (double)8.9, (double)2.3, (double)14.9)});
                case Direction.NORTH -> Shapes.or((VoxelShape)RakesBlock.box((double)7.2, (double)0.2, (double)3.2, (double)9.2, (double)2.2, (double)21.2), (VoxelShape[])new VoxelShape[]{RakesBlock.box((double)7.1, (double)0.1, (double)16.1, (double)9.3, (double)2.3, (double)20.3), RakesBlock.box((double)7.1, (double)0.1, (double)1.1, (double)9.3, (double)2.3, (double)5.3)});
                case Direction.EAST -> Shapes.or((VoxelShape)RakesBlock.box((double)-5.2, (double)0.2, (double)7.2, (double)12.8, (double)2.2, (double)9.2), (VoxelShape[])new VoxelShape[]{RakesBlock.box((double)-4.3, (double)0.1, (double)7.1, (double)-0.1, (double)2.3, (double)9.3), RakesBlock.box((double)10.7, (double)0.1, (double)7.1, (double)14.9, (double)2.3, (double)9.3)});
                case Direction.WEST -> Shapes.or((VoxelShape)RakesBlock.box((double)3.2, (double)0.2, (double)6.8, (double)21.2, (double)2.2, (double)8.8), (VoxelShape[])new VoxelShape[]{RakesBlock.box((double)16.1, (double)0.1, (double)6.7, (double)20.3, (double)2.3, (double)8.9), RakesBlock.box((double)1.1, (double)0.1, (double)6.7, (double)5.3, (double)2.3, (double)8.9)});
            };
        }
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)RakesBlock.box((double)6.8, (double)7.55, (double)7.05, (double)8.8, (double)25.55, (double)9.05), (VoxelShape[])new VoxelShape[]{RakesBlock.box((double)6.7, (double)20.45, (double)6.95, (double)8.9, (double)24.65, (double)9.15), RakesBlock.box((double)6.7, (double)5.45, (double)6.95, (double)8.9, (double)9.65, (double)9.15)});
            case Direction.NORTH -> Shapes.or((VoxelShape)RakesBlock.box((double)7.2, (double)7.55, (double)6.95, (double)9.2, (double)25.55, (double)8.95), (VoxelShape[])new VoxelShape[]{RakesBlock.box((double)7.1, (double)20.45, (double)6.85, (double)9.3, (double)24.65, (double)9.05), RakesBlock.box((double)7.1, (double)5.45, (double)6.85, (double)9.3, (double)9.65, (double)9.05)});
            case Direction.EAST -> Shapes.or((VoxelShape)RakesBlock.box((double)7.05, (double)7.55, (double)7.2, (double)9.05, (double)25.55, (double)9.2), (VoxelShape[])new VoxelShape[]{RakesBlock.box((double)6.95, (double)20.45, (double)7.1, (double)9.15, (double)24.65, (double)9.3), RakesBlock.box((double)6.95, (double)5.45, (double)7.1, (double)9.15, (double)9.65, (double)9.3)});
            case Direction.WEST -> Shapes.or((VoxelShape)RakesBlock.box((double)6.95, (double)7.55, (double)6.8, (double)8.95, (double)25.55, (double)8.8), (VoxelShape[])new VoxelShape[]{RakesBlock.box((double)6.85, (double)20.45, (double)6.7, (double)9.05, (double)24.65, (double)8.9), RakesBlock.box((double)6.85, (double)5.45, (double)6.7, (double)9.05, (double)9.65, (double)8.9)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, BLOCKSTATE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        PlaceSmokeProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }

    public void entityInside(BlockState blockstate, Level world, BlockPos pos, Entity entity) {
        super.entityInside(blockstate, world, pos, entity);
        RakesInTheFaceProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), blockstate, entity);
    }

    public void stepOn(Level world, BlockPos pos, BlockState blockstate, Entity entity) {
        super.stepOn(world, pos, blockstate, entity);
        RakesInTheFaceProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), blockstate, entity);
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double hitX = hit.getLocation().x;
        double hitY = hit.getLocation().y;
        double hitZ = hit.getLocation().z;
        Direction direction = hit.getDirection();
        BroomOnBlockRightClickedProcedure.execute((LevelAccessor)world, x, y, z, blockstate);
        return InteractionResult.SUCCESS;
    }
}

