/*
 * Decompiled with CFR 0.152.
 */
package net.toopa.unusualfurniture.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.toopa.unusualfurniture.init.UnusualFurnitureModBlocks;
import net.toopa.unusualfurniture.procedures.TropicalPlantBlockAddedProcedure;
import net.toopa.unusualfurniture.procedures.WallTropicalPlantBlockValidPlacementConditionProcedure;

public class WallMushroomPatchBlock
extends Block {
    public static final IntegerProperty BLOCKSTATE = IntegerProperty.create((String)"blockstate", (int)0, (int)3);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public WallMushroomPatchBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.GRASS).instabreak().lightLevel(s -> new Object((BlockState)s){
            final /* synthetic */ BlockState val$s;
            {
                this.val$s = blockState;
            }

            public int getLightLevel() {
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 1) {
                    return 0;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 2) {
                    return 0;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 3) {
                    return 0;
                }
                return 0;
            }
        }.getLightLevel()).noCollission().noOcclusion().pushReaction(PushReaction.DESTROY).isRedstoneConductor((bs, br, bp) -> false).dynamicShape());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"block.unusual_furniture.wall_mushroom_patch.description_0"));
    }

    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.getBlock() == this ? true : super.skipRendering(state, adjacentBlockState, side);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 1) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                default -> Shapes.or((VoxelShape)WallMushroomPatchBlock.box((double)3.0, (double)3.0, (double)-2.0, (double)9.0, (double)5.0, (double)4.0), (VoxelShape[])new VoxelShape[]{WallMushroomPatchBlock.box((double)9.0, (double)8.0, (double)-3.0, (double)15.0, (double)10.0, (double)3.0), WallMushroomPatchBlock.box((double)1.0, (double)11.0, (double)-1.0, (double)5.0, (double)13.0, (double)3.0)});
                case Direction.NORTH -> Shapes.or((VoxelShape)WallMushroomPatchBlock.box((double)7.0, (double)3.0, (double)12.0, (double)13.0, (double)5.0, (double)18.0), (VoxelShape[])new VoxelShape[]{WallMushroomPatchBlock.box((double)1.0, (double)8.0, (double)13.0, (double)7.0, (double)10.0, (double)19.0), WallMushroomPatchBlock.box((double)11.0, (double)11.0, (double)13.0, (double)15.0, (double)13.0, (double)17.0)});
                case Direction.EAST -> Shapes.or((VoxelShape)WallMushroomPatchBlock.box((double)-2.0, (double)3.0, (double)7.0, (double)4.0, (double)5.0, (double)13.0), (VoxelShape[])new VoxelShape[]{WallMushroomPatchBlock.box((double)-3.0, (double)8.0, (double)1.0, (double)3.0, (double)10.0, (double)7.0), WallMushroomPatchBlock.box((double)-1.0, (double)11.0, (double)11.0, (double)3.0, (double)13.0, (double)15.0)});
                case Direction.WEST -> Shapes.or((VoxelShape)WallMushroomPatchBlock.box((double)12.0, (double)3.0, (double)3.0, (double)18.0, (double)5.0, (double)9.0), (VoxelShape[])new VoxelShape[]{WallMushroomPatchBlock.box((double)13.0, (double)8.0, (double)9.0, (double)19.0, (double)10.0, (double)15.0), WallMushroomPatchBlock.box((double)13.0, (double)11.0, (double)1.0, (double)17.0, (double)13.0, (double)5.0)});
            };
        }
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 2) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                default -> Shapes.or((VoxelShape)WallMushroomPatchBlock.box((double)-3.0, (double)3.0, (double)-4.0, (double)3.0, (double)5.0, (double)2.0), (VoxelShape[])new VoxelShape[]{WallMushroomPatchBlock.box((double)5.0, (double)7.0, (double)-3.0, (double)11.0, (double)9.0, (double)3.0), WallMushroomPatchBlock.box((double)-2.0, (double)11.0, (double)-2.0, (double)2.0, (double)13.0, (double)2.0)});
                case Direction.NORTH -> Shapes.or((VoxelShape)WallMushroomPatchBlock.box((double)13.0, (double)3.0, (double)14.0, (double)19.0, (double)5.0, (double)20.0), (VoxelShape[])new VoxelShape[]{WallMushroomPatchBlock.box((double)5.0, (double)7.0, (double)13.0, (double)11.0, (double)9.0, (double)19.0), WallMushroomPatchBlock.box((double)14.0, (double)11.0, (double)14.0, (double)18.0, (double)13.0, (double)18.0)});
                case Direction.EAST -> Shapes.or((VoxelShape)WallMushroomPatchBlock.box((double)-4.0, (double)3.0, (double)13.0, (double)2.0, (double)5.0, (double)19.0), (VoxelShape[])new VoxelShape[]{WallMushroomPatchBlock.box((double)-3.0, (double)7.0, (double)5.0, (double)3.0, (double)9.0, (double)11.0), WallMushroomPatchBlock.box((double)-2.0, (double)11.0, (double)14.0, (double)2.0, (double)13.0, (double)18.0)});
                case Direction.WEST -> Shapes.or((VoxelShape)WallMushroomPatchBlock.box((double)14.0, (double)3.0, (double)-3.0, (double)20.0, (double)5.0, (double)3.0), (VoxelShape[])new VoxelShape[]{WallMushroomPatchBlock.box((double)13.0, (double)7.0, (double)5.0, (double)19.0, (double)9.0, (double)11.0), WallMushroomPatchBlock.box((double)14.0, (double)11.0, (double)-2.0, (double)18.0, (double)13.0, (double)2.0)});
            };
        }
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 3) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                default -> Shapes.or((VoxelShape)WallMushroomPatchBlock.box((double)-3.0, (double)3.0, (double)-4.0, (double)3.0, (double)5.0, (double)2.0), (VoxelShape[])new VoxelShape[]{WallMushroomPatchBlock.box((double)5.0, (double)7.0, (double)-3.0, (double)11.0, (double)9.0, (double)3.0), WallMushroomPatchBlock.box((double)-2.0, (double)11.0, (double)-2.0, (double)2.0, (double)13.0, (double)2.0)});
                case Direction.NORTH -> Shapes.or((VoxelShape)WallMushroomPatchBlock.box((double)13.0, (double)3.0, (double)14.0, (double)19.0, (double)5.0, (double)20.0), (VoxelShape[])new VoxelShape[]{WallMushroomPatchBlock.box((double)5.0, (double)7.0, (double)13.0, (double)11.0, (double)9.0, (double)19.0), WallMushroomPatchBlock.box((double)14.0, (double)11.0, (double)14.0, (double)18.0, (double)13.0, (double)18.0)});
                case Direction.EAST -> Shapes.or((VoxelShape)WallMushroomPatchBlock.box((double)-4.0, (double)3.0, (double)13.0, (double)2.0, (double)5.0, (double)19.0), (VoxelShape[])new VoxelShape[]{WallMushroomPatchBlock.box((double)-3.0, (double)7.0, (double)5.0, (double)3.0, (double)9.0, (double)11.0), WallMushroomPatchBlock.box((double)-2.0, (double)11.0, (double)14.0, (double)2.0, (double)13.0, (double)18.0)});
                case Direction.WEST -> Shapes.or((VoxelShape)WallMushroomPatchBlock.box((double)14.0, (double)3.0, (double)-3.0, (double)20.0, (double)5.0, (double)3.0), (VoxelShape[])new VoxelShape[]{WallMushroomPatchBlock.box((double)13.0, (double)7.0, (double)5.0, (double)19.0, (double)9.0, (double)11.0), WallMushroomPatchBlock.box((double)14.0, (double)11.0, (double)-2.0, (double)18.0, (double)13.0, (double)2.0)});
            };
        }
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)WallMushroomPatchBlock.box((double)3.0, (double)3.0, (double)-2.0, (double)9.0, (double)5.0, (double)4.0), (VoxelShape[])new VoxelShape[]{WallMushroomPatchBlock.box((double)9.0, (double)8.0, (double)-3.0, (double)15.0, (double)10.0, (double)3.0), WallMushroomPatchBlock.box((double)1.0, (double)11.0, (double)-1.0, (double)5.0, (double)13.0, (double)3.0), WallMushroomPatchBlock.box((double)0.0, (double)0.0, (double)-2.0, (double)16.0, (double)16.0, (double)0.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)WallMushroomPatchBlock.box((double)7.0, (double)3.0, (double)12.0, (double)13.0, (double)5.0, (double)18.0), (VoxelShape[])new VoxelShape[]{WallMushroomPatchBlock.box((double)1.0, (double)8.0, (double)13.0, (double)7.0, (double)10.0, (double)19.0), WallMushroomPatchBlock.box((double)11.0, (double)11.0, (double)13.0, (double)15.0, (double)13.0, (double)17.0), WallMushroomPatchBlock.box((double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0, (double)18.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)WallMushroomPatchBlock.box((double)-2.0, (double)3.0, (double)7.0, (double)4.0, (double)5.0, (double)13.0), (VoxelShape[])new VoxelShape[]{WallMushroomPatchBlock.box((double)-3.0, (double)8.0, (double)1.0, (double)3.0, (double)10.0, (double)7.0), WallMushroomPatchBlock.box((double)-1.0, (double)11.0, (double)11.0, (double)3.0, (double)13.0, (double)15.0), WallMushroomPatchBlock.box((double)-2.0, (double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)WallMushroomPatchBlock.box((double)12.0, (double)3.0, (double)3.0, (double)18.0, (double)5.0, (double)9.0), (VoxelShape[])new VoxelShape[]{WallMushroomPatchBlock.box((double)13.0, (double)8.0, (double)9.0, (double)19.0, (double)10.0, (double)15.0), WallMushroomPatchBlock.box((double)13.0, (double)11.0, (double)1.0, (double)17.0, (double)13.0, (double)5.0), WallMushroomPatchBlock.box((double)16.0, (double)0.0, (double)0.0, (double)18.0, (double)16.0, (double)16.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, BLOCKSTATE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getClickedFace().getAxis() == Direction.Axis.Y) {
            return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)Direction.NORTH);
        }
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getClickedFace());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public boolean canSurvive(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        if (worldIn instanceof LevelAccessor) {
            LevelAccessor world = (LevelAccessor)worldIn;
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return WallTropicalPlantBlockValidPlacementConditionProcedure.execute(world, x, y, z, blockstate);
        }
        return super.canSurvive(blockstate, worldIn, pos);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        return !state.canSurvive((LevelReader)world, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)UnusualFurnitureModBlocks.MUSHROOM_PATCH.get());
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        TropicalPlantBlockAddedProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }
}

