/*
 * Decompiled with CFR 0.152.
 */
package net.toopa.unusualfurniture.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.toopa.unusualfurniture.block.AcaciaDrawerBlock;
import net.toopa.unusualfurniture.block.entity.AcaciaDrawerBlockEntity;
import net.toopa.unusualfurniture.client.model.Modeljavadrawer;
import net.toopa.unusualfurniture.client.model.animations.javadrawerAnimation;
import net.toopa.unusualfurniture.init.UnusualFurnitureModBlockEntities;
import net.toopa.unusualfurniture.procedures.OakDrawerClosePlaybackConditionProcedure;
import net.toopa.unusualfurniture.procedures.OakDrawerOpenPlaybackConditionProcedure;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class AcaciaDrawerRenderer
implements BlockEntityRenderer<AcaciaDrawerBlockEntity> {
    private final CustomHierarchicalModel model;
    private final ResourceLocation texture;

    AcaciaDrawerRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new CustomHierarchicalModel(context.bakeLayer(Modeljavadrawer.LAYER_LOCATION));
        this.texture = ResourceLocation.parse((String)"unusual_furniture:textures/block/java_drawer_acacia.png");
    }

    private void updateRenderState(AcaciaDrawerBlockEntity blockEntity) {
        int tickCount = (int)blockEntity.getLevel().getGameTime();
        blockEntity.animationState0.animateWhen(OakDrawerOpenPlaybackConditionProcedure.execute((LevelAccessor)blockEntity.getLevel(), blockEntity.getBlockPos().getX(), blockEntity.getBlockPos().getY(), blockEntity.getBlockPos().getZ()), tickCount);
        blockEntity.animationState1.animateWhen(OakDrawerClosePlaybackConditionProcedure.execute((LevelAccessor)blockEntity.getLevel(), blockEntity.getBlockPos().getX(), blockEntity.getBlockPos().getY(), blockEntity.getBlockPos().getZ()), tickCount);
    }

    public void render(AcaciaDrawerBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource renderer, int light, int overlayLight) {
        this.updateRenderState(blockEntity);
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(-0.5, -0.5, 0.5);
        BlockState state = blockEntity.getBlockState();
        Direction facing = (Direction)state.getValue((Property)AcaciaDrawerBlock.FACING);
        switch (facing) {
            case NORTH: {
                break;
            }
            case EAST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                break;
            }
            case SOUTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
        }
        poseStack.translate(0.0f, -1.0f, 0.0f);
        VertexConsumer builder = renderer.getBuffer(RenderType.entityCutout((ResourceLocation)this.texture));
        this.model.setupBlockEntityAnim(blockEntity, (float)blockEntity.getLevel().getGameTime() + partialTick);
        this.model.renderToBuffer(poseStack, builder, light, overlayLight);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)UnusualFurnitureModBlockEntities.ACACIA_DRAWER.get(), AcaciaDrawerRenderer::new);
    }

    private static final class CustomHierarchicalModel
    extends Modeljavadrawer {
        private final ModelPart root;
        private final BlockEntityHierarchicalModel animator = new BlockEntityHierarchicalModel();

        public CustomHierarchicalModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        public void setupBlockEntityAnim(AcaciaDrawerBlockEntity blockEntity, float ageInTicks) {
            this.animator.setupBlockEntityAnim(blockEntity, ageInTicks);
            super.setupAnim(null, 0.0f, 0.0f, ageInTicks, 0.0f, 0.0f);
        }

        public ModelPart getRoot() {
            return this.root;
        }

        private class BlockEntityHierarchicalModel
        extends HierarchicalModel<Entity> {
            private BlockEntityHierarchicalModel() {
            }

            public ModelPart root() {
                return CustomHierarchicalModel.this.root;
            }

            public void setupAnim(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            }

            public void setupBlockEntityAnim(AcaciaDrawerBlockEntity blockEntity, float ageInTicks) {
                CustomHierarchicalModel.this.animator.root().getAllParts().forEach(ModelPart::resetPose);
                CustomHierarchicalModel.this.animator.animate(blockEntity.animationState0, javadrawerAnimation.Open, ageInTicks, 1.0f);
                CustomHierarchicalModel.this.animator.animate(blockEntity.animationState1, javadrawerAnimation.Close, ageInTicks, 1.0f);
            }
        }
    }
}

