/*
 * Decompiled with CFR 0.152.
 */
package net.toopa.unusualfurniture.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.toopa.unusualfurniture.entity.SitEntity;
import net.toopa.unusualfurniture.entity.SitStoolsEntity;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class UnusualFurnitureModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"unusual_furniture");
    public static final DeferredHolder<EntityType<?>, EntityType<SitEntity>> SIT = UnusualFurnitureModEntities.register("sit", EntityType.Builder.of(SitEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().ridingOffset(-0.6f).sized(0.2f, 0.2f));
    public static final DeferredHolder<EntityType<?>, EntityType<SitStoolsEntity>> SIT_STOOLS = UnusualFurnitureModEntities.register("sit_stools", EntityType.Builder.of(SitStoolsEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().ridingOffset(-0.6f).sized(0.2f, 0.2f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        SitEntity.init(event);
        SitStoolsEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SIT.get(), SitEntity.createAttributes().build());
        event.put((EntityType)SIT_STOOLS.get(), SitStoolsEntity.createAttributes().build());
    }
}

