/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.component.types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import derekahedron.invexp.component.InvExpDataComponentTypes;
import derekahedron.invexp.item.QuiverItem;
import derekahedron.invexp.quiver.QuiverHelper;
import derekahedron.invexp.sack.SackDefaultManager;
import derekahedron.invexp.util.DataPackChangeDetector;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_3489;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuiverContentsComponent {
    public static final Codec<QuiverContentsComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1799.field_24671.listOf().fieldOf("contents").forGetter(QuiverContentsComponent::getStacks), (App)Codec.INT.optionalFieldOf("selected_index", (Object)-1).forGetter(QuiverContentsComponent::getSelectedIndex)).apply((Applicative)instance, QuiverContentsComponent::new));
    public static final class_9139<class_9129, QuiverContentsComponent> PACKET_CODEC = class_9139.method_56435((class_9139)class_1799.field_48349.method_56433(class_9135.method_56363()), QuiverContentsComponent::getStacks, (class_9139)class_9135.field_49675, QuiverContentsComponent::getSelectedIndex, QuiverContentsComponent::new);
    public static final QuiverContentsComponent DEFAULT = new QuiverContentsComponent();
    public final List<class_1799> stacks;
    public final int selectedIndex;
    private final ExtraData extraData;

    public QuiverContentsComponent(@NotNull List<class_1799> stacks, int selectedIndex) {
        this.stacks = stacks;
        this.selectedIndex = selectedIndex;
        this.extraData = new ExtraData();
    }

    public QuiverContentsComponent() {
        this(List.of(), -1);
    }

    @NotNull
    public List<class_1799> getStacks() {
        return this.stacks;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @NotNull
    public Fraction getTotalOccupancy() {
        this.extraData.sync();
        return this.extraData.totalOccupancy;
    }

    public boolean isValid() {
        this.extraData.sync();
        return this.extraData.isValid;
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    @NotNull
    public class_1799 getSelectedStack() {
        if (this.isEmpty()) {
            return class_1799.field_8037;
        }
        return this.stacks.get(this.selectedIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof QuiverContentsComponent) {
            QuiverContentsComponent component = (QuiverContentsComponent)o;
            if (this.selectedIndex != component.selectedIndex || this.stacks.size() != component.stacks.size()) {
                return false;
            }
            for (int i = 0; i < this.stacks.size(); ++i) {
                if (class_1799.method_7973((class_1799)this.stacks.get(i), (class_1799)component.stacks.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static QuiverContentsComponent getComponent(@Nullable class_1799 stack) {
        if (stack != null && !stack.method_7960() && stack.method_7909() instanceof QuiverItem) {
            return (QuiverContentsComponent)stack.method_58694(InvExpDataComponentTypes.QUIVER_CONTENTS);
        }
        return null;
    }

    private class ExtraData
    extends DataPackChangeDetector {
        Fraction totalOccupancy;
        boolean isValid;

        private ExtraData() {
        }

        @Override
        public void evaluate() {
            this.totalOccupancy = Fraction.ZERO;
            this.isValid = true;
            if (SackDefaultManager.getInstance() == null) {
                this.isValid = false;
                return;
            }
            for (class_1799 nestedStack : QuiverContentsComponent.this.stacks) {
                this.totalOccupancy = this.totalOccupancy.add(QuiverHelper.getOccupancyOfStack(nestedStack));
                if (nestedStack.method_31573(class_3489.field_18317)) continue;
                this.isValid = false;
            }
        }
    }
}

