/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.component.types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import derekahedron.invexp.component.InvExpDataComponentTypes;
import derekahedron.invexp.item.SackItem;
import derekahedron.invexp.sack.SackDefaultManager;
import derekahedron.invexp.sack.SackType;
import derekahedron.invexp.sack.SacksHelper;
import derekahedron.invexp.util.DataPackChangeDetector;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SackContentsComponent {
    public static final Codec<SackContentsComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SackType.ENTRY_CODEC.listOf().optionalFieldOf("sack_types", List.of()).forGetter(SackContentsComponent::getSackTypes), (App)class_1799.field_24671.listOf().fieldOf("contents").forGetter(SackContentsComponent::getStacks), (App)Codec.INT.optionalFieldOf("selected_index", (Object)-1).forGetter(SackContentsComponent::getSelectedIndex)).apply((Applicative)instance, SackContentsComponent::new));
    public static final class_9139<class_9129, SackContentsComponent> PACKET_CODEC = class_9139.method_56436((class_9139)SackType.ENTRY_PACKET_CODEC.method_56433(class_9135.method_56363()), SackContentsComponent::getSackTypes, (class_9139)class_1799.field_48349.method_56433(class_9135.method_56363()), SackContentsComponent::getStacks, (class_9139)class_9135.field_49675, SackContentsComponent::getSelectedIndex, SackContentsComponent::new);
    public static final SackContentsComponent DEFAULT = new SackContentsComponent();
    public static final SackContentsComponent EMPTY_OPEN = new SackContentsComponent();
    public final List<class_6880<SackType>> sackTypes;
    public final List<class_5321<SackType>> sackTypeKeys;
    public final List<class_1799> stacks;
    public final int selectedIndex;
    private final ExtraData extraData;
    public boolean isOpen = false;

    public SackContentsComponent(@NotNull List<class_6880<SackType>> sackTypes, @NotNull List<class_1799> stacks, int selectedIndex) {
        this(sackTypes.stream().filter(sackType -> sackType.method_40230().isPresent()).toList(), sackTypes.stream().map(class_6880::method_40230).filter(Optional::isPresent).map(Optional::get).toList(), stacks, selectedIndex);
    }

    public SackContentsComponent(@NotNull List<class_6880<SackType>> sackTypes, @NotNull List<class_5321<SackType>> sackTypeKeys, @NotNull List<class_1799> stacks, int selectedIndex) {
        this.sackTypes = sackTypes;
        this.sackTypeKeys = sackTypeKeys;
        this.stacks = stacks;
        this.selectedIndex = selectedIndex;
        this.extraData = new ExtraData();
    }

    public SackContentsComponent() {
        this(List.of(), List.of(), -1);
    }

    @NotNull
    public List<class_6880<SackType>> getSackTypes() {
        return this.sackTypes;
    }

    @NotNull
    public List<class_5321<SackType>> getSackTypeKeys() {
        return this.sackTypeKeys;
    }

    @NotNull
    public List<class_1799> getStacks() {
        return this.stacks;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public Fraction getTotalWeight() {
        this.extraData.sync();
        return this.extraData.totalWeight;
    }

    public boolean isValid() {
        this.extraData.sync();
        return this.extraData.isValid;
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    @NotNull
    public class_1799 getSelectedStack() {
        if (this.isEmpty()) {
            return class_1799.field_8037;
        }
        return this.stacks.get(this.selectedIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this == EMPTY_OPEN || o == EMPTY_OPEN) {
            return false;
        }
        if (o instanceof SackContentsComponent) {
            int i;
            SackContentsComponent component = (SackContentsComponent)o;
            if (this.selectedIndex != component.selectedIndex || this.stacks.size() != component.stacks.size() || this.sackTypes.size() != component.sackTypes.size()) {
                return false;
            }
            for (i = 0; i < this.sackTypes.size(); ++i) {
                if (this.sackTypes.get(i) == component.sackTypes.get(i)) continue;
                return false;
            }
            for (i = 0; i < this.stacks.size(); ++i) {
                if (class_1799.method_7973((class_1799)this.stacks.get(i), (class_1799)component.stacks.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static SackContentsComponent getComponent(@Nullable class_1799 stack) {
        if (stack != null && !stack.method_7960() && stack.method_7909() instanceof SackItem) {
            return (SackContentsComponent)stack.method_58694(InvExpDataComponentTypes.SACK_CONTENTS);
        }
        return null;
    }

    static {
        SackContentsComponent.EMPTY_OPEN.isOpen = true;
    }

    private class ExtraData
    extends DataPackChangeDetector {
        Fraction totalWeight;
        boolean isValid;

        private ExtraData() {
        }

        @Override
        public void evaluate() {
            this.totalWeight = Fraction.ZERO;
            this.isValid = true;
            if (SackDefaultManager.getInstance() == null) {
                this.isValid = false;
                return;
            }
            HashSet<class_2960> typeIdsInSack = new HashSet<class_2960>();
            HashSet<class_2960> typeIds = new HashSet<class_2960>(SackContentsComponent.this.getSackTypeKeys().stream().map(class_5321::method_29177).filter(Objects::nonNull).toList());
            for (class_1799 stack : SackContentsComponent.this.stacks) {
                this.totalWeight = this.totalWeight.add(SacksHelper.getSackWeightOfStack(stack));
                class_2960 typeId = SacksHelper.getSackTypeIdentifier(stack);
                if (typeId != null) {
                    this.isValid &= typeIds.contains(typeId);
                    typeIdsInSack.add(typeId);
                    continue;
                }
                this.isValid = false;
            }
            this.isValid &= typeIds.equals(typeIdsInSack);
        }
    }
}

