/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.gui.tooltip;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import net.minecraft.class_9334;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public interface ContainerItemTooltipComponent {
    public static final int DEFAULT_MAX_ROWS = 3;
    public static final int MIN_MAX_ROWS = 3;
    public static final int DEFAULT_SLOT_LENGTH = 24;
    public static final int DEFAULT_ROW_WIDTH = 4;
    public static final int DEFAULT_PROGRESS_BAR_PADDING = 4;
    public static final int DEFAULT_PROGRESS_BAR_HEIGHT = 13;
    public static final int EXTRA_ITEMS_TEXT_COLOR = 0xFFFFFF;
    public static final int PROGRESS_BAR_TEXT_COLOR = 0xFFFFFF;
    public static final int DESCRIPTION_TEXT_COLOR = 0xAAAAAA;

    default public int getTooltipWidth() {
        return this.getRowWidth() * this.getSlotLength();
    }

    default public int getMaxRows() {
        return 3;
    }

    default public int getRowWidth() {
        return 4;
    }

    default public int getSlotLength() {
        return 24;
    }

    default public int getProgressBarHeight() {
        return 13;
    }

    default public int getProgressBarPadding() {
        return 4;
    }

    @NotNull
    public List<class_1799> getStacks();

    public int getSelectedIndex();

    @NotNull
    public Fraction getFillFraction();

    @NotNull
    public class_2960 getProgressBarFillTexture();

    @NotNull
    public class_2960 getProgressBarBorderTexture();

    @NotNull
    public class_2960 getSlotBackgroundTexture();

    @NotNull
    public class_2960 getSlotHighlightBackTexture();

    @NotNull
    public class_2960 getSlotHighlightFrontTexture();

    @Nullable
    public class_2561 getProgressBarLabel();

    default public void drawContents(class_327 textRenderer, int x, int y, int width, int top, class_332 drawContext) {
        class_1799 selectedStack;
        int numRows = this.getNumRows();
        int maxRows = Math.max(this.getMaxRows(), 3);
        int prevVisibleRows = maxRows / 2;
        int nextVisibleRows = (maxRows - 1) / 2;
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex != -1) {
            selectedStack = this.getStacks().get(selectedIndex);
        } else {
            selectedStack = null;
            selectedIndex = 0;
        }
        int selectedRow = this.getRowForIndex(selectedIndex);
        if (selectedRow < prevVisibleRows) {
            selectedRow = prevVisibleRows;
        } else if (numRows - selectedRow - 1 < nextVisibleRows) {
            selectedRow = numRows - nextVisibleRows - 1;
        }
        ArrayList<class_1799> displayedStacks = new ArrayList<class_1799>(maxRows * this.getRowWidth());
        int seedStart = 0;
        int countPrev = 0;
        int countNext = 0;
        for (int i = 0; i < this.getStacks().size(); ++i) {
            int row = this.getRowForIndex(i);
            class_1799 stack = this.getStacks().get(i);
            if (row < selectedRow - prevVisibleRows) {
                ++seedStart;
                countPrev += stack.method_7947();
                continue;
            }
            if (row > selectedRow + nextVisibleRows) {
                countNext += stack.method_7947();
                continue;
            }
            displayedStacks.add(stack);
        }
        int endX = x + this.getXMargin(width) + this.getTooltipWidth();
        int endY = y + Math.min(numRows, maxRows) * this.getSlotLength();
        int itemPadding = (this.getSlotLength() - 16) / 2;
        for (int i = 0; i < displayedStacks.size(); ++i) {
            class_1799 stack = (class_1799)displayedStacks.get(displayedStacks.size() - 1 - i);
            int slotX = endX - (1 + i % this.getRowWidth()) * this.getSlotLength();
            int slotY = endY - (1 + i / this.getRowWidth()) * this.getSlotLength();
            if (i == displayedStacks.size() - 1 && countPrev > 0) {
                drawContext.method_25300(textRenderer, "+" + (countPrev += stack.method_7947()), slotX + this.getSlotLength() / 2, slotY + itemPadding + 6, 0xFFFFFF);
                continue;
            }
            if (i == 0 && countNext > 0) {
                drawContext.method_25300(textRenderer, "+" + (countNext += stack.method_7947()), slotX + this.getSlotLength() / 2, slotY + itemPadding + 6, 0xFFFFFF);
                continue;
            }
            if (stack == selectedStack) {
                drawContext.method_52706(class_1921::method_62277, this.getSlotHighlightBackTexture(), slotX, slotY, this.getSlotLength(), this.getSlotLength());
            } else {
                drawContext.method_52706(class_1921::method_62277, this.getSlotBackgroundTexture(), slotX, slotY, this.getSlotLength(), this.getSlotLength());
            }
            drawContext.method_51428(stack, slotX + itemPadding, slotY + itemPadding, seedStart + displayedStacks.size() - 1 - i);
            drawContext.method_51431(textRenderer, stack, slotX + itemPadding, slotY + itemPadding);
            if (stack != selectedStack) continue;
            drawContext.method_52706(class_1921::method_62275, this.getSlotHighlightFrontTexture(), slotX, slotY, this.getSlotLength(), this.getSlotLength());
        }
        if (selectedStack != null) {
            class_2561 name = selectedStack.method_63015();
            int nameX = x + (width - textRenderer.method_30880(name.method_30937())) / 2 - 12;
            int nameY = top - 15;
            drawContext.method_64235(textRenderer, name, nameX, nameY, (class_2960)selectedStack.method_58694(class_9334.field_54198));
        }
    }

    default public int getRowForIndex(int index) {
        int emptySpaces = this.getRowWidth() - (1 + (this.getStacks().size() - 1) % this.getRowWidth());
        return (index + emptySpaces) / this.getRowWidth();
    }

    default public int getNumRows() {
        return 1 + (this.getStacks().size() - 1) / this.getRowWidth();
    }

    default public int getProgressBarFill() {
        int progressBarWidth = this.getTooltipWidth() - 2;
        return class_3532.method_15340((int)class_3532.method_59515((Fraction)this.getFillFraction(), (int)progressBarWidth), (int)0, (int)progressBarWidth);
    }

    default public void drawProgressBar(@NotNull class_327 textRenderer, int x, int y, int width, @NotNull class_332 drawContext) {
        drawContext.method_52706(class_1921::method_62277, this.getProgressBarFillTexture(), (x += this.getXMargin(width)) + 1, y, this.getProgressBarFill(), this.getProgressBarHeight());
        drawContext.method_52706(class_1921::method_62277, this.getProgressBarBorderTexture(), x, y, this.getTooltipWidth(), this.getProgressBarHeight());
        class_2561 progressBarLabel = this.getProgressBarLabel();
        if (progressBarLabel != null) {
            int n = x + this.getTooltipWidth() / 2;
            int n2 = this.getProgressBarHeight();
            Objects.requireNonNull(textRenderer);
            drawContext.method_27534(textRenderer, progressBarLabel, n, y + (n2 - (9 - 2)) / 2, 0xFFFFFF);
        }
    }

    default public int getContentsHeight() {
        return Math.min(this.getNumRows(), Math.max(this.getMaxRows(), 3)) * this.getSlotLength();
    }

    default public int getXMargin(int width) {
        return (width - this.getTooltipWidth()) / 2;
    }

    default public int getHeight(@Nullable class_2561 text, @NotNull class_327 textRenderer) {
        if (text == null) {
            return 0;
        }
        int n = textRenderer.method_1728((class_5348)text, this.getTooltipWidth()).size();
        Objects.requireNonNull(textRenderer);
        return n * 9;
    }
}

