/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.gui.tooltip;

import derekahedron.invexp.gui.tooltip.ContainerItemTooltipComponent;
import derekahedron.invexp.quiver.QuiverContentsReader;
import derekahedron.invexp.util.InvExpUtil;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public record QuiverTooltipComponent(QuiverContentsReader contents) implements class_5684,
ContainerItemTooltipComponent
{
    public static final class_2960 QUIVER_PROGRESS_BAR_BORDER_TEXTURE = InvExpUtil.identifier("container/quiver/quiver_progressbar_border");
    public static final class_2960 QUIVER_PROGRESS_BAR_FILL_TEXTURE = InvExpUtil.identifier("container/quiver/quiver_progressbar_fill");
    public static final class_2960 QUIVER_PROGRESS_BAR_FULL_TEXTURE = InvExpUtil.identifier("container/quiver/quiver_progressbar_full");
    public static final class_2960 QUIVER_SLOT_HIGHLIGHT_BACK_TEXTURE = InvExpUtil.identifier("container/quiver/slot_highlight_back");
    public static final class_2960 QUIVER_SLOT_HIGHLIGHT_FRONT_TEXTURE = InvExpUtil.identifier("container/quiver/slot_highlight_front");
    public static final class_2960 QUIVER_SLOT_BACKGROUND_TEXTURE = InvExpUtil.identifier("container/quiver/slot_background");
    public static final class_2561 QUIVER_FULL = class_2561.method_43471((String)"item.invexp.quiver.full");
    public static final class_2561 QUIVER_EMPTY = class_2561.method_43471((String)"item.invexp.quiver.empty");
    public static final class_2561 QUIVER_TOO_MANY_STACKS = class_2561.method_43471((String)"item.invexp.quiver.too_many_stacks");
    public static final class_2561 QUIVER_EMPTY_DESCRIPTION = class_2561.method_43471((String)"item.invexp.quiver.description.empty");
    public static final String QUIVER_EMPTY_DESCRIPTION_PLURAL = "item.invexp.quiver.description.empty.plural";

    public void method_32666(@NotNull class_327 textRenderer, int x, int y, int width, int height, @NotNull class_332 drawContext) {
        int top = y;
        if (this.contents.isEmpty()) {
            class_2561 quiverEmptyDescription = this.getQuiverEmptyDescription();
            drawContext.method_65179(textRenderer, (class_5348)quiverEmptyDescription, x + this.getXMargin(width), y, this.getTooltipWidth(), 0xAAAAAA);
            y += this.getHeight(quiverEmptyDescription, textRenderer);
        } else {
            this.drawContents(textRenderer, x, y, width, top, drawContext);
            y += this.getContentsHeight();
        }
        this.drawProgressBar(textRenderer, x, y += this.getProgressBarPadding(), width, drawContext);
    }

    public int method_32664(@Nullable class_327 textRenderer) {
        return this.getTooltipWidth();
    }

    public int method_32661(@NotNull class_327 textRenderer) {
        int height = 0;
        height = this.contents.isEmpty() ? (height += this.getHeight(this.getQuiverEmptyDescription(), textRenderer)) : (height += this.getContentsHeight());
        height += this.getProgressBarPadding();
        height += this.getProgressBarHeight();
        return height += this.getProgressBarPadding();
    }

    public boolean method_62003() {
        return true;
    }

    @NotNull
    public class_2561 getQuiverEmptyDescription() {
        Fraction maxStacks = this.contents.getMaxQuiverOccupancy();
        if (!maxStacks.equals((Object)Fraction.ONE)) {
            return class_2561.method_43469((String)QUIVER_EMPTY_DESCRIPTION_PLURAL, (Object[])new Object[]{maxStacks.toProperString()});
        }
        return QUIVER_EMPTY_DESCRIPTION;
    }

    @Override
    @NotNull
    public List<class_1799> getStacks() {
        return this.contents.getStacks();
    }

    @Override
    public int getSelectedIndex() {
        return this.contents.getSelectedIndex();
    }

    @Override
    @NotNull
    public Fraction getFillFraction() {
        return this.contents.getFillFraction();
    }

    @Override
    @NotNull
    public class_2960 getProgressBarFillTexture() {
        if (this.contents.isFull()) {
            return QUIVER_PROGRESS_BAR_FULL_TEXTURE;
        }
        return QUIVER_PROGRESS_BAR_FILL_TEXTURE;
    }

    @Override
    @NotNull
    public class_2960 getProgressBarBorderTexture() {
        return QUIVER_PROGRESS_BAR_BORDER_TEXTURE;
    }

    @Override
    @NotNull
    public class_2960 getSlotBackgroundTexture() {
        return QUIVER_SLOT_BACKGROUND_TEXTURE;
    }

    @Override
    @NotNull
    public class_2960 getSlotHighlightBackTexture() {
        return QUIVER_SLOT_HIGHLIGHT_BACK_TEXTURE;
    }

    @Override
    @NotNull
    public class_2960 getSlotHighlightFrontTexture() {
        return QUIVER_SLOT_HIGHLIGHT_FRONT_TEXTURE;
    }

    @Override
    @Nullable
    public class_2561 getProgressBarLabel() {
        if (this.contents.getTotalOccupancy().compareTo(this.contents.getMaxQuiverOccupancy()) >= 0) {
            return QUIVER_FULL;
        }
        if (this.getStacks().size() >= this.contents.getMaxQuiverStacks()) {
            return QUIVER_TOO_MANY_STACKS;
        }
        if (this.contents.isEmpty()) {
            return QUIVER_EMPTY;
        }
        return null;
    }
}

