/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.gui.tooltip;

import derekahedron.invexp.gui.tooltip.ContainerItemTooltipComponent;
import derekahedron.invexp.sack.SackContentsReader;
import derekahedron.invexp.util.InvExpUtil;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import net.minecraft.class_6880;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public record SackTooltipComponent(SackContentsReader contents) implements class_5684,
ContainerItemTooltipComponent
{
    public static final class_2960 SACK_PROGRESS_BAR_BORDER_TEXTURE = InvExpUtil.identifier("container/sack/sack_progressbar_border");
    public static final class_2960 SACK_PROGRESS_BAR_FILL_TEXTURE = InvExpUtil.identifier("container/sack/sack_progressbar_fill");
    public static final class_2960 SACK_PROGRESS_BAR_FULL_TEXTURE = InvExpUtil.identifier("container/sack/sack_progressbar_full");
    public static final class_2960 SACK_SLOT_HIGHLIGHT_BACK_TEXTURE = InvExpUtil.identifier("container/sack/slot_highlight_back");
    public static final class_2960 SACK_SLOT_HIGHLIGHT_FRONT_TEXTURE = InvExpUtil.identifier("container/sack/slot_highlight_front");
    public static final class_2960 SACK_SLOT_BACKGROUND_TEXTURE = InvExpUtil.identifier("container/sack/slot_background");
    public static final class_2561 SACK_FULL = class_2561.method_43471((String)"item.invexp.sack.full");
    public static final class_2561 SACK_EMPTY = class_2561.method_43471((String)"item.invexp.sack.empty");
    public static final class_2561 SACK_TOO_MANY_STACKS = class_2561.method_43471((String)"item.invexp.sack.too_many_stacks");
    public static final String SACK_PARTIAL = "item.invexp.sack.partial";
    public static final class_2561 SACK_EMPTY_DESCRIPTION = class_2561.method_43471((String)"item.invexp.sack.description.empty");
    public static final String SACK_EMPTY_DESCRIPTION_PLURAL = "item.invexp.sack.description.empty.plural";
    public static final String SACK_TYPE_DESCRIPTION = "item.invexp.sack.description.type";
    public static final String SACK_TYPE_DESCRIPTION_CONJUNCTION = "item.invexp.sack.description.type.conjunction";
    public static final String SACK_TYPE_DESCRIPTION_MANY_CONJUNCTION = "item.invexp.sack.description.type.many.conjunction";
    public static final String SACK_TYPE_DESCRIPTION_MANY_LAST_CONJUNCTION = "item.invexp.sack.description.type.many.last_conjunction";

    public void method_32666(@NotNull class_327 textRenderer, int x, int y, int width, int height, @NotNull class_332 drawContext) {
        int top = y;
        if (this.contents.isEmpty()) {
            class_2561 sackEmptyDescription = this.getSackEmptyDescription();
            drawContext.method_65179(textRenderer, (class_5348)sackEmptyDescription, x + this.getXMargin(width), y, this.getTooltipWidth(), 0xAAAAAA);
            y += this.getHeight(sackEmptyDescription, textRenderer);
        } else {
            class_2561 sackTypeDescription = this.getSackTypeDescription();
            if (sackTypeDescription != null) {
                drawContext.method_65179(textRenderer, (class_5348)sackTypeDescription, x + this.getXMargin(width), y, this.getTooltipWidth(), 0xAAAAAA);
                y += this.getHeight(sackTypeDescription, textRenderer);
            }
            this.drawContents(textRenderer, x, y, width, top, drawContext);
            y += this.getContentsHeight();
        }
        this.drawProgressBar(textRenderer, x, y += this.getProgressBarPadding(), width, drawContext);
    }

    public int method_32664(@Nullable class_327 textRenderer) {
        return this.getTooltipWidth();
    }

    public int method_32661(@NotNull class_327 textRenderer) {
        int height = 0;
        if (this.contents.isEmpty()) {
            height += this.getHeight(this.getSackEmptyDescription(), textRenderer);
        } else {
            height += this.getHeight(this.getSackTypeDescription(), textRenderer);
            height += this.getContentsHeight();
        }
        height += this.getProgressBarPadding();
        height += this.getProgressBarHeight();
        return height += this.getProgressBarPadding();
    }

    public boolean method_62003() {
        return true;
    }

    @NotNull
    public class_2561 getSackEmptyDescription() {
        Fraction maxWeight = this.contents.getMaxSackWeight();
        if (!maxWeight.equals((Object)Fraction.ONE)) {
            return class_2561.method_43469((String)SACK_EMPTY_DESCRIPTION_PLURAL, (Object[])new Object[]{maxWeight.toProperString()});
        }
        return SACK_EMPTY_DESCRIPTION;
    }

    @Nullable
    public class_2561 getSackTypeDescription() {
        Object description = null;
        List<class_5250> names = this.contents.getSackTypes().stream().map(class_6880::method_40230).filter(Optional::isPresent).map(Optional::get).map(class_5321::method_29177).map(id -> class_2561.method_43471((String)("sack_type." + id.method_12836() + "." + id.method_12832()))).toList();
        for (int i = 0; i < names.size(); ++i) {
            class_2561 name = (class_2561)names.get(i);
            description = description == null ? name : (i != names.size() - 1 ? class_2561.method_43469((String)SACK_TYPE_DESCRIPTION_MANY_CONJUNCTION, (Object[])new Object[]{description, name}) : (names.size() == 2 ? class_2561.method_43469((String)SACK_TYPE_DESCRIPTION_CONJUNCTION, (Object[])new Object[]{description, name}) : class_2561.method_43469((String)SACK_TYPE_DESCRIPTION_MANY_LAST_CONJUNCTION, (Object[])new Object[]{description, name})));
        }
        if (description != null) {
            description = class_2561.method_43469((String)SACK_TYPE_DESCRIPTION, (Object[])new Object[]{description});
        }
        return description;
    }

    @Override
    @NotNull
    public List<class_1799> getStacks() {
        return this.contents.getStacks();
    }

    @Override
    public int getSelectedIndex() {
        return this.contents.getSelectedIndex();
    }

    @Override
    @NotNull
    public Fraction getFillFraction() {
        return this.contents.getFillFraction();
    }

    @Override
    @NotNull
    public class_2960 getProgressBarFillTexture() {
        if (this.contents.isFull()) {
            return SACK_PROGRESS_BAR_FULL_TEXTURE;
        }
        return SACK_PROGRESS_BAR_FILL_TEXTURE;
    }

    @Override
    @NotNull
    public class_2960 getProgressBarBorderTexture() {
        return SACK_PROGRESS_BAR_BORDER_TEXTURE;
    }

    @Override
    @NotNull
    public class_2960 getSlotBackgroundTexture() {
        return SACK_SLOT_BACKGROUND_TEXTURE;
    }

    @Override
    @NotNull
    public class_2960 getSlotHighlightBackTexture() {
        return SACK_SLOT_HIGHLIGHT_BACK_TEXTURE;
    }

    @Override
    @NotNull
    public class_2960 getSlotHighlightFrontTexture() {
        return SACK_SLOT_HIGHLIGHT_FRONT_TEXTURE;
    }

    @Override
    @NotNull
    public class_2561 getProgressBarLabel() {
        if (this.contents.getTotalWeight().compareTo(this.contents.getMaxSackWeight()) >= 0) {
            return SACK_FULL;
        }
        if (this.getStacks().size() >= this.contents.getMaxSackStacks()) {
            return SACK_TOO_MANY_STACKS;
        }
        if (this.contents.isEmpty()) {
            return SACK_EMPTY;
        }
        return class_2561.method_43469((String)SACK_PARTIAL, (Object[])new Object[]{SackTooltipComponent.formatWeight(this.contents.getTotalWeight()), SackTooltipComponent.formatWeight(this.contents.getMaxSackWeight())});
    }

    @NotNull
    public static class_5250 formatWeight(Fraction weight) {
        if ((weight = weight.multiplyBy(Fraction.getFraction((double)64.0))).getNumerator() % weight.getDenominator() == 0) {
            return class_2561.method_43470((String)String.valueOf(weight.intValue()));
        }
        return class_2561.method_43470((String)String.format("%.2f", Float.valueOf(weight.floatValue())));
    }
}

