/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.item;

import derekahedron.invexp.component.InvExpDataComponentTypes;
import derekahedron.invexp.item.tooltip.SackTooltipData;
import derekahedron.invexp.sack.SackContents;
import derekahedron.invexp.sack.SackContentsReader;
import derekahedron.invexp.sound.InvExpSoundEvents;
import derekahedron.invexp.util.InvExpUtil;
import java.util.Optional;
import net.minecraft.class_10712;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5328;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.minecraft.class_9334;
import net.minecraft.class_9848;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SackItem
extends class_1792 {
    public static final int FULL_ITEM_BAR_COLOR = class_9848.method_61318((float)1.0f, (float)1.0f, (float)0.33f, (float)0.33f);
    public static final int ITEM_BAR_COLOR = class_9848.method_61318((float)1.0f, (float)0.44f, (float)0.53f, (float)1.0f);

    public SackItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public boolean method_31565(class_1799 sackStack, class_1735 slot, class_5536 clickType, class_1657 player) {
        SackContents contents = SackContents.of(sackStack, player.method_37908());
        if (contents == null) {
            return false;
        }
        class_1799 otherStack = slot.method_7677();
        if (clickType == class_5536.field_27013 && !otherStack.method_7960()) {
            if (!contents.canTryInsert(otherStack)) {
                return false;
            }
            if (contents.add(slot, player) > 0) {
                SackItem.playInsertSound((class_1297)player);
                InvExpUtil.onContentChanged(player);
                return true;
            }
            SackItem.playInsertFailSound((class_1297)player);
            return true;
        }
        if (clickType == class_5536.field_27014 && otherStack.method_7960()) {
            if (contents.popSelectedStack(slot)) {
                SackItem.playRemoveOneSound((class_1297)player);
                InvExpUtil.onContentChanged(player);
            }
            return true;
        }
        return false;
    }

    public boolean method_31566(class_1799 sackStack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        SackContents contents = SackContents.of(sackStack, player.method_37908());
        if (contents == null) {
            return false;
        }
        if (clickType == class_5536.field_27013 && !otherStack.method_7960()) {
            if (!contents.canTryInsert(otherStack)) {
                return false;
            }
            if (contents.add(otherStack) > 0) {
                SackItem.playInsertSound((class_1297)player);
                InvExpUtil.onContentChanged(player);
                return true;
            }
            SackItem.playInsertFailSound((class_1297)player);
            return true;
        }
        if (clickType == class_5536.field_27014 && otherStack.method_7960() && slot.method_32754(player)) {
            class_1799 poppedStack = contents.popSelectedStack();
            if (!poppedStack.method_7960()) {
                cursorStackReference.method_32332(poppedStack);
                SackItem.playRemoveOneSound((class_1297)player);
            }
            return true;
        }
        return false;
    }

    public class_1839 method_7853(class_1799 sackStack) {
        SackContentsReader contents = SackContents.of(sackStack);
        if (contents == null || contents.isEmpty()) {
            return super.method_7853(sackStack);
        }
        return contents.getSelectedStack().method_7976();
    }

    public int method_7881(class_1799 sackStack, class_1309 user) {
        SackContentsReader contents = SackContents.of(sackStack);
        if (contents == null || contents.isEmpty()) {
            return super.method_7881(sackStack, user);
        }
        return contents.getSelectedStack().method_7935(user);
    }

    public boolean method_31567(class_1799 sackStack) {
        SackContentsReader contents = SackContents.of(sackStack);
        return contents != null && !contents.isEmpty();
    }

    public int method_31569(class_1799 sackStack) {
        SackContentsReader contents = SackContents.of(sackStack);
        if (contents == null) {
            return 0;
        }
        return Math.min(13, 1 + class_3532.method_59515((Fraction)contents.getFillFraction(), (int)12));
    }

    public int method_31571(class_1799 sackStack) {
        SackContentsReader contents = SackContents.of(sackStack);
        if (contents == null || contents.getTotalWeight().compareTo(contents.getMaxSackWeight()) < 0) {
            return ITEM_BAR_COLOR;
        }
        return FULL_ITEM_BAR_COLOR;
    }

    public Optional<class_5632> method_32346(class_1799 sackStack) {
        SackContentsReader contents;
        class_10712 tooltipDisplayComponent = (class_10712)sackStack.method_58695(class_9334.field_56400, (Object)class_10712.field_56318);
        if (tooltipDisplayComponent.method_67214(InvExpDataComponentTypes.SACK_CONTENTS) && (contents = SackContents.of(sackStack)) != null) {
            return Optional.of(new SackTooltipData(contents));
        }
        return Optional.empty();
    }

    public void method_33261(@NotNull class_1542 entity) {
        SackContents contents = SackContents.of(entity.method_6983(), entity.method_37908());
        if (contents == null || contents.isEmpty()) {
            return;
        }
        class_5328.method_33263((class_1542)entity, contents.popAllStacks());
    }

    public void method_7888(class_1799 sackStack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            SackContents contents = SackContents.of(sackStack, (class_1937)world);
            if (contents == null) {
                return;
            }
            contents.validate(player);
            if (contents.isEmpty()) {
                return;
            }
            class_1799 selectedStack = contents.copySelectedStack();
            selectedStack.method_7909().method_7888(selectedStack, world, entity, slot);
            contents.updateSelectedStack(selectedStack, arg_0 -> ((class_1657)player).method_64399(arg_0));
        }
    }

    public static void playRemoveOneSound(@NotNull class_1297 entity) {
        entity.method_5783(InvExpSoundEvents.ITEM_SACK_REMOVE_ONE, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    public static void playInsertSound(@NotNull class_1297 entity) {
        entity.method_5783(InvExpSoundEvents.ITEM_SACK_INSERT, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    public static void playInsertFailSound(@NotNull class_1297 entity) {
        entity.method_5783(InvExpSoundEvents.ITEM_SACK_INSERT_FAIL, 1.0f, 1.0f);
    }
}

