/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import derekahedron.invexp.entity.player.PlayerEntityDuck;
import derekahedron.invexp.quiver.QuiverContents;
import derekahedron.invexp.sack.SackContents;
import derekahedron.invexp.sack.SackContentsReader;
import derekahedron.invexp.sack.SackUsage;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
implements PlayerEntityDuck {
    @Unique
    private boolean usingSack = false;
    @Unique
    private SackUsage mainHandSackUsage;
    @Unique
    private SackUsage offHandSackUsage;

    @Override
    public boolean invexp$isUsingSack() {
        return this.usingSack;
    }

    @Override
    public void invexp$startUsingSack() {
        int i;
        if (this.usingSack) {
            this.invexp$stopUsingSack();
        }
        class_1657 self = (class_1657)this;
        SackUsage[] usages = new SackUsage[class_1268.values().length];
        for (i = 0; i < class_1268.values().length; ++i) {
            class_1799 heldStack = self.method_5998(class_1268.values()[i]);
            SackContentsReader contents = SackContents.of(heldStack);
            if (contents == null || contents.isEmpty()) continue;
            SackUsage usage = this.invexp$getUsageForSackStack(heldStack);
            usages[i] = usage != null ? new SackUsage(contents, usage.selectedStack) : new SackUsage(contents);
        }
        for (i = 0; i < class_1268.values().length; ++i) {
            this.setUsageByHand(class_1268.values()[i], usages[i]);
        }
        this.usingSack = true;
    }

    @Override
    public void invexp$stopUsingSack() {
        if (!this.usingSack) {
            return;
        }
        ArrayList leftoverStacks = new ArrayList();
        class_1657 self = (class_1657)this;
        for (class_1268 hand : class_1268.values()) {
            SackUsage usage = this.getUsageByHand(hand);
            if (usage == null) continue;
            usage.update((class_1297)self, leftoverStacks::add);
        }
        this.usingSack = false;
        for (class_1799 leftoverStack : leftoverStacks) {
            if (leftoverStack.method_7960()) continue;
            self.method_64399(leftoverStack);
        }
    }

    @Override
    public SackUsage invexp$getUsageForSackStack(class_1799 sackStack) {
        for (class_1268 hand : class_1268.values()) {
            SackUsage usage = this.getUsageByHand(hand);
            if (usage == null || usage.sackStack != sackStack) continue;
            return usage;
        }
        return null;
    }

    @Override
    public SackUsage invexp$getUsageForSelectedStack(class_1799 selectedStack) {
        for (class_1268 hand : class_1268.values()) {
            SackUsage usage = this.getUsageByHand(hand);
            if (usage == null || usage.selectedStack != selectedStack) continue;
            return usage;
        }
        return null;
    }

    @Unique
    private void setUsageByHand(@NotNull class_1268 hand, @Nullable SackUsage usage) {
        switch (hand) {
            case field_5808: {
                this.mainHandSackUsage = usage;
                break;
            }
            case field_5810: {
                this.offHandSackUsage = usage;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid hand " + String.valueOf(hand));
            }
        }
    }

    @Unique
    private SackUsage getUsageByHand(@NotNull class_1268 hand) {
        switch (hand) {
            case field_5808: {
                return this.mainHandSackUsage;
            }
            case field_5810: {
                return this.offHandSackUsage;
            }
        }
        throw new IllegalArgumentException("Invalid hand " + String.valueOf(hand));
    }

    @Inject(method={"getProjectileType"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/RangedWeaponItem;getProjectiles()Ljava/util/function/Predicate;", shift=At.Shift.AFTER)}, cancellable=true)
    private void getQuiveredProjectile(class_1799 stack, @NotNull CallbackInfoReturnable<class_1799> cir, @Local Predicate<class_1799> predicate) {
        class_1657 self = (class_1657)this;
        for (int i = 0; i < self.method_31548().method_5439(); ++i) {
            class_1799 projectile;
            QuiverContents contents = QuiverContents.of(self.method_31548().method_5438(i));
            if (contents == null || (projectile = contents.getProjectileStack(predicate)).method_7960()) continue;
            cir.setReturnValue((Object)projectile);
            return;
        }
    }
}

