/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.mixin.client;

import derekahedron.invexp.component.types.SackContentsComponent;
import derekahedron.invexp.sack.ImmutableSackContents;
import derekahedron.invexp.util.ContainerItemSlotDragger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import net.minecraft.class_465;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_465.class})
public class HandledScreenMixin {
    @Unique
    private class_1735 currentSlot;
    @Unique
    private boolean hasMoved;
    @Unique
    private SackContentsComponent openContentsComponent;

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")})
    private void startDraggingContainer(double mouseX, double mouseY, int button, @NotNull CallbackInfoReturnable<Boolean> cir) {
        class_465 self = (class_465)this;
        if (ContainerItemSlotDragger.of(self.method_17577().method_34255()) != null) {
            this.currentSlot = self.method_64240(mouseX, mouseY);
            this.hasMoved = false;
        }
    }

    @Inject(method={"mouseDragged"}, at={@At(value="HEAD")}, cancellable=true)
    private void dragContainer(double mouseX, double mouseY, int button, double deltaX, double deltaY, @NotNull CallbackInfoReturnable<Boolean> cir) {
        class_465 self = (class_465)this;
        if (self.field_2790 == 2 || !self.field_2794 || self.field_2777 != null || self.field_22787 == null || ((Boolean)self.field_22787.field_1690.field_1854.method_41753()).booleanValue()) {
            return;
        }
        class_1735 slot = self.method_64240(mouseX, mouseY);
        if (slot == null) {
            return;
        }
        class_1799 cursorStack = self.method_17577().method_34255();
        ContainerItemSlotDragger dragger = ContainerItemSlotDragger.of(cursorStack);
        if (dragger == null) {
            return;
        }
        if (this.currentSlot == null) {
            this.currentSlot = slot;
        } else if (this.currentSlot != slot) {
            if (!this.hasMoved) {
                this.hasMoved = true;
                self.field_2793.clear();
                dragger.onHover(this.currentSlot, self);
            }
            this.currentSlot = slot;
            dragger.onHover(this.currentSlot, self);
        }
        cir.setReturnValue((Object)true);
        cir.cancel();
    }

    @Inject(method={"mouseReleased"}, at={@At(value="HEAD")}, cancellable=true)
    private void finishDraggingContainer(double mouseX, double mouseY, int button, @NotNull CallbackInfoReturnable<Boolean> cir) {
        class_465 self = (class_465)this;
        if (this.hasMoved && ContainerItemSlotDragger.of(self.method_17577().method_34255()) != null) {
            this.hasMoved = false;
            this.currentSlot = null;
            self.field_2794 = false;
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @Inject(method={"drawSlot"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawItem(Lnet/minecraft/item/ItemStack;III)V")})
    private void drawOpenSack(class_332 context, @NotNull class_1735 slot, @NotNull CallbackInfo ci) {
        this.openContentsComponent = null;
        class_465 self = (class_465)this;
        class_1799 stack = slot.method_7677();
        if (slot.method_55059() || self.field_22787 == null || self.field_2787 == null || self.field_2787.method_7677() != stack || !self.method_17577().method_7615(slot)) {
            return;
        }
        class_1799 cursorStack = self.method_17577().method_34255();
        ImmutableSackContents contents = ImmutableSackContents.of(stack);
        if (contents == null || contents.isEmpty() || !cursorStack.method_7960() && !contents.canTryInsert(cursorStack)) {
            return;
        }
        this.openContentsComponent = contents.component;
        this.openContentsComponent.isOpen = true;
    }

    @Inject(method={"drawSlot"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawItem(Lnet/minecraft/item/ItemStack;III)V", shift=At.Shift.AFTER)})
    private void finishDrawingOpenSack(class_332 context, class_1735 slot, @NotNull CallbackInfo ci) {
        if (this.openContentsComponent != null) {
            this.openContentsComponent.isOpen = false;
        }
        this.openContentsComponent = null;
    }
}

