/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.quiver;

import com.google.common.collect.Lists;
import derekahedron.invexp.component.InvExpDataComponentTypes;
import derekahedron.invexp.component.types.QuiverContentsComponent;
import derekahedron.invexp.item.QuiveredItemStack;
import derekahedron.invexp.quiver.QuiverContentsReader;
import derekahedron.invexp.quiver.QuiverHelper;
import derekahedron.invexp.util.ContainerItemContents;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuiverContents
extends ContainerItemContents
implements QuiverContentsReader {
    public final class_1799 quiverStack;
    private QuiverContentsComponent component;

    private QuiverContents(@NotNull class_1799 quiverStack, @NotNull QuiverContentsComponent component) {
        this.quiverStack = quiverStack;
        this.component = component;
    }

    @Nullable
    public static QuiverContents of(@Nullable class_1799 quiverStack) {
        QuiverContentsComponent component = QuiverContentsComponent.getComponent(quiverStack);
        if (component == null) {
            return null;
        }
        return new QuiverContents(quiverStack, component);
    }

    @NotNull
    public class_1799 getProjectileStack(@NotNull Predicate<class_1799> predicate) {
        if (this.isEmpty()) {
            return class_1799.field_8037;
        }
        class_1799 selectedStack = this.getSelectedStack();
        if (!predicate.test(selectedStack)) {
            return class_1799.field_8037;
        }
        for (int i = this.component.stacks.size() - 1; i >= 0; --i) {
            class_1799 nestedStack = this.component.stacks.get(i);
            if (!class_1799.method_31577((class_1799)selectedStack, (class_1799)nestedStack)) continue;
            return new QuiveredItemStack(nestedStack, this.quiverStack);
        }
        return new QuiveredItemStack(selectedStack, this.quiverStack);
    }

    public boolean isValid() {
        if (!this.component.isValid()) {
            return false;
        }
        return this.getTotalOccupancy().compareTo(this.getMaxQuiverOccupancy()) <= 0 && this.getStacks().size() <= this.getMaxQuiverStacks();
    }

    public void validate(@NotNull class_1657 player) {
        if (this.isValid()) {
            return;
        }
        ArrayList<class_1799> removedStacks = new ArrayList<class_1799>(this.getStacks().size());
        QuiverContents newContents = new QuiverContents(this.quiverStack, QuiverContentsComponent.DEFAULT);
        Builder builder = newContents.getBuilder();
        for (int i = this.getStacks().size() - 1; i >= 0; --i) {
            class_1799 stack = this.getStacks().get(i).method_7972();
            builder.add(stack, 0);
            if (stack.method_7960()) continue;
            removedStacks.add(stack);
        }
        builder.selectedIndex = builder.nextSelectedIndex(this.getSelectedStack(), this.getSelectedIndex());
        builder.apply();
        this.component = newContents.component;
        for (class_1799 stack : removedStacks) {
            player.method_64399(stack);
        }
    }

    @Override
    @NotNull
    public List<class_1799> getStacks() {
        return this.component.stacks;
    }

    @Override
    public int getSelectedIndex() {
        return this.component.selectedIndex;
    }

    @Override
    @NotNull
    public class_1799 getQuiverStack() {
        return this.quiverStack;
    }

    @Override
    @NotNull
    public Fraction getTotalOccupancy() {
        return this.component.getTotalOccupancy();
    }

    @Override
    @NotNull
    public Builder getBuilder() {
        return new Builder();
    }

    public static boolean attemptPickup(@NotNull class_1799 quiverStack, @NotNull class_1799 stack) {
        QuiverContents contents = QuiverContents.of(quiverStack);
        if (contents == null) {
            return false;
        }
        contents.add(stack);
        return stack.method_7960();
    }

    public class Builder
    extends ContainerItemContents.Builder
    implements QuiverContentsReader {
        public final List<class_1799> stacks;
        public int selectedIndex;
        public Fraction totalOccupancy;

        public Builder() {
            this.stacks = new ArrayList<class_1799>(QuiverContents.this.component.getStacks());
            this.selectedIndex = QuiverContents.this.component.selectedIndex;
            this.totalOccupancy = QuiverContents.this.component.getTotalOccupancy();
        }

        @Override
        public void apply() {
            QuiverContents.this.component = new QuiverContentsComponent(List.copyOf(this.stacks), this.clampIndex(this.selectedIndex));
            QuiverContents.this.quiverStack.method_57379(InvExpDataComponentTypes.QUIVER_CONTENTS, (Object)QuiverContents.this.component);
        }

        @Override
        public int add(@NotNull class_1799 stack, int insertAt) {
            if (!this.canTryInsert(stack)) {
                return 0;
            }
            Fraction occupancy = QuiverHelper.getOccupancy(stack);
            int added = 0;
            int toAdd = Math.min(stack.method_7947(), this.getMaxAllowedByOccupancy(stack));
            if (toAdd > 0) {
                for (int i = 0; i < this.stacks.size(); ++i) {
                    class_1799 nestedStack = this.stacks.get(i);
                    if (!class_1799.method_31577((class_1799)stack, (class_1799)nestedStack)) continue;
                    int amount = Math.min(toAdd, nestedStack.method_7914() - nestedStack.method_7947());
                    if (amount > 0) {
                        this.stacks.set(i, nestedStack.method_46651(nestedStack.method_7947() + amount));
                        stack.method_7934(amount);
                        toAdd -= amount;
                        added += amount;
                        this.totalOccupancy = this.totalOccupancy.add(occupancy.multiplyBy(Fraction.getFraction((double)amount)));
                    }
                    if (toAdd > 0) continue;
                    return added;
                }
                if (this.canAddStack()) {
                    ++this.selectedIndex;
                    added += toAdd;
                    class_1799 newStack = stack.method_7971(toAdd);
                    this.totalOccupancy = this.totalOccupancy.add(QuiverHelper.getOccupancyOfStack(newStack));
                    this.stacks.addFirst(newStack);
                }
            }
            return added;
        }

        @Override
        public int remove(@NotNull class_1799 stack, int toRemove) {
            if (this.isEmpty() || stack.method_7960()) {
                return 0;
            }
            int removed = 0;
            Fraction occupancy = QuiverHelper.getOccupancy(stack);
            boolean removedSelected = false;
            for (int i = 0; i < this.stacks.size() && toRemove > 0; ++i) {
                class_1799 nestedStack = this.stacks.get(i);
                if (!class_1799.method_31577((class_1799)stack, (class_1799)nestedStack)) continue;
                if (toRemove >= nestedStack.method_7947()) {
                    removed += nestedStack.method_7947();
                    toRemove -= nestedStack.method_7947();
                    this.totalOccupancy = this.totalOccupancy.subtract(occupancy.multiplyBy(Fraction.getFraction((double)nestedStack.method_7947())));
                    this.stacks.remove(i);
                    if (i < this.selectedIndex) {
                        --this.selectedIndex;
                    } else if (i == this.selectedIndex) {
                        removedSelected = true;
                    }
                    --i;
                    continue;
                }
                removed += toRemove;
                this.totalOccupancy = this.totalOccupancy.subtract(occupancy.multiplyBy(Fraction.getFraction((double)toRemove)));
                this.stacks.set(i, nestedStack.method_46651(nestedStack.method_7947() - toRemove));
                toRemove = 0;
            }
            if (removedSelected) {
                this.selectedIndex = this.nextSelectedIndex(stack, this.selectedIndex);
            }
            return removed;
        }

        @Override
        @NotNull
        public class_1799 popSelectedStack() {
            if (this.isEmpty()) {
                return class_1799.field_8037;
            }
            class_1799 selectedStack = this.stacks.remove(this.selectedIndex).method_7972();
            this.selectedIndex = this.nextSelectedIndex(selectedStack, this.selectedIndex);
            this.totalOccupancy = this.totalOccupancy.subtract(QuiverHelper.getOccupancyOfStack(selectedStack));
            return selectedStack;
        }

        @Override
        @NotNull
        public List<class_1799> popAllStacks() {
            List copies = Lists.transform(this.stacks, class_1799::method_7972);
            this.stacks.clear();
            this.selectedIndex = -1;
            this.totalOccupancy = Fraction.ZERO;
            return copies;
        }

        @Override
        @NotNull
        public class_1799 getQuiverStack() {
            return QuiverContents.this.quiverStack;
        }

        @Override
        @NotNull
        public List<class_1799> getStacks() {
            return this.stacks;
        }

        @Override
        public int getSelectedIndex() {
            return this.selectedIndex;
        }

        @Override
        public void setSelectedIndex(int selectedIndex) {
            this.selectedIndex = selectedIndex;
        }

        @Override
        @NotNull
        public Fraction getTotalOccupancy() {
            return this.totalOccupancy;
        }
    }
}

