/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.quiver;

import derekahedron.invexp.quiver.QuiverHelper;
import derekahedron.invexp.util.ContainerItemContentsReader;
import net.minecraft.class_1799;
import net.minecraft.class_3489;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.NotNull;

public interface QuiverContentsReader
extends ContainerItemContentsReader {
    @NotNull
    public class_1799 getQuiverStack();

    @NotNull
    public Fraction getTotalOccupancy();

    @Override
    default public boolean canTryInsert(@NotNull class_1799 stack) {
        return stack.method_31573(class_3489.field_18317) && stack.method_7909().method_31568();
    }

    @Override
    default public int getMaxAllowed(@NotNull class_1799 stack) {
        if (!this.canTryInsert(stack)) {
            return 0;
        }
        int maxAllowedByOccupancy = this.getMaxAllowedByOccupancy(stack);
        if (maxAllowedByOccupancy == 0) {
            return 0;
        }
        if (this.canAddStack()) {
            return maxAllowedByOccupancy;
        }
        int maxAllowed = 0;
        for (class_1799 nestedStack : this.getStacks()) {
            if (!class_1799.method_31577((class_1799)stack, (class_1799)nestedStack) || (maxAllowed += nestedStack.method_7914() - nestedStack.method_7947()) < maxAllowedByOccupancy) continue;
            return maxAllowedByOccupancy;
        }
        return maxAllowed;
    }

    default public int getMaxAllowedByOccupancy(@NotNull class_1799 stack) {
        Fraction openOccupancy = this.getMaxQuiverOccupancy().subtract(this.getTotalOccupancy());
        return Math.max(openOccupancy.divideBy(QuiverHelper.getOccupancy(stack)).intValue(), 0);
    }

    @Override
    default public boolean canAddStack() {
        return this.getStacks().size() < this.getMaxQuiverStacks();
    }

    default public int getMaxQuiverStacks() {
        return QuiverHelper.getMaxQuiverStacks(this.getQuiverStack());
    }

    default public Fraction getMaxQuiverOccupancy() {
        return QuiverHelper.getMaxQuiverOccupancy(this.getQuiverStack());
    }

    @Override
    default public boolean isFull() {
        return this.getTotalOccupancy().compareTo(this.getMaxQuiverOccupancy()) >= 0 || this.getStacks().size() >= this.getMaxQuiverStacks();
    }

    @Override
    @NotNull
    default public Fraction getFillFraction() {
        if (this.isFull()) {
            return Fraction.ONE;
        }
        return this.getTotalOccupancy().divideBy(this.getMaxQuiverOccupancy());
    }
}

