/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.sack;

import com.google.common.collect.Lists;
import derekahedron.invexp.component.InvExpDataComponentTypes;
import derekahedron.invexp.component.types.SackContentsComponent;
import derekahedron.invexp.entity.player.PlayerEntityDuck;
import derekahedron.invexp.registry.InvExpRegistryKeys;
import derekahedron.invexp.sack.ImmutableSackContents;
import derekahedron.invexp.sack.SackContentsReader;
import derekahedron.invexp.sack.SackType;
import derekahedron.invexp.sack.SackUsage;
import derekahedron.invexp.sack.SacksHelper;
import derekahedron.invexp.util.ContainerItemContents;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SackContents
extends ContainerItemContents
implements SackContentsReader {
    public final class_1799 sackStack;
    public SackContentsComponent component;
    public final class_2378<SackType> sackTypeRegistry;

    private SackContents(@NotNull class_1799 sackStack, @NotNull SackContentsComponent component, @NotNull class_2378<SackType> sackTypeRegistry) {
        this.sackStack = sackStack;
        this.component = component;
        this.sackTypeRegistry = sackTypeRegistry;
    }

    @Nullable
    public static SackContentsReader of(@Nullable class_1799 sackStack) {
        return ImmutableSackContents.of(sackStack);
    }

    @Nullable
    public static SackContents of(@Nullable class_1799 sackStack, @NotNull class_1937 world) {
        SackContentsComponent component = SackContentsComponent.getComponent(sackStack);
        return component == null ? null : new SackContents(sackStack, component, (class_2378<SackType>)world.method_30349().method_30530(InvExpRegistryKeys.SACK_TYPE));
    }

    @NotNull
    public static class_1799 selectedStackOf(@NotNull class_1799 sackStack) {
        SackContentsReader contents = SackContents.of(sackStack);
        if (contents != null && !contents.isEmpty()) {
            return contents.getSelectedStack();
        }
        return sackStack;
    }

    @NotNull
    public static class_1799 selectedStackOf(@Nullable class_1309 user, @NotNull class_1799 sackStack) {
        class_1657 player;
        SackUsage usage;
        if (user instanceof class_1657 && (usage = ((PlayerEntityDuck)(player = (class_1657)user)).invexp$getUsageForSackStack(sackStack)) != null) {
            SackContentsReader contents = SackContents.of(usage.sackStack);
            if (contents != null && !contents.isEmpty()) {
                class_1799 selectedStack = contents.getSelectedStack();
                if (class_1799.method_7973((class_1799)usage.selectedStack, (class_1799)selectedStack)) {
                    return usage.selectedStack;
                }
                return selectedStack;
            }
            return usage.sackStack;
        }
        return SackContents.selectedStackOf(sackStack);
    }

    public boolean isValid() {
        if (!this.component.isValid()) {
            return false;
        }
        return this.getSackTypes().size() <= this.getMaxSackTypes() && this.getTotalWeight().compareTo(this.getMaxSackWeight()) <= 0 && this.getStacks().size() <= this.getMaxSackStacks();
    }

    public void validate(@NotNull class_1657 player) {
        if (this.isValid()) {
            return;
        }
        ArrayList<class_1799> removedStacks = new ArrayList<class_1799>(this.getStacks().size());
        SackContents newContents = new SackContents(this.sackStack, SackContentsComponent.DEFAULT, this.sackTypeRegistry);
        Builder builder = newContents.getBuilder();
        for (int i = this.getStacks().size() - 1; i >= 0; --i) {
            class_1799 stack = this.getStacks().get(i).method_7972();
            builder.add(stack, 0);
            if (stack.method_7960()) continue;
            removedStacks.add(stack);
        }
        builder.selectedIndex = builder.nextSelectedIndex(this.getSelectedStack(), this.getSelectedIndex());
        builder.apply();
        this.component = newContents.component;
        for (class_1799 stack : removedStacks) {
            player.method_64399(stack);
        }
    }

    @Override
    @NotNull
    public List<class_1799> getStacks() {
        return this.component.getStacks();
    }

    @Override
    public int getSelectedIndex() {
        return this.component.selectedIndex;
    }

    @Override
    @NotNull
    public class_1799 getSackStack() {
        return this.sackStack;
    }

    @Override
    @NotNull
    public List<class_6880<SackType>> getSackTypes() {
        return this.component.getSackTypes();
    }

    @Override
    public Fraction getTotalWeight() {
        return this.component.getTotalWeight();
    }

    @Override
    @NotNull
    public Builder getBuilder() {
        return new Builder();
    }

    public static boolean attemptPickup(@NotNull class_1799 sackStack, @NotNull class_1799 stack, @NotNull class_1297 entity) {
        SackContents contents = SackContents.of(sackStack, entity.method_37908());
        if (contents == null) {
            return false;
        }
        class_5321<SackType> sackType = SacksHelper.getSackType(stack);
        if (sackType == null || !contents.isInTypes(sackType)) {
            return false;
        }
        contents.add(stack);
        return stack.method_7960();
    }

    public class Builder
    extends ContainerItemContents.Builder
    implements SackContentsReader {
        public final List<class_6880<SackType>> sackTypes;
        public final List<class_1799> stacks;
        public int selectedIndex;
        public Fraction totalWeight;

        public Builder() {
            this.sackTypes = new ArrayList<class_6880<SackType>>(SackContents.this.component.getSackTypes());
            this.stacks = new ArrayList<class_1799>(SackContents.this.component.getStacks());
            this.selectedIndex = SackContents.this.component.getSelectedIndex();
            this.totalWeight = SackContents.this.component.getTotalWeight();
        }

        @Override
        public void apply() {
            SackContents.this.component = new SackContentsComponent(this.sackTypes, List.copyOf(this.stacks), this.clampIndex(this.selectedIndex));
            SackContents.this.sackStack.method_57379(InvExpDataComponentTypes.SACK_CONTENTS, (Object)SackContents.this.component);
        }

        @Override
        public int add(@NotNull class_1799 stack, int insertAt) {
            if (!this.canTryInsert(stack)) {
                return 0;
            }
            Fraction weight = SacksHelper.getSackWeight(stack);
            int added = 0;
            int toAdd = Math.min(stack.method_7947(), this.getMaxAllowedByWeight(stack));
            if (toAdd > 0) {
                for (int i = 0; i < this.stacks.size(); ++i) {
                    class_1799 nestedStack = this.stacks.get(i);
                    if (!class_1799.method_31577((class_1799)stack, (class_1799)nestedStack)) continue;
                    int amount = Math.min(toAdd, nestedStack.method_7914() - nestedStack.method_7947());
                    if (amount > 0) {
                        this.stacks.set(i, nestedStack.method_46651(nestedStack.method_7947() + amount));
                        stack.method_7934(amount);
                        toAdd -= amount;
                        added += amount;
                        this.totalWeight = this.totalWeight.add(weight.multiplyBy(Fraction.getFraction((double)amount)));
                    }
                    if (toAdd > 0) continue;
                    return added;
                }
                if (this.canAddStack()) {
                    if (insertAt <= this.selectedIndex) {
                        ++this.selectedIndex;
                    }
                    this.totalWeight = this.totalWeight.add(weight.multiplyBy(Fraction.getFraction((double)toAdd)));
                    this.tryAddType(SacksHelper.getSackType(stack));
                    this.stacks.add(insertAt, stack.method_7971(toAdd));
                    return added += toAdd;
                }
            }
            return added;
        }

        @Override
        public int remove(@NotNull class_1799 stack, int toRemove) {
            if (this.stacks.isEmpty() || stack.method_7960() || toRemove <= 0) {
                return 0;
            }
            int removed = 0;
            Fraction weight = SacksHelper.getSackWeight(stack);
            boolean removedSelected = false;
            for (int i = 0; i < this.stacks.size() && toRemove > 0; ++i) {
                class_1799 nestedStack = this.stacks.get(i);
                if (!class_1799.method_31577((class_1799)stack, (class_1799)nestedStack)) continue;
                if (toRemove >= nestedStack.method_7947()) {
                    removed += nestedStack.method_7947();
                    toRemove -= nestedStack.method_7947();
                    this.totalWeight = this.totalWeight.subtract(weight.multiplyBy(Fraction.getFraction((double)nestedStack.method_7947())));
                    this.stacks.remove(i);
                    if (i < this.selectedIndex) {
                        --this.selectedIndex;
                    } else if (i == this.selectedIndex) {
                        removedSelected = true;
                    }
                    --i;
                    continue;
                }
                removed += toRemove;
                this.totalWeight = this.totalWeight.subtract(weight.multiplyBy(Fraction.getFraction((double)toRemove)));
                this.stacks.set(i, nestedStack.method_46651(nestedStack.method_7947() - toRemove));
                toRemove = 0;
            }
            if (removedSelected) {
                this.selectedIndex = this.nextSelectedIndex(stack, this.selectedIndex);
            }
            if (removed > 0) {
                this.tryRemoveType(SacksHelper.getSackType(stack));
            }
            return removed;
        }

        @Override
        @NotNull
        public class_1799 popSelectedStack() {
            if (this.isEmpty()) {
                return class_1799.field_8037;
            }
            class_1799 selectedStack = this.stacks.remove(this.selectedIndex).method_7972();
            this.selectedIndex = this.nextSelectedIndex(selectedStack, this.selectedIndex);
            this.totalWeight = this.totalWeight.subtract(SacksHelper.getSackWeightOfStack(selectedStack));
            this.tryRemoveType(SacksHelper.getSackType(selectedStack));
            return selectedStack;
        }

        @Override
        @NotNull
        public List<class_1799> popAllStacks() {
            List copies = Lists.transform(this.stacks, class_1799::method_7972);
            this.stacks.clear();
            this.selectedIndex = -1;
            this.sackTypes.clear();
            this.totalWeight = Fraction.ZERO;
            return copies;
        }

        @Override
        @NotNull
        public class_1799 getSackStack() {
            return SackContents.this.sackStack;
        }

        @Override
        @NotNull
        public List<class_6880<SackType>> getSackTypes() {
            return this.sackTypes;
        }

        @Override
        @NotNull
        public List<class_1799> getStacks() {
            return this.stacks;
        }

        @Override
        public int getSelectedIndex() {
            return this.selectedIndex;
        }

        @Override
        public void setSelectedIndex(int selectedIndex) {
            this.selectedIndex = selectedIndex;
        }

        @Override
        public Fraction getTotalWeight() {
            return this.totalWeight;
        }

        public void tryAddType(@Nullable class_5321<SackType> sackType) {
            if (sackType != null && !this.isInTypes(sackType)) {
                this.sackTypes.add((class_6880<SackType>)SackContents.this.sackTypeRegistry.method_46747(sackType));
            }
        }

        public void tryRemoveType(@Nullable class_5321<SackType> sackType) {
            block3: {
                block2: {
                    if (sackType == null || !this.isInTypes(sackType)) break block2;
                    if (!this.getStacks().stream().map(SacksHelper::getSackType).anyMatch(sackType::equals)) break block3;
                }
                return;
            }
            this.sackTypes.removeIf(type -> type.method_40230().map(sackType::equals).orElse(false));
        }
    }
}

