/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.sack;

import derekahedron.invexp.sack.SackType;
import derekahedron.invexp.sack.SacksHelper;
import derekahedron.invexp.util.ContainerItemContentsReader;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SackContentsReader
extends ContainerItemContentsReader {
    @NotNull
    public class_1799 getSackStack();

    @NotNull
    public List<class_6880<SackType>> getSackTypes();

    public Fraction getTotalWeight();

    @Override
    default public boolean canTryInsert(@NotNull class_1799 stack) {
        if (!stack.method_7909().method_31568()) {
            return false;
        }
        class_5321<SackType> sackType = SacksHelper.getSackType(stack);
        if (sackType == null) {
            return false;
        }
        return this.canAddType() || this.isInTypes(sackType);
    }

    @Override
    default public int getMaxAllowed(@NotNull class_1799 stack) {
        if (!this.canTryInsert(stack)) {
            return 0;
        }
        int maxAllowedByWeight = this.getMaxAllowedByWeight(stack);
        if (maxAllowedByWeight == 0) {
            return 0;
        }
        if (this.canAddStack()) {
            return maxAllowedByWeight;
        }
        int maxAllowed = 0;
        for (class_1799 nestedStack : this.getStacks()) {
            if (!class_1799.method_31577((class_1799)stack, (class_1799)nestedStack) || (maxAllowed += nestedStack.method_7914() - nestedStack.method_7947()) < maxAllowedByWeight) continue;
            return maxAllowedByWeight;
        }
        return maxAllowed;
    }

    default public int getMaxAllowedByWeight(@NotNull class_1799 stack) {
        if (stack.method_7960()) {
            return 0;
        }
        Fraction weight = SacksHelper.getSackWeight(stack);
        if (weight.compareTo(Fraction.ZERO) > 0) {
            Fraction openWeight = this.getMaxSackWeight().subtract(this.getTotalWeight());
            return Math.max(openWeight.divideBy(weight).intValue(), 0);
        }
        return stack.method_7947();
    }

    default public boolean isInTypes(@Nullable class_5321<SackType> sackType) {
        if (sackType == null) {
            return false;
        }
        return this.getSackTypes().stream().map(class_6880::method_40230).filter(Optional::isPresent).map(Optional::get).anyMatch(sackType::equals);
    }

    default public boolean canAddType() {
        return this.getSackTypes().size() < this.getMaxSackTypes();
    }

    @Override
    default public boolean canAddStack() {
        return this.getStacks().size() < this.getMaxSackStacks();
    }

    default public int getMaxSackStacks() {
        return SacksHelper.getMaxSackStacks(this.getSackStack());
    }

    default public int getMaxSackTypes() {
        return SacksHelper.getMaxSackTypes(this.getSackStack());
    }

    default public Fraction getMaxSackWeight() {
        return SacksHelper.getMaxSackWeight(this.getSackStack());
    }

    @Override
    default public boolean isFull() {
        return this.getTotalWeight().compareTo(this.getMaxSackWeight()) >= 0 || this.getStacks().size() >= this.getMaxSackStacks();
    }

    @Override
    @NotNull
    default public Fraction getFillFraction() {
        if (this.isFull()) {
            return Fraction.ONE;
        }
        return this.getTotalWeight().divideBy(this.getMaxSackWeight());
    }
}

