/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.sack;

import derekahedron.invexp.InventoryExpansion;
import derekahedron.invexp.item.ItemDuck;
import derekahedron.invexp.registry.InvExpRegistryKeys;
import derekahedron.invexp.sack.SackType;
import derekahedron.invexp.sack.SackTypeDefault;
import derekahedron.invexp.sack.SackTypes;
import derekahedron.invexp.sack.SackWeightDefault;
import derekahedron.invexp.sack.SacksHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.SequencedCollection;
import net.minecraft.class_10706;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_3612;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SackDefaultManager {
    private static SackDefaultManager INSTANCE;
    private int syncId;
    private final List<class_6880.class_6883<SackTypeDefault>> typeDefaults;
    private final List<class_6880.class_6883<SackTypeDefault>> globalTypeDefaults;
    private final List<class_6880.class_6883<SackWeightDefault>> weightDefaults;
    private final List<class_6880.class_6883<SackWeightDefault>> globalWeightDefaults;

    public SackDefaultManager(@NotNull class_5455 registryManager) {
        this.syncId = INSTANCE != null ? SackDefaultManager.INSTANCE.syncId : 0;
        SequencedCollection types = registryManager.method_30530(InvExpRegistryKeys.SACK_TYPE_DEFINITION).method_42017().sorted(SackDefaultManager::compareTypes).toList().reversed();
        SequencedCollection weights = registryManager.method_30530(InvExpRegistryKeys.SACK_WEIGHT_DEFINITION).method_42017().sorted(SackDefaultManager::compareWeights).toList().reversed();
        this.typeDefaults = types.stream().filter(type -> ((SackTypeDefault)type.comp_349()).items().isPresent()).toList();
        this.globalTypeDefaults = types.stream().filter(type -> ((SackTypeDefault)type.comp_349()).items().isEmpty()).toList();
        this.weightDefaults = weights.stream().filter(weight -> ((SackWeightDefault)weight.comp_349()).items().isPresent()).toList();
        this.globalWeightDefaults = weights.stream().filter(weight -> ((SackWeightDefault)weight.comp_349()).items().isEmpty()).toList();
        this.updateSackDefaults();
    }

    public void updateSackDefaults() {
        ++this.syncId;
        for (class_6880.class_6883<SackTypeDefault> class_68832 : this.typeDefaults) {
            ((SackTypeDefault)class_68832.comp_349()).items().ifPresent(items -> items.method_8105().forEach(item -> this.getOrCreateSackDefaults((class_1792)((class_1792)item.comp_349())).typeDefaults.add(typeDefault)));
        }
        for (class_6880.class_6883 class_68833 : this.weightDefaults) {
            ((SackWeightDefault)class_68833.comp_349()).items().ifPresent(items -> items.method_8105().forEach(item -> this.getOrCreateSackDefaults((class_1792)((class_1792)item.comp_349())).weightDefaults.add((class_6880.class_6883<SackWeightDefault>)weightDefault)));
        }
    }

    public class_5321<SackType> getType(@NotNull class_1799 stack) {
        SackDefaults defaults = this.getSackDefaults(stack.method_7909());
        List<Object> itemTypeDefaults = defaults != null ? defaults.typeDefaults : List.of();
        int i = 0;
        int j = 0;
        while (i < this.globalTypeDefaults.size() || j < itemTypeDefaults.size()) {
            SackTypeDefault typeDefault;
            if (i < this.globalTypeDefaults.size() && (j >= itemTypeDefaults.size() || SackDefaultManager.compareTypes(this.globalTypeDefaults.get(i), (class_6880.class_6883<SackTypeDefault>)((class_6880.class_6883)itemTypeDefaults.get(j))) > 0)) {
                typeDefault = (SackTypeDefault)this.globalTypeDefaults.get(i).comp_349();
                ++i;
            } else {
                typeDefault = (SackTypeDefault)((class_6880.class_6883)itemTypeDefaults.get(j)).comp_349();
                ++j;
            }
            if (!typeDefault.test(stack)) continue;
            return typeDefault.sackType().isPresent() ? (class_5321)typeDefault.sackType().get().method_40230().orElse(null) : null;
        }
        if (stack.method_7909() instanceof class_1826) {
            return SackTypes.SPAWN_EGG;
        }
        if (stack.method_7909() instanceof class_1755) {
            return SackTypes.BUCKET;
        }
        return null;
    }

    public Fraction getWeight(@NotNull class_1799 stack) {
        class_10706 beesComponent;
        SackDefaults defaults = this.getSackDefaults(stack.method_7909());
        List<Object> itemWeightDefaults = defaults != null ? defaults.weightDefaults : List.of();
        int i = 0;
        int j = 0;
        while (i < this.globalWeightDefaults.size() || j < itemWeightDefaults.size()) {
            SackWeightDefault weightDefault;
            if (i < this.globalWeightDefaults.size() && (j >= itemWeightDefaults.size() || SackDefaultManager.compareWeights(this.globalWeightDefaults.get(i), (class_6880.class_6883<SackWeightDefault>)((class_6880.class_6883)itemWeightDefaults.get(j))) > 0)) {
                weightDefault = (SackWeightDefault)this.globalWeightDefaults.get(i).comp_349();
                ++i;
            } else {
                weightDefault = (SackWeightDefault)((class_6880.class_6883)itemWeightDefaults.get(j)).comp_349();
                ++j;
            }
            if (!weightDefault.test(stack)) continue;
            return weightDefault.sackWeight().orElse(SacksHelper.DEFAULT_SACK_WEIGHT_2);
        }
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1755) {
            class_1755 bucketItem = (class_1755)class_17922;
            if (!bucketItem.field_7905.method_15780(class_3612.field_15906)) {
                return Fraction.ONE_QUARTER;
            }
        }
        if (stack.method_65797(class_9334.field_49624) && !(beesComponent = (class_10706)stack.method_58695(class_9334.field_49624, (Object)class_10706.field_56300)).comp_3585().isEmpty()) {
            return SacksHelper.DEFAULT_SACK_WEIGHT_2.multiplyBy(Fraction.getFraction((double)64.0));
        }
        return SacksHelper.DEFAULT_SACK_WEIGHT_2;
    }

    public SackDefaults getSackDefaults(class_1792 item) {
        SackDefaults defaults = ((ItemDuck)item).invexp$getSackDefaults();
        return defaults != null && defaults.syncId == this.syncId ? defaults : null;
    }

    public SackDefaults getOrCreateSackDefaults(class_1792 item) {
        SackDefaults defaults = this.getSackDefaults(item);
        if (defaults == null) {
            defaults = new SackDefaults(new ArrayList<class_6880.class_6883<SackTypeDefault>>(), new ArrayList<class_6880.class_6883<SackWeightDefault>>(), this.syncId);
            ((ItemDuck)item).invexp$setSackDefaults(defaults);
        }
        return defaults;
    }

    public static SackDefaultManager getInstance() {
        return INSTANCE;
    }

    public static void updateInstanceSackDefaults() {
        if (INSTANCE != null) {
            INSTANCE.updateSackDefaults();
        } else {
            InventoryExpansion.LOGGER.warn("Sack Defaults were updated before insertable manager instance created!");
        }
    }

    private static void setInstance(@Nullable SackDefaultManager instance) {
        INSTANCE = instance;
    }

    public static void createNewInstance(@NotNull class_5455 registryManager) {
        SackDefaultManager.setInstance(new SackDefaultManager(registryManager));
    }

    private static int compareTypes(@NotNull class_6880.class_6883<SackTypeDefault> left, @NotNull class_6880.class_6883<SackTypeDefault> right) {
        int compareResult = ((SackTypeDefault)left.comp_349()).compareTo((SackTypeDefault)right.comp_349());
        return compareResult != 0 ? compareResult : left.method_40237().method_29177().method_12833(right.method_40237().method_29177());
    }

    private static int compareWeights(@NotNull class_6880.class_6883<SackWeightDefault> left, @NotNull class_6880.class_6883<SackWeightDefault> right) {
        int compareResult = ((SackWeightDefault)left.comp_349()).compareTo((SackWeightDefault)right.comp_349());
        return compareResult != 0 ? compareResult : left.method_40237().method_29177().method_12833(right.method_40237().method_29177());
    }

    public record SackDefaults(List<class_6880.class_6883<SackTypeDefault>> typeDefaults, List<class_6880.class_6883<SackWeightDefault>> weightDefaults, int syncId) {
    }
}

