/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.sack;

import derekahedron.invexp.InventoryExpansion;
import derekahedron.invexp.sack.SackContents;
import derekahedron.invexp.sack.SackContentsReader;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SackUsage {
    public final class_1799 sackStack;
    public class_1799 selectedStack;
    public class_1799 originalSelectedStack;

    public SackUsage(@NotNull SackContentsReader contents) {
        this(contents, null);
    }

    public SackUsage(@NotNull SackContentsReader contents, @Nullable class_1799 previousSelectedStack) {
        this.sackStack = contents.getSackStack();
        this.selectedStack = contents.copySelectedStack(previousSelectedStack);
        this.originalSelectedStack = this.selectedStack.method_7972();
    }

    public void update(@NotNull class_1297 entity, @NotNull Consumer<class_1799> leftoverStackConsumer) {
        class_1799 leftoverStack = class_1799.field_8037;
        SackContents contents = SackContents.of(this.sackStack, entity.method_37908());
        if (contents == null) {
            InventoryExpansion.LOGGER.warn("Contents of {} is invalid when updating usage!", (Object)this.sackStack);
            return;
        }
        if (this.originalSelectedStack.method_7960()) {
            SackContents.Builder builder;
            if (!this.selectedStack.method_7960() && (builder = contents.getBuilder()).add(leftoverStack = this.selectedStack.method_7972(), 0) > 0) {
                builder.apply();
            }
        } else if (this.selectedStack.method_7960()) {
            SackContents.Builder builder = contents.getBuilder();
            if (builder.remove(this.originalSelectedStack) != this.originalSelectedStack.method_7947()) {
                InventoryExpansion.LOGGER.warn("ItemStack {} not fully removed.", (Object)this.originalSelectedStack);
            }
            builder.apply();
        } else if (class_1799.method_31577((class_1799)this.originalSelectedStack, (class_1799)this.selectedStack)) {
            int countDiff = this.selectedStack.method_7947() - this.originalSelectedStack.method_7947();
            if (countDiff > 0) {
                SackContents.Builder builder = contents.getBuilder();
                if (builder.add(leftoverStack = this.selectedStack.method_46651(countDiff), 0) > 0) {
                    builder.apply();
                }
            } else if (countDiff < 0) {
                SackContents.Builder builder = contents.getBuilder();
                if (builder.remove(this.originalSelectedStack, -countDiff) != -countDiff) {
                    InventoryExpansion.LOGGER.warn("Count difference ({}) for {} not fully removed", (Object)(-countDiff), (Object)this.originalSelectedStack);
                }
                builder.apply();
            }
        } else {
            SackContents.Builder builder = contents.getBuilder();
            if (builder.replaceSelectedStack(leftoverStack = this.selectedStack.method_7972(), this.originalSelectedStack.method_7947())) {
                builder.apply();
            }
        }
        this.selectedStack = contents.copySelectedStack(this.selectedStack);
        this.originalSelectedStack = this.selectedStack.method_7972();
        if (!leftoverStack.method_7960()) {
            leftoverStackConsumer.accept(leftoverStack);
        }
    }
}

