/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.sack;

import derekahedron.invexp.component.InvExpDataComponentTypes;
import derekahedron.invexp.component.types.SackInsertableComponent;
import derekahedron.invexp.sack.SackDefaultManager;
import derekahedron.invexp.sack.SackType;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SacksHelper {
    public static final int DEFAULT_SACK_WEIGHT = 100;
    public static final Fraction DEFAULT_SACK_WEIGHT_2 = Fraction.ONE;
    public static final int DEFAULT_MAX_SACK_TYPES = 0;
    public static final Fraction DEFAULT_MAX_SACK_WEIGHT = Fraction.ZERO;
    public static final int DEFAULT_MAX_SACK_STACKS = 0;

    public static int getMaxSackTypes(@NotNull class_1799 stack) {
        return (Integer)stack.method_58695(InvExpDataComponentTypes.MAX_SACK_TYPES, (Object)0);
    }

    public static Fraction getMaxSackWeight(@NotNull class_1799 stack) {
        return (Fraction)stack.method_58695(InvExpDataComponentTypes.MAX_SACK_WEIGHT, (Object)DEFAULT_MAX_SACK_WEIGHT);
    }

    public static int getMaxSackStacks(@NotNull class_1799 stack) {
        return (Integer)stack.method_58695(InvExpDataComponentTypes.MAX_SACK_STACKS, (Object)0);
    }

    @Nullable
    public static class_5321<SackType> getSackType(@NotNull class_1799 stack) {
        SackInsertableComponent component = (SackInsertableComponent)stack.method_58694(InvExpDataComponentTypes.SACK_INSERTABLE);
        if (component != null) {
            return component.sackType().flatMap(class_6880::method_40230).orElse(null);
        }
        class_6880 sackType = (class_6880)stack.method_58694(InvExpDataComponentTypes.SACK_TYPE);
        if (sackType != null) {
            return sackType.method_40230().orElse(null);
        }
        if (SackDefaultManager.getInstance() != null) {
            return SackDefaultManager.getInstance().getType(stack);
        }
        throw new RuntimeException("Sack Loading Error");
    }

    public static Fraction getSackWeight(@NotNull class_1799 stack) {
        SackInsertableComponent component = (SackInsertableComponent)stack.method_58694(InvExpDataComponentTypes.SACK_INSERTABLE);
        if (component != null) {
            return component.sackWeight().orElse(DEFAULT_SACK_WEIGHT_2).divideBy(Fraction.getFraction((double)stack.method_7914()));
        }
        Fraction sackWeight = (Fraction)stack.method_58694(InvExpDataComponentTypes.SACK_WEIGHT);
        if (sackWeight != null) {
            return sackWeight.divideBy(Fraction.getFraction((double)stack.method_7914()));
        }
        if (SackDefaultManager.getInstance() != null) {
            return SackDefaultManager.getInstance().getWeight(stack).divideBy(Fraction.getFraction((double)stack.method_7914()));
        }
        throw new RuntimeException("Sack Loading Error");
    }

    public static Fraction getSackWeightOfStack(@NotNull class_1799 stack) {
        return SacksHelper.getSackWeight(stack).multiplyBy(Fraction.getFraction((double)stack.method_7947()));
    }

    @Nullable
    public static class_2960 getSackTypeIdentifier(@NotNull class_1799 stack) {
        return SacksHelper.getSackTypeIdentifier(SacksHelper.getSackType(stack));
    }

    @Nullable
    public static class_2960 getSackTypeIdentifier(@Nullable class_5321<SackType> sackType) {
        if (sackType == null) {
            return null;
        }
        return sackType.method_29177();
    }
}

