/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.util;

import derekahedron.invexp.InventoryExpansion;
import derekahedron.invexp.quiver.QuiverContents;
import derekahedron.invexp.sack.SackContents;
import derekahedron.invexp.util.ContainerItemContentsReader;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContainerItemContents
implements ContainerItemContentsReader {
    @Nullable
    public static ContainerItemContentsReader of(@Nullable class_1799 stack) {
        ContainerItemContentsReader contents = SackContents.of(stack);
        if (contents != null) {
            return contents;
        }
        contents = QuiverContents.of(stack);
        if (contents != null) {
            return contents;
        }
        return null;
    }

    @Nullable
    public static ContainerItemContents of(@Nullable class_1799 stack, @NotNull class_1937 world) {
        ContainerItemContents contents = SackContents.of(stack, world);
        if (contents != null) {
            return contents;
        }
        contents = QuiverContents.of(stack);
        if (contents != null) {
            return contents;
        }
        return null;
    }

    public int add(@NotNull class_1799 stack) {
        if (this.getMaxAllowed(stack) > 0) {
            Builder builder = this.getBuilder();
            int added = builder.add(stack, 0);
            if (added > 0) {
                builder.apply();
            }
            return added;
        }
        return 0;
    }

    public int add(@NotNull class_1735 slot, @NotNull class_1657 player) {
        return this.add(Stream.of(slot), player);
    }

    public int add(@NotNull Stream<class_1735> slots, @NotNull class_1657 player) {
        Builder builder = null;
        ContainerItemContentsReader checker = this;
        int added = 0;
        for (class_1735 slot : slots.toList()) {
            class_1799 stack = slot.method_7677();
            int maxAllowed = checker.getMaxAllowed(stack);
            if (maxAllowed <= 0 || (stack = slot.method_32753(stack.method_7947(), maxAllowed, player)).method_7960()) continue;
            if (builder == null) {
                builder = this.getBuilder();
                checker = builder;
            }
            added += builder.add(stack);
        }
        if (added > 0) {
            builder.apply();
        }
        return added;
    }

    public int remove(@NotNull class_1799 stack) {
        if (this.isEmpty() || stack.method_7960()) {
            return 0;
        }
        Builder builder = this.getBuilder();
        int removed = builder.remove(stack);
        if (removed == stack.method_7947()) {
            builder.apply();
            return removed;
        }
        return 0;
    }

    @NotNull
    public class_1799 popSelectedItem() {
        if (this.isEmpty()) {
            return class_1799.field_8037;
        }
        class_1799 selectedStack = this.getSelectedStack();
        if (selectedStack.method_7947() == 1) {
            return this.popSelectedStack();
        }
        Builder builder = this.getBuilder();
        if (builder.remove(selectedStack = selectedStack.method_46651(1)) > 0) {
            builder.apply();
            return selectedStack;
        }
        InventoryExpansion.LOGGER.warn("ItemStack {} not removed", (Object)selectedStack);
        return class_1799.field_8037;
    }

    @NotNull
    public class_1799 popSelectedStack() {
        if (this.isEmpty()) {
            return class_1799.field_8037;
        }
        Builder builder = this.getBuilder();
        class_1799 stack = builder.popSelectedStack();
        if (!stack.method_7960()) {
            builder.apply();
        }
        return stack;
    }

    public boolean popSelectedStack(@NotNull class_1735 slot) {
        if (this.isEmpty()) {
            return false;
        }
        class_1799 selectedStack = this.getSelectedStack();
        int toRemove = selectedStack.method_7947() - slot.method_32756(selectedStack.method_7972()).method_7947();
        if (toRemove == 0) {
            return false;
        }
        if (toRemove == selectedStack.method_7947()) {
            this.popSelectedStack();
            return true;
        }
        Builder builder = this.getBuilder();
        if (builder.remove(selectedStack, toRemove) > 0) {
            builder.apply();
            return true;
        }
        InventoryExpansion.LOGGER.warn("ItemStack {} not removed. Potential duplicate in slot {}", (Object)selectedStack, (Object)slot);
        return false;
    }

    @NotNull
    public List<class_1799> popAllStacks() {
        if (this.isEmpty()) {
            return List.of();
        }
        Builder builder = this.getBuilder();
        List<class_1799> stacks = builder.popAllStacks();
        builder.apply();
        return stacks;
    }

    public void setSelectedIndex(int selectedIndex) {
        if ((selectedIndex = this.clampIndex(selectedIndex)) != this.getSelectedIndex()) {
            Builder builder = this.getBuilder();
            builder.setSelectedIndex(selectedIndex);
            builder.apply();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateSelectedStack(@NotNull class_1799 selectedStack, @NotNull Consumer<class_1799> leftoverStackConsumer) {
        class_1799 leftoverStack = class_1799.field_8037;
        if (this.isEmpty()) {
            if (selectedStack.method_7960()) {
                return;
            }
            Builder builder = this.getBuilder();
            if (builder.add(leftoverStack = selectedStack.method_7972(), 0) > 0) {
                builder.apply();
            }
        } else {
            class_1799 oldStack = this.getSelectedStack();
            if (selectedStack.method_7960()) {
                Builder builder = this.getBuilder();
                if (builder.remove(oldStack) != oldStack.method_7947()) {
                    InventoryExpansion.LOGGER.warn("ItemStack {} not fully removed.", (Object)oldStack);
                }
                builder.apply();
            } else if (class_1799.method_31577((class_1799)oldStack, (class_1799)selectedStack)) {
                int countDiff = selectedStack.method_7947() - oldStack.method_7947();
                if (countDiff > 0) {
                    Builder builder = this.getBuilder();
                    if (builder.add(leftoverStack = selectedStack.method_46651(countDiff), 0) > 0) {
                        builder.apply();
                    }
                } else {
                    if (countDiff >= 0) return;
                    Builder builder = this.getBuilder();
                    if (builder.remove(oldStack, -countDiff) != -countDiff) {
                        InventoryExpansion.LOGGER.warn("Count difference ({}) for {} not fully removed", (Object)(-countDiff), (Object)oldStack);
                    }
                    builder.apply();
                }
            } else {
                Builder builder = this.getBuilder();
                if (builder.replaceSelectedStack(leftoverStack = selectedStack.method_7972())) {
                    builder.apply();
                }
            }
        }
        if (!leftoverStack.method_7960()) {
            leftoverStackConsumer.accept(leftoverStack);
        }
        this.copySelectedStack(selectedStack);
    }

    @NotNull
    public abstract Builder getBuilder();

    public static abstract class Builder
    implements ContainerItemContentsReader {
        public abstract void apply();

        public abstract int add(@NotNull class_1799 var1, int var2);

        public abstract int remove(@NotNull class_1799 var1, int var2);

        @NotNull
        public abstract class_1799 popSelectedStack();

        @NotNull
        public abstract List<class_1799> popAllStacks();

        public abstract void setSelectedIndex(int var1);

        public int add(@NotNull class_1799 stack) {
            return this.add(stack, 0);
        }

        public int remove(@NotNull class_1799 stack) {
            return this.remove(stack, stack.method_7947());
        }

        public boolean replaceSelectedStack(@NotNull class_1799 stack) {
            return this.replaceSelectedStack(stack, this.getSelectedStack().method_7947());
        }

        public boolean replaceSelectedStack(@NotNull class_1799 stack, int count) {
            class_1799 backupPick;
            class_1799 firstPick;
            int insertAt;
            if (this.isEmpty()) {
                return false;
            }
            class_1799 selectedStack = this.getSelectedStack();
            if (count > selectedStack.method_7947()) {
                InventoryExpansion.LOGGER.warn("Cannot remove {} from selected stack {}", (Object)count, (Object)selectedStack);
                return false;
            }
            if (count < selectedStack.method_7947()) {
                if (this.remove(selectedStack, count) != count) {
                    InventoryExpansion.LOGGER.warn("Selected Stack {} not fully replaced!", (Object)selectedStack);
                }
                insertAt = this.getSelectedIndex() + 1;
            } else {
                insertAt = this.getSelectedIndex();
                this.popSelectedStack();
            }
            if (class_1799.method_7984((class_1799)stack, (class_1799)selectedStack)) {
                firstPick = stack.method_7972();
                backupPick = selectedStack;
            } else {
                firstPick = selectedStack;
                backupPick = stack.method_7972();
            }
            this.add(stack, insertAt);
            this.setSelectedIndex(this.nextSelectedIndex(firstPick, backupPick, insertAt));
            return true;
        }

        public int nextSelectedIndex(@NotNull class_1799 stack, int startingIndex) {
            return this.nextSelectedIndex(stack, null, startingIndex);
        }

        public int nextSelectedIndex(@NotNull class_1799 stack, @Nullable class_1799 backupStack, int startingIndex) {
            if (this.isEmpty()) {
                return -1;
            }
            int newIndex = this.indexOf(stack, startingIndex);
            if (newIndex != -1) {
                return newIndex;
            }
            if (backupStack != null && (newIndex = this.indexOf(backupStack, startingIndex)) != -1) {
                return newIndex;
            }
            return this.clampIndex(startingIndex);
        }
    }
}

