/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.util;

import derekahedron.invexp.quiver.QuiverContents;
import derekahedron.invexp.sack.ImmutableSackContents;
import derekahedron.invexp.sack.SackContents;
import derekahedron.invexp.sack.SackContentsReader;
import derekahedron.invexp.util.ContainerItemContents;
import derekahedron.invexp.util.ContainerItemContentsReader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_465;
import net.minecraft.class_5537;
import net.minecraft.class_9276;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class ContainerItemSlotDragger {
    @Nullable
    public static ContainerItemSlotDragger of(class_1799 stack) {
        ContainerItemContentsReader contents = ContainerItemContents.of(stack);
        if (contents instanceof ImmutableSackContents) {
            ImmutableSackContents sackContents = (ImmutableSackContents)contents;
            return new SackSlotDragger(sackContents.sackStack);
        }
        if (contents instanceof QuiverContents) {
            QuiverContents quiverContents = (QuiverContents)contents;
            return new QuiverSlotDragger(quiverContents.quiverStack);
        }
        if (stack.method_7909() instanceof class_5537 && stack.method_57826(class_9334.field_49650)) {
            return new BundleSlotDragger(stack);
        }
        return null;
    }

    public void onHover(@NotNull class_1735 slot, @NotNull class_465<?> screen) {
        class_1799 stack = slot.method_7677();
        if (screen.method_17577().method_7615(slot)) {
            if (screen.field_2790 == 1) {
                if (stack.method_7960() && !this.isEmpty()) {
                    screen.method_2383(slot, slot.method_34266(), screen.field_2790, class_1713.field_7790);
                }
            } else if (screen.field_2790 == 0 && !stack.method_7960() && this.canTryInsert(stack)) {
                screen.method_2383(slot, slot.method_34266(), screen.field_2790, class_1713.field_7790);
            }
        }
    }

    public abstract boolean canTryInsert(class_1799 var1);

    public abstract boolean isEmpty();

    @Environment(value=EnvType.CLIENT)
    public static class SackSlotDragger
    extends ContainerItemSlotDragger {
        public final class_1799 sackStack;

        public SackSlotDragger(class_1799 sackStack) {
            this.sackStack = sackStack;
        }

        @Override
        public boolean isEmpty() {
            SackContentsReader contents = SackContents.of(this.sackStack);
            return contents == null || contents.isEmpty();
        }

        @Override
        public boolean canTryInsert(class_1799 stack) {
            SackContentsReader contents = SackContents.of(this.sackStack);
            return contents != null && contents.canTryInsert(stack);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class QuiverSlotDragger
    extends ContainerItemSlotDragger {
        public final class_1799 quiverStack;

        public QuiverSlotDragger(class_1799 quiverStack) {
            this.quiverStack = quiverStack;
        }

        @Override
        public boolean isEmpty() {
            QuiverContents contents = QuiverContents.of(this.quiverStack);
            return contents == null || contents.isEmpty();
        }

        @Override
        public boolean canTryInsert(class_1799 stack) {
            QuiverContents contents = QuiverContents.of(this.quiverStack);
            return contents != null && contents.canTryInsert(stack);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class BundleSlotDragger
    extends ContainerItemSlotDragger {
        public final class_1799 bundleStack;

        public BundleSlotDragger(class_1799 bundleStack) {
            this.bundleStack = bundleStack;
        }

        @Override
        public boolean isEmpty() {
            class_9276 contents = (class_9276)this.bundleStack.method_58694(class_9334.field_49650);
            return contents == null || contents.method_57429();
        }

        @Override
        public boolean canTryInsert(class_1799 stack) {
            return true;
        }
    }
}

