/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.apache.commons.lang3.math.Fraction;

public class InvExpCodecs {
    public static final Codec<Fraction> FRACTION = new Codec<Fraction>(){
        public static final Codec<Fraction> NUMERATOR_DENOMINATOR_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("numerator").forGetter(Fraction::getNumerator), (App)Codec.INT.fieldOf("denominator").forGetter(Fraction::getDenominator)).apply((Applicative)instance, Fraction::getFraction));

        public <T> DataResult<Pair<Fraction, T>> decode(DynamicOps<T> ops, T input) {
            DataResult result;
            try {
                result = Codec.DOUBLE.map(Fraction::getFraction).decode(ops, input);
                if (result.isSuccess()) {
                    return result;
                }
            }
            catch (Exception e) {
                return DataResult.error(e::getMessage);
            }
            try {
                result = Codec.INT.map(Fraction::getFraction).decode(ops, input);
                if (result.isSuccess()) {
                    return result;
                }
            }
            catch (Exception e) {
                return DataResult.error(e::getMessage);
            }
            try {
                result = Codec.STRING.map(Fraction::getFraction).decode(ops, input);
                if (result.isSuccess()) {
                    return result;
                }
            }
            catch (Exception e) {
                return DataResult.error(e::getMessage);
            }
            try {
                result = NUMERATOR_DENOMINATOR_CODEC.decode(ops, input);
                if (result.isSuccess()) {
                    return result;
                }
            }
            catch (Exception e) {
                return DataResult.error(e::getMessage);
            }
            return DataResult.error(() -> "Not a fraction: " + String.valueOf(input));
        }

        public <T> DataResult<T> encode(Fraction fraction, DynamicOps<T> ops, T prefix) {
            if (fraction.getDenominator() == 1) {
                return Codec.INT.comap(Fraction::getNumerator).encode((Object)fraction, ops, prefix);
            }
            return NUMERATOR_DENOMINATOR_CODEC.encode((Object)fraction, ops, prefix);
        }
    };
    public static final Codec<Fraction> NON_NEGATIVE_FRACTION = FRACTION.validate(fraction -> fraction.getNumerator() >= 0 ? DataResult.success((Object)fraction) : DataResult.error(() -> "Fraction must be non-negative: " + String.valueOf(fraction)));
    public static final class_9139<class_9129, Fraction> FRACTION_PACKET = class_9139.method_56435((class_9139)class_9135.field_49675, Fraction::getNumerator, (class_9139)class_9135.field_49675, Fraction::getDenominator, Fraction::getFraction);
}

