/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.bundle;

import com.google.common.collect.Lists;
import derekahedron.invexp.bundle.BundleContentsComponent;
import derekahedron.invexp.bundle.BundleContentsReader;
import derekahedron.invexp.bundle.BundleHelper;
import derekahedron.invexp.util.ContainerItemContents;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class BundleContents
extends ContainerItemContents
implements BundleContentsReader {
    public final ItemStack bundleStack;
    private BundleContentsComponent component;

    private BundleContents(ItemStack stack, BundleContentsComponent component) {
        this.bundleStack = stack;
        this.component = component;
    }

    @Nullable
    public static BundleContents of(@Nullable ItemStack stack) {
        BundleContentsComponent component = BundleContentsComponent.getComponent(stack);
        if (component == null) {
            return null;
        }
        return new BundleContents(stack, component);
    }

    public boolean isValid() {
        if (!this.component.isValid()) {
            return false;
        }
        return this.getTotalWeight() <= this.getMaxBundleWeight() && this.getStacks().size() <= this.getMaxBundleStacks();
    }

    public void validate(Player player) {
        if (this.isValid()) {
            return;
        }
        ArrayList<ItemStack> removedStacks = new ArrayList<ItemStack>(this.getStacks().size());
        BundleContents newContents = new BundleContents(this.bundleStack, new BundleContentsComponent());
        Builder builder = newContents.getBuilder();
        for (int i = this.getStacks().size() - 1; i >= 0; --i) {
            ItemStack stack = this.getStacks().get(i).m_41777_();
            builder.add(stack, 0);
            if (stack.m_41619_()) continue;
            removedStacks.add(stack);
        }
        builder.selectedIndex = builder.nextSelectedIndex(this.getSelectedStack(), this.getSelectedIndex());
        builder.apply();
        this.component = newContents.component;
        for (ItemStack stack : removedStacks) {
            if (player.m_150109_().m_36054_(stack)) continue;
            player.m_36176_(stack, false);
        }
    }

    @Override
    public List<ItemStack> getStacks() {
        return this.component.stacks;
    }

    @Override
    public int getSelectedIndex() {
        return this.component.selectedIndex;
    }

    @Override
    public void setSelectedIndex(int selectedIndex) {
        if (selectedIndex != -1) {
            selectedIndex = this.clampIndex(selectedIndex);
        }
        if (selectedIndex != this.getSelectedIndex()) {
            Builder builder = this.getBuilder();
            ((ContainerItemContents.Builder)builder).setSelectedIndex(selectedIndex);
            ((ContainerItemContents.Builder)builder).apply();
        }
    }

    @Override
    public ItemStack getBundleStack() {
        return this.bundleStack;
    }

    @Override
    public int getTotalWeight() {
        return this.component.getTotalWeight();
    }

    @Override
    public Builder getBuilder() {
        return new Builder();
    }

    public class Builder
    extends ContainerItemContents.Builder
    implements BundleContentsReader {
        public final List<ItemStack> stacks;
        public int selectedIndex;
        public int totalWeight;

        public Builder() {
            this.stacks = new ArrayList<ItemStack>(BundleContents.this.component.getStacks());
            this.selectedIndex = BundleContents.this.component.selectedIndex;
            this.totalWeight = BundleContents.this.component.getTotalWeight();
        }

        @Override
        public void apply() {
            BundleContents.this.component = new BundleContentsComponent(List.copyOf(this.stacks), Mth.m_14045_((int)this.selectedIndex, (int)-1, (int)(this.stacks.size() - 1)));
            BundleContents.this.component.setComponent(BundleContents.this.bundleStack);
        }

        @Override
        public int add(ItemStack stack, int insertAt) {
            if (!this.canTryInsert(stack)) {
                return 0;
            }
            int weight = BundleHelper.getBundleWeight(stack);
            int added = 0;
            int toAdd = Math.min(stack.m_41613_(), this.getMaxAllowedByWeight(stack));
            if (toAdd > 0) {
                for (int i = 0; i < this.stacks.size(); ++i) {
                    ItemStack nestedStack = this.stacks.get(i);
                    if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)nestedStack)) continue;
                    int amount = Math.min(toAdd, nestedStack.m_41741_() - nestedStack.m_41613_());
                    if (amount > 0) {
                        this.stacks.set(i, nestedStack.m_255036_(nestedStack.m_41613_() + amount));
                        stack.m_41774_(amount);
                        toAdd -= amount;
                        added += amount;
                        this.totalWeight += weight * amount;
                    }
                    if (toAdd > 0) continue;
                    return added;
                }
                if (this.canAddStack()) {
                    if (this.selectedIndex != -1) {
                        ++this.selectedIndex;
                    }
                    added += toAdd;
                    ItemStack newStack = stack.m_41620_(toAdd);
                    this.totalWeight += BundleHelper.getBundleWeightOfStack(newStack);
                    this.stacks.add(0, newStack);
                }
            }
            return added;
        }

        @Override
        public int remove(ItemStack stack, int toRemove) {
            if (this.isEmpty() || stack.m_41619_()) {
                return 0;
            }
            int removed = 0;
            int weight = BundleHelper.getBundleWeight(stack);
            boolean removedSelected = false;
            for (int i = 0; i < this.stacks.size() && toRemove > 0; ++i) {
                ItemStack nestedStack = this.stacks.get(i);
                if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)nestedStack)) continue;
                if (toRemove >= nestedStack.m_41613_()) {
                    removed += nestedStack.m_41613_();
                    toRemove -= nestedStack.m_41613_();
                    this.totalWeight -= weight * nestedStack.m_41613_();
                    this.stacks.remove(i);
                    if (i < this.selectedIndex) {
                        --this.selectedIndex;
                    } else if (i == this.selectedIndex) {
                        removedSelected = true;
                    }
                    --i;
                    continue;
                }
                removed += toRemove;
                this.totalWeight -= weight * toRemove;
                this.stacks.set(i, nestedStack.m_255036_(nestedStack.m_41613_() - toRemove));
                toRemove = 0;
            }
            if (removedSelected) {
                this.selectedIndex = this.nextSelectedIndex(stack, this.selectedIndex);
            }
            return removed;
        }

        @Override
        public ItemStack popSelectedStack() {
            if (this.isEmpty()) {
                return ItemStack.f_41583_;
            }
            ItemStack selectedStack = this.stacks.remove(this.clampIndex(this.selectedIndex)).m_41777_();
            if (this.selectedIndex != -1) {
                this.selectedIndex = this.nextSelectedIndex(selectedStack, this.selectedIndex);
            }
            this.totalWeight -= BundleHelper.getBundleWeightOfStack(selectedStack);
            return selectedStack;
        }

        @Override
        public List<ItemStack> popAllStacks() {
            List copies = Lists.transform(this.stacks, ItemStack::m_41777_);
            this.stacks.clear();
            this.selectedIndex = -1;
            this.totalWeight = 0;
            return copies;
        }

        @Override
        public ItemStack getBundleStack() {
            return BundleContents.this.bundleStack;
        }

        @Override
        public List<ItemStack> getStacks() {
            return this.stacks;
        }

        @Override
        public int getSelectedIndex() {
            return this.selectedIndex;
        }

        @Override
        public void setSelectedIndex(int selectedIndex) {
            this.selectedIndex = selectedIndex;
        }

        @Override
        public int getTotalWeight() {
            return this.totalWeight;
        }
    }
}

