/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.bundle;

import derekahedron.invexp.bundle.BundleHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.ItemStack;

public class BundleContentsComponent {
    public static final String ITEMS_KEY = "Items";
    public static final String SELECTED_INDEX_KEY = "InvExpSelectedIndex";
    public final List<ItemStack> stacks;
    public final int selectedIndex;
    public final int totalWeight;

    public BundleContentsComponent(List<ItemStack> stacks, int selectedIndex) {
        this.stacks = stacks;
        this.selectedIndex = selectedIndex;
        this.totalWeight = BundleContentsComponent.calculateTotalWeight(stacks);
    }

    public BundleContentsComponent() {
        this(List.of(), -1);
    }

    public List<ItemStack> getStacks() {
        return this.stacks;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public int getTotalWeight() {
        return this.totalWeight;
    }

    public boolean isValid() {
        for (ItemStack nestedStack : this.stacks) {
            if (nestedStack.m_41720_().m_142095_()) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    public ItemStack getSelectedStack() {
        if (this.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return this.stacks.get(this.selectedIndex);
    }

    public void setComponent(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        ListTag contentsTag = new ListTag();
        if (!this.isEmpty()) {
            for (ItemStack nestedStack : this.getStacks()) {
                CompoundTag itemTag = new CompoundTag();
                nestedStack.m_41739_(itemTag);
                contentsTag.add((Object)itemTag);
            }
            tag.m_128365_(ITEMS_KEY, (Tag)contentsTag);
        } else {
            tag.m_128473_(ITEMS_KEY);
        }
        if (this.getSelectedIndex() != -1) {
            tag.m_128405_(SELECTED_INDEX_KEY, this.getSelectedIndex());
        } else {
            tag.m_128473_(SELECTED_INDEX_KEY);
        }
    }

    @Nullable
    public static BundleContentsComponent getComponent(@Nullable ItemStack stack) {
        if (stack != null && !stack.m_41619_() && stack.m_41720_() instanceof BundleItem) {
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128441_(ITEMS_KEY)) {
                ListTag contentsTag = tag.m_128437_(ITEMS_KEY, 10);
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(contentsTag.size());
                for (int i = 0; i < contentsTag.size(); ++i) {
                    stacks.add(ItemStack.m_41712_((CompoundTag)contentsTag.m_128728_(i)));
                }
                int selectedIndex = -1;
                if (tag.m_128441_(SELECTED_INDEX_KEY)) {
                    selectedIndex = tag.m_128451_(SELECTED_INDEX_KEY);
                }
                return new BundleContentsComponent(stacks, selectedIndex);
            }
            return new BundleContentsComponent();
        }
        return null;
    }

    public static int calculateTotalWeight(List<ItemStack> stacks) {
        int totalWeight = 0;
        for (ItemStack stack : stacks) {
            totalWeight += BundleHelper.getBundleWeightOfStack(stack);
        }
        return totalWeight;
    }
}

