/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.bundle;

import derekahedron.invexp.bundle.BundleHelper;
import derekahedron.invexp.item.BetterBundleItem;
import derekahedron.invexp.util.ContainerItemContentsReader;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.apache.commons.lang3.math.Fraction;

public interface BundleContentsReader
extends ContainerItemContentsReader {
    public ItemStack getBundleStack();

    public int getTotalWeight();

    @Override
    default public boolean isFull() {
        return this.getTotalWeight() >= this.getMaxBundleWeight() || this.getStacks().size() >= this.getMaxBundleStacks();
    }

    @Override
    default public Fraction getFillFraction() {
        if (this.isFull()) {
            return Fraction.ONE;
        }
        return Fraction.getFraction((int)this.getTotalWeight(), (int)this.getMaxBundleWeight());
    }

    @Override
    default public boolean canTryInsert(ItemStack stack) {
        return stack.m_41720_().m_142095_();
    }

    @Override
    default public int getMaxAllowed(ItemStack stack) {
        if (!this.canTryInsert(stack)) {
            return 0;
        }
        int maxAllowedByWeight = this.getMaxAllowedByWeight(stack);
        if (maxAllowedByWeight == 0) {
            return 0;
        }
        if (this.canAddStack()) {
            return maxAllowedByWeight;
        }
        int maxAllowed = 0;
        for (ItemStack nestedStack : this.getStacks()) {
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)nestedStack) || (maxAllowed += nestedStack.m_41741_() - nestedStack.m_41613_()) < maxAllowedByWeight) continue;
            return maxAllowedByWeight;
        }
        return maxAllowed;
    }

    default public int getMaxAllowedByWeight(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        int itemWeight = BundleHelper.getBundleWeight(stack);
        if (itemWeight > 0) {
            return Math.min(stack.m_41613_(), Math.max(this.getMaxBundleWeight() - this.getTotalWeight(), 0) / itemWeight);
        }
        return stack.m_41613_();
    }

    @Override
    default public boolean canAddStack() {
        return this.getStacks().size() < this.getMaxBundleStacks();
    }

    default public int getMaxBundleStacks() {
        ItemStack stack = this.getBundleStack();
        if (stack.m_150930_(Items.f_151058_)) {
            return 64;
        }
        Item item = stack.m_41720_();
        if (item instanceof BetterBundleItem) {
            BetterBundleItem betterBundleItem = (BetterBundleItem)item;
            return betterBundleItem.getMaxBundleStacks();
        }
        return 0;
    }

    default public int getMaxBundleWeight() {
        return BundleHelper.getMaxBundleWeightStacks(this.getBundleStack()) * 64;
    }
}

