/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.client.event;

import derekahedron.invexp.client.ClientConfig;
import derekahedron.invexp.client.gui.tooltip.ClientSackTooltip;
import derekahedron.invexp.sack.SackDefaultManager;
import derekahedron.invexp.sack.SackType;
import derekahedron.invexp.sack.SacksHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.math.Fraction;

@Mod.EventBusSubscriber(modid="invexp", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class SackDataTooltipEvent {
    public static final Component SACK_DATA_TOOLTIP = Component.m_237115_((String)"item.invexp.sack.data_tooltip").m_130940_(ChatFormatting.DARK_GRAY);

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        if (ClientConfig.displaySackDataInTooltip && event.getFlags().m_7050_() && SackDefaultManager.getInstance() != null) {
            ItemStack stack = event.getItemStack();
            ResourceKey<SackType> sackType = SackDefaultManager.getInstance().getType(stack);
            if (sackType != null) {
                event.getToolTip().add(SACK_DATA_TOOLTIP);
                event.getToolTip().add(Component.m_237113_((String)sackType.m_135782_().toString()).m_130940_(ChatFormatting.DARK_GRAY));
                Fraction sackWeight = SacksHelper.getSackWeight(stack);
                if (sackWeight.multiplyBy(Fraction.getFraction((double)64.0)).compareTo(SacksHelper.DEFAULT_SACK_WEIGHT) != 0) {
                    event.getToolTip().add(ClientSackTooltip.formatWeight(sackWeight).m_130940_(ChatFormatting.DARK_GRAY));
                }
            }
        }
    }
}

