/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.client.gui.tooltip;

import derekahedron.invexp.bundle.BundleContents;
import derekahedron.invexp.bundle.BundleHelper;
import derekahedron.invexp.client.gui.tooltip.ContainerItemTooltipComponent;
import derekahedron.invexp.item.tooltip.BetterBundleTooltip;
import derekahedron.invexp.util.InvExpUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;

public class BetterClientBundleTooltip
implements ClientTooltipComponent,
ContainerItemTooltipComponent {
    public static final ResourceLocation BUNDLE_PROGRESS_BAR_BORDER_TEXTURE = InvExpUtil.location("textures/gui/container/bundle/bundle_progressbar_border.png");
    public static final ResourceLocation BUNDLE_PROGRESS_BAR_FILL_TEXTURE = InvExpUtil.location("textures/gui/container/bundle/bundle_progressbar_fill.png");
    public static final ResourceLocation BUNDLE_PROGRESS_BAR_FULL_TEXTURE = InvExpUtil.location("textures/gui/container/bundle/bundle_progressbar_full.png");
    public static final ResourceLocation BUNDLE_SLOT_HIGHLIGHT_BACK_TEXTURE = InvExpUtil.location("textures/gui/container/bundle/slot_highlight_back.png");
    public static final ResourceLocation BUNDLE_SLOT_HIGHLIGHT_FRONT_TEXTURE = InvExpUtil.location("textures/gui/container/bundle/slot_highlight_front.png");
    public static final ResourceLocation BUNDLE_SLOT_BACKGROUND_TEXTURE = InvExpUtil.location("textures/gui/container/bundle/slot_background.png");
    public static final Component BUNDLE_FULL = Component.m_237115_((String)"item.invexp.bundle.full");
    public static final Component BUNDLE_EMPTY = Component.m_237115_((String)"item.invexp.bundle.empty");
    public static final Component BUNDLE_TOO_MANY_STACKS = Component.m_237115_((String)"item.invexp.bundle.too_many_stacks");
    public static final Component BUNDLE_EMPTY_DESCRIPTION = Component.m_237115_((String)"item.invexp.bundle.description.empty");
    public static final String BUNDLE_EMPTY_DESCRIPTION_PLURAL = "item.invexp.bundle.description.empty.plural";
    private final BundleContents contents;
    @Nullable
    private Font lastFont;

    public BetterClientBundleTooltip(BetterBundleTooltip tooltip) {
        this.contents = tooltip.contents();
    }

    public void m_183452_(Font textRenderer, int x, int y, GuiGraphics drawContext) {
        int width = this.getTooltipWidth();
        int top = y;
        if (this.contents.isEmpty()) {
            if (this.lastFont != null) {
                Component bundleEmptyDescription = this.getBundleEmptyDescription();
                drawContext.m_280554_(textRenderer, (FormattedText)bundleEmptyDescription, x + this.getXMargin(width), y, this.getTooltipWidth(), 0xAAAAAA);
                y += this.getHeight(bundleEmptyDescription, textRenderer);
            }
        } else {
            this.drawContents(textRenderer, x, y, width, top, drawContext);
            y += this.getContentsHeight();
        }
        this.drawProgressBar(textRenderer, x, y += this.getProgressBarPadding(), width, drawContext);
    }

    public int m_142069_(@Nullable Font textRenderer) {
        this.lastFont = textRenderer;
        return this.getTooltipWidth();
    }

    public int m_142103_() {
        int height = 0;
        if (this.contents.isEmpty()) {
            if (this.lastFont != null) {
                height += this.getHeight(this.getBundleEmptyDescription(), this.lastFont);
            }
        } else {
            height += this.getContentsHeight();
        }
        height += this.getProgressBarPadding();
        height += this.getProgressBarHeight();
        return height += this.getProgressBarPadding();
    }

    public Component getBundleEmptyDescription() {
        int maxStacks = BundleHelper.getMaxBundleWeightStacks(this.contents.bundleStack);
        if (maxStacks != 1) {
            return Component.m_237110_((String)BUNDLE_EMPTY_DESCRIPTION_PLURAL, (Object[])new Object[]{maxStacks});
        }
        return BUNDLE_EMPTY_DESCRIPTION;
    }

    @Override
    public List<ItemStack> getStacks() {
        return this.contents.getStacks();
    }

    @Override
    public int getSelectedIndex() {
        return this.contents.getSelectedIndex();
    }

    @Override
    public Fraction getFillFraction() {
        return this.contents.getFillFraction();
    }

    @Override
    public ResourceLocation getProgressBarFillTexture() {
        if (this.contents.isFull()) {
            return BUNDLE_PROGRESS_BAR_FULL_TEXTURE;
        }
        return BUNDLE_PROGRESS_BAR_FILL_TEXTURE;
    }

    @Override
    public ResourceLocation getProgressBarBorderTexture() {
        return BUNDLE_PROGRESS_BAR_BORDER_TEXTURE;
    }

    @Override
    public ResourceLocation getSlotBackgroundTexture() {
        return BUNDLE_SLOT_BACKGROUND_TEXTURE;
    }

    @Override
    public ResourceLocation getSlotHighlightBackTexture() {
        return BUNDLE_SLOT_HIGHLIGHT_BACK_TEXTURE;
    }

    @Override
    public ResourceLocation getSlotHighlightFrontTexture() {
        return BUNDLE_SLOT_HIGHLIGHT_FRONT_TEXTURE;
    }

    @Override
    @Nullable
    public Component getProgressBarLabel() {
        if (this.contents.getTotalWeight() >= this.contents.getMaxBundleWeight()) {
            return BUNDLE_FULL;
        }
        if (this.getStacks().size() >= this.contents.getMaxBundleStacks()) {
            return BUNDLE_TOO_MANY_STACKS;
        }
        if (this.contents.isEmpty()) {
            return BUNDLE_EMPTY;
        }
        return null;
    }
}

