/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.client.gui.tooltip;

import derekahedron.invexp.client.gui.tooltip.ContainerItemTooltipComponent;
import derekahedron.invexp.quiver.QuiverContents;
import derekahedron.invexp.quiver.QuiverHelper;
import derekahedron.invexp.util.InvExpUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;

public class ClientQuiverTooltip
implements ClientTooltipComponent,
ContainerItemTooltipComponent {
    public static final ResourceLocation QUIVER_PROGRESS_BAR_BORDER_TEXTURE = InvExpUtil.location("textures/gui/container/quiver/quiver_progressbar_border.png");
    public static final ResourceLocation QUIVER_PROGRESS_BAR_FILL_TEXTURE = InvExpUtil.location("textures/gui/container/quiver/quiver_progressbar_fill.png");
    public static final ResourceLocation QUIVER_PROGRESS_BAR_FULL_TEXTURE = InvExpUtil.location("textures/gui/container/quiver/quiver_progressbar_full.png");
    public static final ResourceLocation QUIVER_SLOT_HIGHLIGHT_BACK_TEXTURE = InvExpUtil.location("textures/gui/container/quiver/slot_highlight_back.png");
    public static final ResourceLocation QUIVER_SLOT_HIGHLIGHT_FRONT_TEXTURE = InvExpUtil.location("textures/gui/container/quiver/slot_highlight_front.png");
    public static final ResourceLocation QUIVER_SLOT_BACKGROUND_TEXTURE = InvExpUtil.location("textures/gui/container/quiver/slot_background.png");
    public static final Component QUIVER_FULL = Component.m_237115_((String)"item.invexp.quiver.full");
    public static final Component QUIVER_EMPTY = Component.m_237115_((String)"item.invexp.quiver.empty");
    public static final Component QUIVER_TOO_MANY_STACKS = Component.m_237115_((String)"item.invexp.quiver.too_many_stacks");
    public static final Component QUIVER_EMPTY_DESCRIPTION = Component.m_237115_((String)"item.invexp.quiver.description.empty");
    public static final String QUIVER_EMPTY_DESCRIPTION_PLURAL = "item.invexp.quiver.description.empty.plural";
    public final QuiverContents contents;
    @Nullable
    private Font lastFont;

    public ClientQuiverTooltip(QuiverContents contents) {
        this.contents = contents;
    }

    public void m_183452_(Font textRenderer, int x, int y, GuiGraphics drawContext) {
        int width = this.getTooltipWidth();
        int top = y;
        if (this.contents.isEmpty()) {
            if (this.lastFont != null) {
                Component quiverEmptyDescription = this.getQuiverEmptyDescription();
                drawContext.m_280554_(textRenderer, (FormattedText)quiverEmptyDescription, x + this.getXMargin(width), y, this.getTooltipWidth(), 0xAAAAAA);
                y += this.getHeight(quiverEmptyDescription, textRenderer);
            }
        } else {
            this.drawContents(textRenderer, x, y, width, top, drawContext);
            y += this.getContentsHeight();
        }
        this.drawProgressBar(textRenderer, x, y += this.getProgressBarPadding(), width, drawContext);
    }

    public int m_142069_(@Nullable Font textRenderer) {
        this.lastFont = textRenderer;
        return this.getTooltipWidth();
    }

    public int m_142103_() {
        int height = 0;
        if (this.contents.isEmpty()) {
            if (this.lastFont != null) {
                height += this.getHeight(this.getQuiverEmptyDescription(), this.lastFont);
            }
        } else {
            height += this.getContentsHeight();
        }
        height += this.getProgressBarPadding();
        height += this.getProgressBarHeight();
        return height += this.getProgressBarPadding();
    }

    public Component getQuiverEmptyDescription() {
        int maxStacks = QuiverHelper.getMaxQuiverOccupancyStacks(this.contents.quiverStack);
        if (maxStacks != 1) {
            return Component.m_237110_((String)QUIVER_EMPTY_DESCRIPTION_PLURAL, (Object[])new Object[]{maxStacks});
        }
        return QUIVER_EMPTY_DESCRIPTION;
    }

    @Override
    public List<ItemStack> getStacks() {
        return this.contents.getStacks();
    }

    @Override
    public int getSelectedIndex() {
        return this.contents.getSelectedIndex();
    }

    @Override
    public Fraction getFillFraction() {
        return this.contents.getFillFraction();
    }

    @Override
    public ResourceLocation getProgressBarFillTexture() {
        if (this.contents.isFull()) {
            return QUIVER_PROGRESS_BAR_FULL_TEXTURE;
        }
        return QUIVER_PROGRESS_BAR_FILL_TEXTURE;
    }

    @Override
    public ResourceLocation getProgressBarBorderTexture() {
        return QUIVER_PROGRESS_BAR_BORDER_TEXTURE;
    }

    @Override
    public ResourceLocation getSlotBackgroundTexture() {
        return QUIVER_SLOT_BACKGROUND_TEXTURE;
    }

    @Override
    public ResourceLocation getSlotHighlightBackTexture() {
        return QUIVER_SLOT_HIGHLIGHT_BACK_TEXTURE;
    }

    @Override
    public ResourceLocation getSlotHighlightFrontTexture() {
        return QUIVER_SLOT_HIGHLIGHT_FRONT_TEXTURE;
    }

    @Override
    @Nullable
    public Component getProgressBarLabel() {
        if (this.contents.getTotalOccupancy().compareTo(this.contents.getMaxQuiverOccupancy()) >= 0) {
            return QUIVER_FULL;
        }
        if (this.getStacks().size() >= this.contents.getMaxQuiverStacks()) {
            return QUIVER_TOO_MANY_STACKS;
        }
        if (this.contents.isEmpty()) {
            return QUIVER_EMPTY;
        }
        return null;
    }
}

