/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.client.gui.tooltip;

import derekahedron.invexp.client.gui.tooltip.ContainerItemTooltipComponent;
import derekahedron.invexp.sack.SackContentsReader;
import derekahedron.invexp.util.InvExpUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;

public class ClientSackTooltip
implements ClientTooltipComponent,
ContainerItemTooltipComponent {
    public static final ResourceLocation SACK_PROGRESS_BAR_BORDER_TEXTURE = InvExpUtil.location("textures/gui/container/sack/sack_progressbar_border.png");
    public static final ResourceLocation SACK_PROGRESS_BAR_FILL_TEXTURE = InvExpUtil.location("textures/gui/container/sack/sack_progressbar_fill.png");
    public static final ResourceLocation SACK_PROGRESS_BAR_FULL_TEXTURE = InvExpUtil.location("textures/gui/container/sack/sack_progressbar_full.png");
    public static final ResourceLocation SACK_SLOT_HIGHLIGHT_BACK_TEXTURE = InvExpUtil.location("textures/gui/container/sack/slot_highlight_back.png");
    public static final ResourceLocation SACK_SLOT_HIGHLIGHT_FRONT_TEXTURE = InvExpUtil.location("textures/gui/container/sack/slot_highlight_front.png");
    public static final ResourceLocation SACK_SLOT_BACKGROUND_TEXTURE = InvExpUtil.location("textures/gui/container/sack/slot_background.png");
    public static final Component SACK_FULL = Component.m_237115_((String)"item.invexp.sack.full");
    public static final Component SACK_EMPTY = Component.m_237115_((String)"item.invexp.sack.empty");
    public static final Component SACK_TOO_MANY_STACKS = Component.m_237115_((String)"item.invexp.sack.too_many_stacks");
    public static final String SACK_PARTIAL = "item.invexp.sack.partial";
    public static final String SACK_EMPTY_DESCRIPTION = "item.invexp.sack.description.empty";
    public static final String SACK_TYPE_DESCRIPTION = "item.invexp.sack.description.type";
    public static final String SACK_TYPE_DESCRIPTION_CONJUNCTION = "item.invexp.sack.description.type.conjunction";
    public static final String SACK_TYPE_DESCRIPTION_MANY_CONJUNCTION = "item.invexp.sack.description.type.many.conjunction";
    public static final String SACK_TYPE_DESCRIPTION_MANY_LAST_CONJUNCTION = "item.invexp.sack.description.type.many.last_conjunction";
    public final SackContentsReader contents;
    @Nullable
    private Font lastFont;

    public ClientSackTooltip(SackContentsReader contents) {
        this.contents = contents;
    }

    public void m_183452_(Font textRenderer, int x, int y, GuiGraphics drawContext) {
        int width = this.getTooltipWidth();
        int top = y;
        if (this.contents.isEmpty()) {
            if (this.lastFont != null) {
                Component sackEmptyDescription = this.getSackEmptyDescription();
                drawContext.m_280554_(textRenderer, (FormattedText)sackEmptyDescription, x + this.getXMargin(width), y, this.getTooltipWidth(), 0xAAAAAA);
                y += this.getHeight(sackEmptyDescription, textRenderer);
            }
        } else {
            Component sackTypeDescription;
            if (this.lastFont != null && (sackTypeDescription = this.getSackTypeDescription()) != null) {
                drawContext.m_280554_(textRenderer, (FormattedText)sackTypeDescription, x + this.getXMargin(width), y, this.getTooltipWidth(), 0xAAAAAA);
                y += this.getHeight(sackTypeDescription, textRenderer);
            }
            this.drawContents(textRenderer, x, y, width, top, drawContext);
            y += this.getContentsHeight();
        }
        this.drawProgressBar(textRenderer, x, y += this.getProgressBarPadding(), width, drawContext);
    }

    public int m_142069_(@Nullable Font textRenderer) {
        this.lastFont = textRenderer;
        return this.getTooltipWidth();
    }

    public int m_142103_() {
        int height = 0;
        if (this.lastFont != null) {
            if (this.contents.isEmpty()) {
                height += this.getHeight(this.getSackEmptyDescription(), this.lastFont);
            } else {
                height += this.getHeight(this.getSackTypeDescription(), this.lastFont);
                height += this.getContentsHeight();
            }
        }
        height += this.getProgressBarPadding();
        height += this.getProgressBarHeight();
        return height += this.getProgressBarPadding();
    }

    public Component getSackEmptyDescription() {
        return Component.m_237110_((String)SACK_EMPTY_DESCRIPTION, (Object[])new Object[]{ClientSackTooltip.formatWeight(this.contents.getMaxSackWeight())});
    }

    @Nullable
    public Component getSackTypeDescription() {
        Object description = null;
        ArrayList<MutableComponent> names = new ArrayList<MutableComponent>(this.contents.getSackTypes().size());
        for (String sackType : this.contents.getSackTypes()) {
            ResourceLocation location = ResourceLocation.parse((String)sackType);
            MutableComponent name = Component.m_237115_((String)("sack_type." + location.m_135827_() + "." + location.m_135815_()));
            names.add(name);
        }
        for (int i = 0; i < names.size(); ++i) {
            Component name = (Component)names.get(i);
            description = description == null ? name : (i != names.size() - 1 ? Component.m_237110_((String)SACK_TYPE_DESCRIPTION_MANY_CONJUNCTION, (Object[])new Object[]{description, name}) : (names.size() == 2 ? Component.m_237110_((String)SACK_TYPE_DESCRIPTION_CONJUNCTION, (Object[])new Object[]{description, name}) : Component.m_237110_((String)SACK_TYPE_DESCRIPTION_MANY_LAST_CONJUNCTION, (Object[])new Object[]{description, name})));
        }
        if (description != null) {
            description = Component.m_237110_((String)SACK_TYPE_DESCRIPTION, (Object[])new Object[]{description});
        }
        return description;
    }

    @Override
    public List<ItemStack> getStacks() {
        return this.contents.getStacks();
    }

    @Override
    public int getSelectedIndex() {
        return this.contents.getSelectedIndex();
    }

    @Override
    public Fraction getFillFraction() {
        return this.contents.getFillFraction();
    }

    @Override
    public ResourceLocation getProgressBarFillTexture() {
        if (this.contents.isFull()) {
            return SACK_PROGRESS_BAR_FULL_TEXTURE;
        }
        return SACK_PROGRESS_BAR_FILL_TEXTURE;
    }

    @Override
    public ResourceLocation getProgressBarBorderTexture() {
        return SACK_PROGRESS_BAR_BORDER_TEXTURE;
    }

    @Override
    public ResourceLocation getSlotBackgroundTexture() {
        return SACK_SLOT_BACKGROUND_TEXTURE;
    }

    @Override
    public ResourceLocation getSlotHighlightBackTexture() {
        return SACK_SLOT_HIGHLIGHT_BACK_TEXTURE;
    }

    @Override
    public ResourceLocation getSlotHighlightFrontTexture() {
        return SACK_SLOT_HIGHLIGHT_FRONT_TEXTURE;
    }

    @Override
    public Component getProgressBarLabel() {
        if (this.contents.getTotalWeight().compareTo(this.contents.getMaxSackWeight()) >= 0) {
            return SACK_FULL;
        }
        if (this.getStacks().size() >= this.contents.getMaxSackStacks()) {
            return SACK_TOO_MANY_STACKS;
        }
        if (this.contents.isEmpty()) {
            return SACK_EMPTY;
        }
        return Component.m_237110_((String)SACK_PARTIAL, (Object[])new Object[]{ClientSackTooltip.formatWeight(this.contents.getTotalWeight()), ClientSackTooltip.formatWeight(this.contents.getMaxSackWeight())});
    }

    public static MutableComponent formatWeight(Fraction weight) {
        if ((weight = weight.multiplyBy(Fraction.getFraction((double)64.0))).getNumerator() % weight.getDenominator() == 0) {
            return Component.m_237113_((String)String.valueOf(weight.intValue()));
        }
        return Component.m_237113_((String)String.format("%.2f", Float.valueOf(weight.floatValue())));
    }
}

