/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.client.gui.tooltip;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.Nullable;

public interface ContainerItemTooltipComponent {
    public static final int DEFAULT_MAX_ROWS = 3;
    public static final int MIN_MAX_ROWS = 3;
    public static final int DEFAULT_SLOT_LENGTH = 24;
    public static final int DEFAULT_ROW_WIDTH = 4;
    public static final int DEFAULT_PROGRESS_BAR_PADDING = 4;
    public static final int DEFAULT_PROGRESS_BAR_HEIGHT = 13;
    public static final int EXTRA_ITEMS_TEXT_COLOR = 0xFFFFFF;
    public static final int PROGRESS_BAR_TEXT_COLOR = 0xFFFFFF;
    public static final int DESCRIPTION_TEXT_COLOR = 0xAAAAAA;

    default public int getTooltipWidth() {
        return this.getRowWidth() * this.getSlotLength();
    }

    default public int getMaxRows() {
        return 3;
    }

    default public int getRowWidth() {
        return 4;
    }

    default public int getSlotLength() {
        return 24;
    }

    default public int getProgressBarHeight() {
        return 13;
    }

    default public int getProgressBarPadding() {
        return 4;
    }

    public List<ItemStack> getStacks();

    public int getSelectedIndex();

    public Fraction getFillFraction();

    public ResourceLocation getProgressBarFillTexture();

    public ResourceLocation getProgressBarBorderTexture();

    public ResourceLocation getSlotBackgroundTexture();

    public ResourceLocation getSlotHighlightBackTexture();

    public ResourceLocation getSlotHighlightFrontTexture();

    @Nullable
    public Component getProgressBarLabel();

    default public void drawContents(Font textRenderer, int x, int y, int width, int top, GuiGraphics drawContext) {
        ItemStack selectedStack;
        int numRows = this.getNumRows();
        int maxRows = Math.max(this.getMaxRows(), 3);
        int prevVisibleRows = maxRows / 2;
        int nextVisibleRows = (maxRows - 1) / 2;
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex != -1) {
            selectedStack = this.getStacks().get(selectedIndex);
        } else {
            selectedStack = null;
            selectedIndex = 0;
        }
        int selectedRow = this.getRowForIndex(selectedIndex);
        if (selectedRow < prevVisibleRows) {
            selectedRow = prevVisibleRows;
        } else if (numRows - selectedRow - 1 < nextVisibleRows) {
            selectedRow = numRows - nextVisibleRows - 1;
        }
        ArrayList<ItemStack> displayedStacks = new ArrayList<ItemStack>(maxRows * this.getRowWidth());
        int seedStart = 0;
        int countPrev = 0;
        int countNext = 0;
        for (int i = 0; i < this.getStacks().size(); ++i) {
            int row = this.getRowForIndex(i);
            ItemStack stack = this.getStacks().get(i);
            if (row < selectedRow - prevVisibleRows) {
                ++seedStart;
                countPrev += stack.m_41613_();
                continue;
            }
            if (row > selectedRow + nextVisibleRows) {
                countNext += stack.m_41613_();
                continue;
            }
            displayedStacks.add(stack);
        }
        int endX = x + this.getXMargin(width) + this.getTooltipWidth();
        int endY = y + Math.min(numRows, maxRows) * this.getSlotLength();
        int itemPadding = (this.getSlotLength() - 16) / 2;
        for (int i = 0; i < displayedStacks.size(); ++i) {
            ItemStack stack = (ItemStack)displayedStacks.get(displayedStacks.size() - 1 - i);
            int slotX = endX - (1 + i % this.getRowWidth()) * this.getSlotLength();
            int slotY = endY - (1 + i / this.getRowWidth()) * this.getSlotLength();
            if (i == displayedStacks.size() - 1 && countPrev > 0) {
                drawContext.m_280137_(textRenderer, "+" + (countPrev += stack.m_41613_()), slotX + this.getSlotLength() / 2, slotY + itemPadding + 6, 0xFFFFFF);
                continue;
            }
            if (i == 0 && countNext > 0) {
                drawContext.m_280137_(textRenderer, "+" + (countNext += stack.m_41613_()), slotX + this.getSlotLength() / 2, slotY + itemPadding + 6, 0xFFFFFF);
                continue;
            }
            if (stack == selectedStack) {
                this.blit(drawContext, this.getSlotHighlightBackTexture(), slotX, slotY, this.getSlotLength(), this.getSlotLength(), this.getSlotLength(), this.getSlotLength());
            } else {
                this.blit(drawContext, this.getSlotBackgroundTexture(), slotX, slotY, this.getSlotLength(), this.getSlotLength(), this.getSlotLength(), this.getSlotLength());
            }
            drawContext.m_280256_(stack, slotX + itemPadding, slotY + itemPadding, seedStart + displayedStacks.size() - 1 - i);
            drawContext.m_280370_(textRenderer, stack, slotX + itemPadding, slotY + itemPadding);
            if (stack != selectedStack) continue;
            this.blit(drawContext, this.getSlotHighlightFrontTexture(), slotX, slotY, this.getSlotLength(), this.getSlotLength(), this.getSlotLength(), this.getSlotLength());
        }
        if (selectedStack != null) {
            Component name = selectedStack.m_41786_();
            int nameX = x + (width - textRenderer.m_92724_(name.m_7532_())) / 2 - 12;
            int nameY = top - 15;
            drawContext.m_280557_(textRenderer, name, nameX, nameY);
        }
    }

    default public int getRowForIndex(int index) {
        int emptySpaces = this.getRowWidth() - (1 + (this.getStacks().size() - 1) % this.getRowWidth());
        return (index + emptySpaces) / this.getRowWidth();
    }

    default public int getNumRows() {
        return 1 + (this.getStacks().size() - 1) / this.getRowWidth();
    }

    default public int getProgressBarFill() {
        int progressBarWidth = this.getTooltipWidth() - 2;
        Fraction fillFraction = this.getFillFraction();
        return 1 + Mth.m_14045_((int)(fillFraction.getNumerator() * progressBarWidth / fillFraction.getDenominator()), (int)0, (int)progressBarWidth);
    }

    default public void drawProgressBar(Font textRenderer, int x, int y, int width, GuiGraphics drawContext) {
        this.blit(drawContext, this.getProgressBarFillTexture(), x += this.getXMargin(width), y, this.getProgressBarFill(), this.getProgressBarHeight(), width, this.getProgressBarHeight());
        this.blit(drawContext, this.getProgressBarBorderTexture(), x, y, this.getTooltipWidth(), this.getProgressBarHeight(), width, this.getProgressBarHeight());
        Component progressBarLabel = this.getProgressBarLabel();
        if (progressBarLabel != null) {
            String string = progressBarLabel.getString();
            int n = x + this.getTooltipWidth() / 2;
            int n2 = this.getProgressBarHeight();
            Objects.requireNonNull(textRenderer);
            drawContext.m_280137_(textRenderer, string, n, y + (n2 - (9 - 2)) / 2, 0xFFFFFF);
        }
    }

    default public int getContentsHeight() {
        return Math.min(this.getNumRows(), Math.max(this.getMaxRows(), 3)) * this.getSlotLength();
    }

    default public int getXMargin(int width) {
        return (width - this.getTooltipWidth()) / 2;
    }

    default public int getHeight(@Nullable Component text, Font textRenderer) {
        if (text == null) {
            return 0;
        }
        int n = textRenderer.m_92923_((FormattedText)text, this.getTooltipWidth()).size();
        Objects.requireNonNull(textRenderer);
        return n * 9;
    }

    default public void blit(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, int width, int height, int maxWidth, int maxHeight) {
        guiGraphics.m_280398_(texture, x, y, 0, 0.0f, 0.0f, width, height, maxWidth, maxHeight);
    }
}

