/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.client.util;

import derekahedron.invexp.bundle.BundleContents;
import derekahedron.invexp.mixin.client.AbstractContainerScreenInvoker;
import derekahedron.invexp.quiver.QuiverContents;
import derekahedron.invexp.quiver.QuiverContentsReader;
import derekahedron.invexp.sack.SackContents;
import derekahedron.invexp.sack.SackContentsReader;
import derekahedron.invexp.util.ContainerItemContents;
import derekahedron.invexp.util.ContainerItemContentsReader;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class ContainerItemSlotDragger {
    @Nullable
    public static ContainerItemSlotDragger of(ItemStack stack) {
        ContainerItemContentsReader contents = ContainerItemContents.of(stack);
        if (contents instanceof SackContentsReader) {
            SackContentsReader sackContents = (SackContentsReader)contents;
            return new SackSlotDragger(sackContents.getSackStack());
        }
        if (contents instanceof QuiverContentsReader) {
            QuiverContentsReader quiverContents = (QuiverContentsReader)contents;
            return new QuiverSlotDragger(quiverContents.getQuiverStack());
        }
        if (stack.m_41720_() instanceof BundleItem) {
            return new BundleSlotDragger(stack);
        }
        return null;
    }

    public void onHover(Slot slot, AbstractContainerScreen<?> screen) {
        ItemStack stack = slot.m_7993_();
        if (screen.m_6262_().m_5622_(slot)) {
            if (screen.f_97717_ == 1) {
                if (stack.m_41619_() && !this.isEmpty()) {
                    ((AbstractContainerScreenInvoker)screen).invokeSlotClicked(slot, slot.getSlotIndex(), screen.f_97717_, ClickType.PICKUP);
                }
            } else if (screen.f_97717_ == 0 && !stack.m_41619_() && this.canTryInsert(stack)) {
                ((AbstractContainerScreenInvoker)screen).invokeSlotClicked(slot, slot.getSlotIndex(), screen.f_97717_, ClickType.PICKUP);
            }
        }
    }

    public abstract boolean canTryInsert(ItemStack var1);

    public abstract boolean isEmpty();

    public static class SackSlotDragger
    extends ContainerItemSlotDragger {
        public final ItemStack sackStack;

        public SackSlotDragger(ItemStack sackStack) {
            this.sackStack = sackStack;
        }

        @Override
        public boolean isEmpty() {
            SackContentsReader contents = SackContents.of(this.sackStack);
            return contents == null || contents.isEmpty();
        }

        @Override
        public boolean canTryInsert(ItemStack stack) {
            SackContentsReader contents = SackContents.of(this.sackStack);
            return contents != null && contents.canTryInsert(stack);
        }
    }

    public static class QuiverSlotDragger
    extends ContainerItemSlotDragger {
        public final ItemStack quiverStack;

        public QuiverSlotDragger(ItemStack quiverStack) {
            this.quiverStack = quiverStack;
        }

        @Override
        public boolean isEmpty() {
            QuiverContents contents = QuiverContents.of(this.quiverStack);
            return contents == null || contents.isEmpty();
        }

        @Override
        public boolean canTryInsert(ItemStack stack) {
            QuiverContents contents = QuiverContents.of(this.quiverStack);
            return contents != null && contents.canTryInsert(stack);
        }
    }

    public static class BundleSlotDragger
    extends ContainerItemSlotDragger {
        public final ItemStack bundleStack;

        public BundleSlotDragger(ItemStack bundleStack) {
            this.bundleStack = bundleStack;
        }

        @Override
        public boolean isEmpty() {
            BundleContents contents = BundleContents.of(this.bundleStack);
            return contents == null || contents.isEmpty();
        }

        @Override
        public boolean canTryInsert(ItemStack stack) {
            BundleContents contents = BundleContents.of(this.bundleStack);
            return contents != null && contents.canTryInsert(stack);
        }
    }
}

