/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.client.util;

import com.mojang.blaze3d.platform.Lighting;
import derekahedron.invexp.InventoryExpansion;
import derekahedron.invexp.util.OpenItemTexturesRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Matrix4f;

public record OpenItemTextures(ModelResourceLocation backTexture, ModelResourceLocation frontTexture) {
    private static final HashMap<Item, OpenItemTextures> OPEN_TEXTURES = new HashMap();

    @Nullable
    public static OpenItemTextures getTextures(Item item) {
        return OPEN_TEXTURES.getOrDefault(item, null);
    }

    public static List<ModelResourceLocation> setupLocations() {
        OPEN_TEXTURES.clear();
        List<Item> items = OpenItemTexturesRegistry.getItems();
        ArrayList<ModelResourceLocation> locations = new ArrayList<ModelResourceLocation>(items.size() * 2);
        for (Item item : items) {
            ForgeRegistries.ITEMS.getDelegate((Object)item).ifPresent(itemReference -> {
                String namespace = itemReference.m_205785_().m_135782_().m_135827_();
                String path = itemReference.m_205785_().m_135782_().m_135815_();
                OpenItemTextures textures = new OpenItemTextures(new ModelResourceLocation(namespace, path + "_open_back", "inventory"), new ModelResourceLocation(namespace, path + "_open_front", "inventory"));
                OPEN_TEXTURES.put(item, textures);
                locations.add(textures.backTexture);
                locations.add(textures.frontTexture);
            });
        }
        return locations;
    }

    public static void renderOpenItem(GuiGraphics guiGraphics, ItemStack stack, int x, int y, @Nullable Level level, @Nullable LivingEntity entity, int seed) {
        ItemRenderer renderer = guiGraphics.f_279544_.m_91291_();
        OpenItemTextures textures = OpenItemTextures.getTextures(stack.m_41720_());
        if (textures == null) {
            return;
        }
        BakedModel backModel = OpenItemTextures.resolveModelOverride(renderer.m_115103_().m_109393_().m_119422_(textures.backTexture()), stack, level, entity, seed);
        BakedModel frontModel = OpenItemTextures.resolveModelOverride(renderer.m_115103_().m_109393_().m_119422_(textures.frontTexture()), stack, level, entity, seed);
        guiGraphics.m_280168_().m_85836_();
        try {
            guiGraphics.m_280168_().m_252880_((float)(x + 8), (float)(y + 8), 150.0f);
            guiGraphics.m_280168_().m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
            guiGraphics.m_280168_().m_85841_(16.0f, 16.0f, 16.0f);
            Lighting.m_84930_();
            guiGraphics.m_280168_().m_85836_();
            try {
                guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, -1.0f);
                renderer.m_115143_(stack, ItemDisplayContext.GUI, false, guiGraphics.m_280168_(), (MultiBufferSource)guiGraphics.m_280091_(), 0xF000F0, OverlayTexture.f_118083_, backModel);
            }
            catch (Throwable throwable) {
                InventoryExpansion.LOGGER.error("Error rendering open back model");
            }
            guiGraphics.m_280168_().m_85849_();
            guiGraphics.m_280168_().m_85836_();
            try {
                guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
                renderer.m_115143_(stack, ItemDisplayContext.GUI, false, guiGraphics.m_280168_(), (MultiBufferSource)guiGraphics.m_280091_(), 0xF000F0, OverlayTexture.f_118083_, frontModel);
            }
            catch (Throwable throwable) {
                InventoryExpansion.LOGGER.error("Error rendering open front model");
            }
            guiGraphics.m_280168_().m_85849_();
            guiGraphics.m_280262_();
            Lighting.m_84931_();
        }
        catch (Throwable throwable) {
            InventoryExpansion.LOGGER.error("Error rendering open model");
        }
        guiGraphics.m_280168_().m_85849_();
    }

    public static BakedModel resolveModelOverride(BakedModel model, ItemStack stack, @Nullable Level level, @Nullable LivingEntity entity, int seed) {
        ClientLevel clientLevel = level instanceof ClientLevel ? (ClientLevel)level : null;
        BakedModel bakedmodel = model.m_7343_().m_173464_(model, stack, clientLevel, entity, seed);
        return bakedmodel == null ? model : bakedmodel;
    }
}

