/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.item;

import derekahedron.invexp.Config;
import derekahedron.invexp.item.tooltip.SackTooltip;
import derekahedron.invexp.quiver.QuiverContents;
import derekahedron.invexp.sack.SackContents;
import derekahedron.invexp.sack.SackContentsReader;
import derekahedron.invexp.sound.InvExpSoundEvents;
import derekahedron.invexp.util.InvExpUtil;
import derekahedron.invexp.util.OpenItemTexturesRegistry;
import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.math.Fraction;

public class SackItem
extends Item {
    public static final int FULL_ITEM_BAR_COLOR = Mth.m_14159_((float)1.0f, (float)0.33f, (float)0.33f);
    public static final int ITEM_BAR_COLOR = Mth.m_14159_((float)0.44f, (float)0.53f, (float)1.0f);

    public SackItem(Item.Properties properties) {
        super(properties);
        OpenItemTexturesRegistry.addItem(this);
    }

    public int getMaxSackTypes() {
        return (Integer)Config.MAX_SACK_TYPES.get();
    }

    public Fraction getMaxSackWeight() {
        return Fraction.getFraction((double)((Integer)Config.MAX_SACK_WEIGHT_STACKS.get()).intValue());
    }

    public int getMaxSackStacks() {
        return (Integer)Config.MAX_SACK_STACKS.get();
    }

    public boolean m_142207_(ItemStack stack, Slot slot, ClickAction clickAction, Player player) {
        SackContents contents = SackContents.of(stack, player.m_9236_());
        if (contents == null) {
            return false;
        }
        ItemStack otherStack = slot.m_7993_();
        if (clickAction == ClickAction.PRIMARY && !otherStack.m_41619_()) {
            if (!contents.canTryInsert(otherStack)) {
                return false;
            }
            if (contents.add(slot, player) > 0) {
                this.playInsertSound((Entity)player);
                InvExpUtil.onContentChanged(player);
            }
            return true;
        }
        if (clickAction == ClickAction.SECONDARY && otherStack.m_41619_()) {
            if (contents.popSelectedStack(slot)) {
                this.playRemoveSound((Entity)player);
                InvExpUtil.onContentChanged(player);
            }
            return true;
        }
        return false;
    }

    public boolean m_142305_(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        SackContents contents = SackContents.of(stack, player.m_9236_());
        if (contents == null) {
            return false;
        }
        if (clickAction == ClickAction.PRIMARY && !otherStack.m_41619_()) {
            if (!contents.canTryInsert(otherStack)) {
                return false;
            }
            if (contents.add(otherStack) > 0) {
                this.playInsertSound((Entity)player);
                InvExpUtil.onContentChanged(player);
            }
            return true;
        }
        if (clickAction == ClickAction.SECONDARY && otherStack.m_41619_() && slot.m_150651_(player)) {
            ItemStack poppedStack = contents.popSelectedStack();
            if (!poppedStack.m_41619_()) {
                slotAccess.m_142104_(poppedStack);
                this.playRemoveSound((Entity)player);
                InvExpUtil.onContentChanged(player);
            }
            return true;
        }
        return false;
    }

    public boolean m_142522_(ItemStack stack) {
        SackContentsReader contents = SackContents.of(stack);
        return contents != null && !contents.isEmpty();
    }

    public int m_142158_(ItemStack stack) {
        SackContentsReader contents = SackContents.of(stack);
        if (contents == null) {
            return 0;
        }
        Fraction fillFraction = contents.getFillFraction();
        return Math.min(13, 1 + fillFraction.getNumerator() * 12 / fillFraction.getDenominator());
    }

    public int m_142159_(ItemStack sackStack) {
        SackContentsReader contents = SackContents.of(sackStack);
        if (contents == null || contents.getTotalWeight().compareTo(contents.getMaxSackWeight()) < 0) {
            return ITEM_BAR_COLOR;
        }
        return FULL_ITEM_BAR_COLOR;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack sackStack) {
        SackContentsReader contents = SackContents.of(sackStack);
        if (contents != null) {
            return Optional.of(new SackTooltip(contents));
        }
        return Optional.empty();
    }

    public void m_142023_(ItemEntity entity) {
        QuiverContents contents = QuiverContents.of(entity.m_32055_());
        if (contents == null || contents.isEmpty()) {
            return;
        }
        ItemUtils.m_150952_((ItemEntity)entity, contents.popAllStacks().stream());
    }

    public void m_6883_(ItemStack sackStack, Level level, Entity entity, int slot, boolean selected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            SackContents contents = SackContents.of(sackStack, level);
            if (contents == null) {
                return;
            }
            contents.validate(player);
            if (contents.isEmpty()) {
                return;
            }
            ItemStack selectedStack = contents.copySelectedStack();
            selectedStack.m_41720_().m_6883_(selectedStack, level, entity, slot, selected);
            contents.updateSelectedStack(selectedStack, leftoverStack -> {
                if (!player.m_150109_().m_36054_(leftoverStack)) {
                    player.m_36176_(leftoverStack, false);
                }
            });
        }
    }

    public void playRemoveSound(Entity entity) {
        entity.m_5496_((SoundEvent)InvExpSoundEvents.ITEM_SACK_REMOVE_ONE.get(), 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public void playInsertSound(Entity entity) {
        entity.m_5496_((SoundEvent)InvExpSoundEvents.ITEM_SACK_INSERT.get(), 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }
}

