/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.mixin;

import derekahedron.invexp.item.QuiverItem;
import derekahedron.invexp.item.SackItem;
import derekahedron.invexp.sack.SackContents;
import derekahedron.invexp.sack.SacksHelper;
import derekahedron.invexp.util.ContainerItemContents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Stream;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractContainerMenu.class})
public class AbstractContainerMenuMixin {
    @Inject(method={"doClick"}, at={@At(value="HEAD")}, cancellable=true)
    private void doubleClickContainerItem(int slotIndex, int button, ClickType clickType, Player player, CallbackInfo ci) {
        AbstractContainerMenu self = (AbstractContainerMenu)this;
        ItemStack cursorStack = self.m_142621_();
        if (slotIndex < 0 || clickType != ClickType.PICKUP_ALL) {
            return;
        }
        Slot selectedSlot = (Slot)self.f_38839_.get(slotIndex);
        if (selectedSlot.m_6657_() && selectedSlot.m_150651_(player)) {
            return;
        }
        ContainerItemContents contents = ContainerItemContents.of(cursorStack, player.m_9236_());
        if (contents == null || contents.isEmpty() && contents instanceof SackContents) {
            return;
        }
        ArrayList<Slot> partialSlots = new ArrayList<Slot>(self.f_38839_.size());
        ArrayList<Slot> fullSlots = new ArrayList<Slot>(self.f_38839_.size());
        for (Slot slot2 : self.f_38839_) {
            if (!slot2.m_6657_() || !self.m_5882_(cursorStack, slot2)) continue;
            ItemStack stack = slot2.m_7993_();
            if (stack.m_41613_() < stack.m_41741_()) {
                partialSlots.add(slot2);
                continue;
            }
            fullSlots.add(slot2);
        }
        if (button != 0) {
            Collections.reverse(partialSlots);
            Collections.reverse(fullSlots);
        }
        Stream<Slot> slots = Stream.concat(partialSlots.stream(), fullSlots.stream());
        if (contents instanceof SackContents) {
            SackContents sackContents = (SackContents)contents;
            slots = slots.filter(slot -> sackContents.isInTypes(SacksHelper.getSackType(slot.m_7993_())));
        }
        if (contents.add(slots, player) > 0) {
            Item item = cursorStack.m_41720_();
            if (item instanceof SackItem) {
                SackItem sackItem = (SackItem)item;
                sackItem.playInsertSound((Entity)player);
            } else {
                item = cursorStack.m_41720_();
                if (item instanceof QuiverItem) {
                    QuiverItem quiverItem = (QuiverItem)item;
                    quiverItem.playInsertSound((Entity)player);
                }
            }
        }
        ci.cancel();
    }
}

