/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.mixin;

import derekahedron.invexp.bundle.BundleContents;
import derekahedron.invexp.item.BetterBundleItem;
import derekahedron.invexp.item.tooltip.BetterBundleTooltip;
import derekahedron.invexp.util.InvExpUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BundleItem.class})
public abstract class BundleItemMixin {
    @Shadow
    protected abstract void m_186351_(Entity var1);

    @Shadow
    protected abstract void m_186342_(Entity var1);

    @Inject(method={"overrideStackedOnOther"}, at={@At(value="HEAD")}, cancellable=true)
    private void betterOverrideStackedOnOther(ItemStack stack, Slot slot, ClickAction clickAction, Player player, CallbackInfoReturnable<Boolean> cir) {
        BundleContents contents = BundleContents.of(stack);
        if (contents == null) {
            cir.setReturnValue((Object)false);
            return;
        }
        ItemStack otherStack = slot.m_7993_();
        if (clickAction == ClickAction.PRIMARY && !otherStack.m_41619_()) {
            if (!contents.canTryInsert(otherStack)) {
                cir.setReturnValue((Object)false);
                return;
            }
            if (contents.add(slot, player) > 0) {
                this.m_186351_((Entity)player);
                InvExpUtil.onContentChanged(player);
            }
            cir.setReturnValue((Object)true);
            return;
        }
        if (clickAction == ClickAction.SECONDARY && otherStack.m_41619_()) {
            if (contents.popSelectedStack(slot)) {
                this.m_186342_((Entity)player);
                InvExpUtil.onContentChanged(player);
            }
            cir.setReturnValue((Object)true);
            return;
        }
        cir.setReturnValue((Object)false);
    }

    @Inject(method={"overrideOtherStackedOnMe"}, at={@At(value="HEAD")}, cancellable=true)
    private void betterOtherStackedOnMe(ItemStack bundleStack, ItemStack otherStack, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess, CallbackInfoReturnable<Boolean> cir) {
        BundleContents contents = BundleContents.of(bundleStack);
        if (contents == null) {
            cir.setReturnValue((Object)false);
            return;
        }
        if (clickAction == ClickAction.PRIMARY && !otherStack.m_41619_()) {
            if (!contents.canTryInsert(otherStack)) {
                cir.setReturnValue((Object)false);
                return;
            }
            if (contents.add(otherStack) > 0) {
                this.m_186351_((Entity)player);
                InvExpUtil.onContentChanged(player);
            }
            cir.setReturnValue((Object)true);
            return;
        }
        if (clickAction == ClickAction.SECONDARY && otherStack.m_41619_()) {
            if (slot.m_150651_(player)) {
                ItemStack poppedStack = contents.popSelectedStack();
                if (!poppedStack.m_41619_()) {
                    slotAccess.m_142104_(poppedStack);
                    this.m_186342_((Entity)player);
                    InvExpUtil.onContentChanged(player);
                }
                cir.setReturnValue((Object)true);
                return;
            }
        } else {
            contents.setSelectedIndex(-1);
        }
        cir.setReturnValue((Object)false);
    }

    @Inject(method={"getBarColor"}, at={@At(value="HEAD")}, cancellable=true)
    private void betterGetBarColor(ItemStack bundleStack, CallbackInfoReturnable<Integer> cir) {
        BundleContents contents = BundleContents.of(bundleStack);
        if (contents != null && contents.getTotalWeight() >= contents.getMaxBundleWeight()) {
            cir.setReturnValue((Object)BetterBundleItem.FULL_ITEM_BAR_COLOR);
        }
    }

    @Inject(method={"getTooltipImage"}, at={@At(value="HEAD")}, cancellable=true)
    private void betterGetTooltipImage(ItemStack bundleStack, CallbackInfoReturnable<Optional<TooltipComponent>> cir) {
        BundleContents contents = BundleContents.of(bundleStack);
        if (contents != null) {
            cir.setReturnValue(Optional.of(new BetterBundleTooltip(contents)));
        } else {
            cir.setReturnValue(Optional.empty());
        }
    }

    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")}, cancellable=true)
    private void betterAppendHoverText(ItemStack bundleStack, Level level, List<Component> components, TooltipFlag flag, CallbackInfo ci) {
        ci.cancel();
    }

    @Inject(method={"getWeight"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getBetterWeight(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        if (stack.m_41720_() instanceof BetterBundleItem) {
            cir.setReturnValue((Object)(BundleItem.m_150778_((ItemStack)stack) + 4));
        }
    }
}

