/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.mixin;

import derekahedron.invexp.entity.player.PlayerEntityDuck;
import derekahedron.invexp.quiver.QuiverContents;
import derekahedron.invexp.sack.SackContents;
import derekahedron.invexp.sack.SackContentsReader;
import derekahedron.invexp.sack.SackUsage;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Inventory.class})
public class InventoryMixin {
    @Inject(method={"add(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void insertIntoContainerItem(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        int slot;
        Inventory self = (Inventory)this;
        if (QuiverContents.attemptPickup(self.m_8020_(self.f_35977_), stack)) {
            cir.setReturnValue((Object)true);
            return;
        }
        if (QuiverContents.attemptPickup(self.m_8020_(40), stack)) {
            cir.setReturnValue((Object)true);
            return;
        }
        for (slot = 0; slot < self.f_35974_.size(); ++slot) {
            if (!QuiverContents.attemptPickup(self.m_8020_(slot), stack)) continue;
            cir.setReturnValue((Object)true);
            return;
        }
        if (SackContents.attemptPickup(self.m_8020_(self.f_35977_), stack, (Entity)self.f_35978_)) {
            cir.setReturnValue((Object)true);
        } else if (SackContents.attemptPickup(self.m_8020_(40), stack, (Entity)self.f_35978_)) {
            cir.setReturnValue((Object)true);
        } else {
            for (slot = 0; slot < self.f_35974_.size(); ++slot) {
                if (!SackContents.attemptPickup(self.m_8020_(slot), stack, (Entity)self.f_35978_)) continue;
                cir.setReturnValue((Object)true);
                break;
            }
        }
    }

    @Inject(method={"removeItem(Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void removeFromSack(ItemStack stack, CallbackInfo ci) {
        SackUsage usage;
        Inventory self = (Inventory)this;
        if (((PlayerEntityDuck)self.f_35978_).invexp_$isUsingSack() && (usage = ((PlayerEntityDuck)self.f_35978_).invexp_$getUsageForSelectedStack(stack)) != null) {
            usage.selectedStack = ItemStack.f_41583_;
            ci.cancel();
        }
    }

    @Inject(method={"removeFromSelected"}, at={@At(value="HEAD")}, cancellable=true)
    private void dropSelectedItemFromSack(boolean entireStack, CallbackInfoReturnable<ItemStack> info) {
        if (entireStack) {
            return;
        }
        Inventory self = (Inventory)this;
        ItemStack sackStack = self.m_36056_();
        SackContents contents = SackContents.of(sackStack, self.f_35978_.m_9236_());
        if (contents == null || contents.isEmpty()) {
            return;
        }
        info.setReturnValue((Object)contents.popSelectedItem());
    }

    @Inject(method={"findSlotMatchingItem"}, at={@At(value="RETURN")}, cancellable=true)
    private void getSlotWithStackInSack(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        if ((Integer)cir.getReturnValue() != -1) {
            return;
        }
        Inventory self = (Inventory)this;
        for (int slot = 0; slot < self.f_35974_.size(); ++slot) {
            SackContentsReader contents = SackContents.of((ItemStack)self.f_35974_.get(slot));
            if (contents == null || contents.isEmpty() || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)contents.getSelectedStack())) continue;
            cir.setReturnValue((Object)slot);
            return;
        }
    }
}

