/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.mixin;

import derekahedron.invexp.sack.SackContents;
import derekahedron.invexp.sack.SackContentsReader;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MapItemSavedData.class})
public class MapItemSavedDataMixin {
    @Unique
    @Nullable
    Player invexp_$trackedPlayer;

    @ModifyArg(method={"tickCarriedBy"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Inventory;contains(Lnet/minecraft/world/item/ItemStack;)Z"))
    private ItemStack containsSackMap(ItemStack mapStack) {
        if (this.invexp_$trackedPlayer == null) {
            return mapStack;
        }
        for (List stacks : this.invexp_$trackedPlayer.m_150109_().f_35979_) {
            for (ItemStack stack : stacks) {
                SackContentsReader contents = SackContents.of(stack);
                if (contents == null || contents.isEmpty()) continue;
                for (ItemStack nestedStack : contents.getStacks()) {
                    if (nestedStack.m_41619_() || !ItemStack.m_150942_((ItemStack)nestedStack, (ItemStack)mapStack)) continue;
                    return stack;
                }
            }
        }
        return mapStack;
    }

    @Inject(method={"tickCarriedBy"}, at={@At(value="HEAD")})
    private void setTrackedPlayer(Player player, ItemStack stack, CallbackInfo ci) {
        this.invexp_$trackedPlayer = player;
    }

    @ModifyVariable(method={"tickCarriedBy"}, at=@At(value="STORE"))
    private MapItemSavedData.HoldingPlayer setTrackedPlayer(MapItemSavedData.HoldingPlayer player) {
        this.invexp_$trackedPlayer = player.f_77959_;
        return player;
    }
}

