/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.mixin;

import derekahedron.invexp.entity.player.PlayerEntityDuck;
import derekahedron.invexp.quiver.QuiverContents;
import derekahedron.invexp.sack.SackContents;
import derekahedron.invexp.sack.SackUsage;
import java.util.ArrayList;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraftforge.common.ForgeHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
implements PlayerEntityDuck {
    @Unique
    private boolean invexp_$usingSack = false;
    @Unique
    @Nullable
    private SackUsage invexp_$mainHandSackUsage;
    @Unique
    @Nullable
    private SackUsage invexp_$offHandSackUsage;

    @Inject(method={"getItemBySlot"}, at={@At(value="RETURN")}, cancellable=true)
    private void getEquippedStackInSack(EquipmentSlot slot, CallbackInfoReturnable<ItemStack> cir) {
        SackUsage usage;
        if (this.invexp_$usingSack && (slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND) && (usage = this.invexp_$getUsageForSackStack((ItemStack)cir.getReturnValue())) != null) {
            cir.setReturnValue((Object)usage.selectedStack);
        }
    }

    @Inject(method={"setItemSlot"}, at={@At(value="HEAD")}, cancellable=true)
    private void equipStackInSack(EquipmentSlot slot, ItemStack stack, CallbackInfo ci) {
        if (this.invexp_$usingSack && (slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND)) {
            Player self = (Player)this;
            SackUsage usage = this.invexp_$getUsageForSackStack(switch (slot) {
                case EquipmentSlot.MAINHAND -> self.m_150109_().m_36056_();
                case EquipmentSlot.OFFHAND -> (ItemStack)self.m_150109_().f_35976_.get(0);
                default -> throw new IllegalArgumentException("Invalid slot " + String.valueOf(slot));
            });
            if (usage != null) {
                self.m_238392_(slot, usage.selectedStack, stack);
                usage.selectedStack = stack;
                ci.cancel();
            }
        }
    }

    @Override
    public boolean invexp_$isUsingSack() {
        return this.invexp_$usingSack;
    }

    @Override
    public void invexp_$startUsingSack() {
        int i;
        if (this.invexp_$usingSack) {
            this.invexp_$stopUsingSack();
        }
        Player self = (Player)this;
        SackUsage[] usages = new SackUsage[InteractionHand.values().length];
        for (i = 0; i < InteractionHand.values().length; ++i) {
            ItemStack heldStack = self.m_21120_(InteractionHand.values()[i]);
            SackContents contents = SackContents.of(heldStack, self.m_9236_());
            if (contents == null || contents.isEmpty()) continue;
            SackUsage usage = this.invexp_$getUsageForSackStack(heldStack);
            usages[i] = usage != null ? new SackUsage(contents, usage.selectedStack) : new SackUsage(contents);
        }
        for (i = 0; i < InteractionHand.values().length; ++i) {
            this.invexp$setUsageByHand(InteractionHand.values()[i], usages[i]);
        }
        this.invexp_$usingSack = true;
    }

    @Override
    public void invexp_$stopUsingSack() {
        if (!this.invexp_$usingSack) {
            return;
        }
        ArrayList leftoverStacks = new ArrayList();
        Player self = (Player)this;
        for (InteractionHand hand : InteractionHand.values()) {
            SackUsage usage = this.invexp_$getUsageByHand(hand);
            if (usage == null) continue;
            usage.update(self.m_9236_(), leftoverStacks::add);
        }
        this.invexp_$usingSack = false;
        for (ItemStack leftoverStack : leftoverStacks) {
            if (leftoverStack.m_41619_() || self.m_150109_().m_36054_(leftoverStack)) continue;
            self.m_36176_(leftoverStack, false);
        }
    }

    @Override
    @Nullable
    public SackUsage invexp_$getUsageForSackStack(ItemStack sackStack) {
        for (InteractionHand hand : InteractionHand.values()) {
            SackUsage usage = this.invexp_$getUsageByHand(hand);
            if (usage == null || usage.sackStack != sackStack) continue;
            return usage;
        }
        return null;
    }

    @Override
    @Nullable
    public SackUsage invexp_$getUsageForSelectedStack(ItemStack selectedStack) {
        for (InteractionHand hand : InteractionHand.values()) {
            SackUsage usage = this.invexp_$getUsageByHand(hand);
            if (usage == null || usage.selectedStack != selectedStack) continue;
            return usage;
        }
        return null;
    }

    @Unique
    private void invexp$setUsageByHand(InteractionHand hand, @Nullable SackUsage usage) {
        switch (hand) {
            case MAIN_HAND: {
                this.invexp_$mainHandSackUsage = usage;
                break;
            }
            case OFF_HAND: {
                this.invexp_$offHandSackUsage = usage;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid hand " + String.valueOf(hand));
            }
        }
    }

    @Unique
    @Nullable
    private SackUsage invexp_$getUsageByHand(InteractionHand hand) {
        switch (hand) {
            case MAIN_HAND: {
                return this.invexp_$mainHandSackUsage;
            }
            case OFF_HAND: {
                return this.invexp_$offHandSackUsage;
            }
        }
        throw new IllegalArgumentException("Invalid hand " + String.valueOf(hand));
    }

    @Inject(method={"getProjectile"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ProjectileWeaponItem;getAllSupportedProjectiles()Ljava/util/function/Predicate;")}, cancellable=true)
    private void getQuiveredProjectile(ItemStack stack, CallbackInfoReturnable<ItemStack> cir) {
        Player self = (Player)this;
        Predicate predicate = ((ProjectileWeaponItem)stack.m_41720_()).m_6437_();
        for (int i = 0; i < self.m_150109_().m_6643_(); ++i) {
            ItemStack projectile;
            QuiverContents contents = QuiverContents.of(self.m_150109_().m_8020_(i));
            if (contents == null || (projectile = contents.getProjectileStack(predicate)).m_41619_()) continue;
            cir.setReturnValue((Object)ForgeHooks.getProjectile((LivingEntity)self, (ItemStack)stack, (ItemStack)projectile));
            return;
        }
    }
}

