/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.mixin.client;

import derekahedron.invexp.bundle.BundleContents;
import derekahedron.invexp.client.util.ContainerItemSlotDragger;
import derekahedron.invexp.client.util.InvExpClientUtil;
import derekahedron.invexp.client.util.OpenItemTextures;
import derekahedron.invexp.item.DyeableSackItem;
import derekahedron.invexp.item.QuiverItem;
import derekahedron.invexp.network.InvExpPacketHandler;
import derekahedron.invexp.network.SetSelectedIndexPacket;
import derekahedron.invexp.sack.SackContents;
import derekahedron.invexp.sack.SackContentsReader;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin {
    @Shadow
    @Final
    protected Set<Slot> f_97737_;
    @Shadow
    protected boolean f_97738_;
    @Shadow
    @Nullable
    private Slot f_97706_;
    @Shadow
    protected int f_97726_;
    @Shadow
    @Nullable
    protected Slot f_97734_;
    @Unique
    @Nullable
    private Slot invexp_$currentSlot;
    @Unique
    private boolean invexp$hasMoved;
    @Unique
    @Nullable
    private SackContentsReader invexp_$openContents;
    @Unique
    private int invexp$mouseX;
    @Unique
    private int invexp$mouseY;
    @Unique
    @Nullable
    private Slot invexp_$hoveredBundleSlot;

    @Shadow
    protected abstract List<Component> m_280553_(ItemStack var1);

    @Shadow
    protected abstract boolean m_97774_(Slot var1, double var2, double var4);

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")})
    private void startDraggingContainer(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        AbstractContainerScreen self = (AbstractContainerScreen)this;
        if (ContainerItemSlotDragger.of(self.m_6262_().m_142621_()) != null) {
            this.invexp_$currentSlot = self.getSlotUnderMouse();
            this.invexp$hasMoved = false;
        }
    }

    @Inject(method={"mouseDragged"}, at={@At(value="HEAD")}, cancellable=true)
    private void dragContainer(double mouseX, double mouseY, int button, double deltaX, double deltaY, CallbackInfoReturnable<Boolean> cir) {
        AbstractContainerScreen self = (AbstractContainerScreen)this;
        if (self.f_97717_ == 2 || !this.f_97738_ || this.f_97706_ != null || self.getMinecraft() == null || ((Boolean)self.getMinecraft().f_91066_.m_231828_().m_231551_()).booleanValue()) {
            return;
        }
        Slot slot = self.getSlotUnderMouse();
        if (slot == null) {
            return;
        }
        ItemStack cursorStack = self.m_6262_().m_142621_();
        ContainerItemSlotDragger dragger = ContainerItemSlotDragger.of(cursorStack);
        if (dragger == null) {
            return;
        }
        if (this.invexp_$currentSlot == null) {
            this.invexp_$currentSlot = slot;
        } else if (this.invexp_$currentSlot != slot) {
            if (!this.invexp$hasMoved) {
                this.invexp$hasMoved = true;
                this.f_97737_.clear();
                dragger.onHover(this.invexp_$currentSlot, self);
            }
            this.invexp_$currentSlot = slot;
            dragger.onHover(this.invexp_$currentSlot, self);
        }
        cir.setReturnValue((Object)true);
        cir.cancel();
    }

    @Inject(method={"mouseReleased"}, at={@At(value="HEAD")}, cancellable=true)
    private void finishDraggingContainer(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        AbstractContainerScreen self = (AbstractContainerScreen)this;
        if (this.invexp$hasMoved && ContainerItemSlotDragger.of(self.m_6262_().m_142621_()) != null) {
            this.invexp$hasMoved = false;
            this.invexp_$currentSlot = null;
            this.f_97738_ = false;
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @Inject(method={"renderTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderContainerTooltip(GuiGraphics guiGraphics, int p_282171_, int p_281909_, CallbackInfo ci) {
        ItemStack hoverStack;
        Item item;
        AbstractContainerScreen self = (AbstractContainerScreen)this;
        Slot hoveredSlot = self.getSlotUnderMouse();
        if (!self.m_6262_().m_142621_().m_41619_() && hoveredSlot != null && hoveredSlot.m_6657_() && ((item = (hoverStack = hoveredSlot.m_7993_()).m_41720_()) instanceof BundleItem || item instanceof DyeableSackItem || item instanceof QuiverItem)) {
            guiGraphics.renderTooltip(self.f_96547_, this.m_280553_(hoverStack), hoverStack.m_150921_(), hoverStack, p_282171_, p_281909_);
            ci.cancel();
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void saveMousePos(GuiGraphics guiGraphics, int x, int y, float delta, CallbackInfo ci) {
        this.invexp$mouseX = x;
        this.invexp$mouseY = y;
    }

    @Inject(method={"renderSlot"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;renderItem(Lnet/minecraft/world/item/ItemStack;III)V")})
    private void drawOpenSack(GuiGraphics context, Slot slot, CallbackInfo ci) {
        this.invexp_$openContents = null;
        AbstractContainerScreen self = (AbstractContainerScreen)this;
        if (!(slot.m_6657_() && this.m_97774_(slot, this.invexp$mouseX, this.invexp$mouseY) && self.getMinecraft() != null && self.m_6262_().m_5622_(slot))) {
            return;
        }
        ItemStack cursorStack = self.m_6262_().m_142621_();
        SackContentsReader contents = SackContents.of(slot.m_7993_());
        if (contents == null || contents.isEmpty() || !cursorStack.m_41619_() && !contents.canTryInsert(cursorStack)) {
            return;
        }
        this.invexp_$openContents = contents;
        LocalPlayer player = self.getMinecraft().f_91074_;
        Level level = player != null ? player.m_9236_() : null;
        OpenItemTextures.renderOpenItem(context, slot.m_7993_(), slot.f_40220_, slot.f_40221_, level, (LivingEntity)player, slot.f_40220_ + slot.f_40221_ * this.f_97726_);
    }

    @ModifyArg(method={"renderSlot"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;renderItem(Lnet/minecraft/world/item/ItemStack;III)V"))
    private ItemStack renderSelectedItem(ItemStack stack) {
        if (this.invexp_$openContents != null) {
            ItemStack selectedStack = this.invexp_$openContents.getSelectedStack();
            this.invexp_$openContents = null;
            return selectedStack;
        }
        return stack;
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void trackBundleSlot(GuiGraphics guiGraphics, int x, int y, float delta, CallbackInfo ci) {
        this.invexp_$setHoveredSlot(this.f_97734_);
    }

    @Inject(method={"onClose"}, at={@At(value="HEAD")})
    private void closeBundle(CallbackInfo ci) {
        this.invexp_$setHoveredSlot(null);
    }

    @Unique
    private void invexp_$setHoveredSlot(@Nullable Slot newHoveredSlot) {
        if (newHoveredSlot != this.invexp_$hoveredBundleSlot) {
            BundleContents contents;
            if (this.invexp_$hoveredBundleSlot != null && (contents = BundleContents.of(this.invexp_$hoveredBundleSlot.m_7993_())) != null && !contents.isEmpty() && contents.getSelectedIndex() != -1) {
                contents.setSelectedIndex(-1);
                AbstractContainerScreen self = (AbstractContainerScreen)this;
                Slot trueSlot = InvExpClientUtil.getTrueSlot(this.invexp_$hoveredBundleSlot, (Player)self.getMinecraft().f_91074_);
                if (trueSlot != null) {
                    InvExpPacketHandler.INSTANCE.sendToServer((Object)new SetSelectedIndexPacket(trueSlot.f_40219_, -1));
                }
            }
            this.invexp_$hoveredBundleSlot = newHoveredSlot != null && newHoveredSlot.m_7993_().m_41720_() instanceof BundleItem ? newHoveredSlot : null;
        }
    }
}

