/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.network;

import derekahedron.invexp.InventoryExpansion;
import derekahedron.invexp.bundle.BundleContents;
import derekahedron.invexp.util.ContainerItemContents;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SetSelectedIndexPacket {
    public final int slotId;
    public final int selectedIndex;

    public SetSelectedIndexPacket(int slotId, int selectedIndex) {
        this.slotId = slotId;
        this.selectedIndex = selectedIndex;
    }

    @ParametersAreNonnullByDefault
    public SetSelectedIndexPacket(FriendlyByteBuf buffer) {
        this(buffer.readInt(), buffer.readInt());
    }

    @ParametersAreNonnullByDefault
    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeInt(this.slotId);
        buffer.writeInt(this.selectedIndex);
    }

    @ParametersAreNonnullByDefault
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            if (this.slotId < 0 || this.slotId >= player.f_36096_.f_38839_.size()) {
                InventoryExpansion.LOGGER.debug("Player {} set selected index of invalid slot id {}", (Object)player, (Object)this.slotId);
                return;
            }
            ItemStack stack = ((Slot)player.f_36096_.f_38839_.get(this.slotId)).m_7993_();
            ContainerItemContents contents = ContainerItemContents.of(stack, player.m_9236_());
            if (contents == null) {
                contents = BundleContents.of(stack);
            }
            if (contents == null) {
                InventoryExpansion.LOGGER.debug("Player {} set selected index of invalid stack {}", (Object)player, (Object)stack);
                return;
            }
            contents.setSelectedIndex(this.selectedIndex);
            player.f_36096_.m_6199_((Container)player.m_150109_());
        });
    }
}

