/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.quiver;

import com.google.common.collect.Lists;
import derekahedron.invexp.item.QuiveredItemStack;
import derekahedron.invexp.quiver.QuiverContentsComponent;
import derekahedron.invexp.quiver.QuiverContentsReader;
import derekahedron.invexp.quiver.QuiverHelper;
import derekahedron.invexp.util.ContainerItemContents;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;

public class QuiverContents
extends ContainerItemContents
implements QuiverContentsReader {
    public final ItemStack quiverStack;
    private QuiverContentsComponent component;

    private QuiverContents(ItemStack quiverStack, QuiverContentsComponent component) {
        this.quiverStack = quiverStack;
        this.component = component;
    }

    @Nullable
    public static QuiverContents of(@Nullable ItemStack quiverStack) {
        QuiverContentsComponent component = QuiverContentsComponent.getComponent(quiverStack);
        if (component == null) {
            return null;
        }
        return new QuiverContents(quiverStack, component);
    }

    public ItemStack getProjectileStack(Predicate<ItemStack> predicate) {
        if (this.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack selectedStack = this.getSelectedStack();
        if (!predicate.test(selectedStack)) {
            return ItemStack.f_41583_;
        }
        for (int i = this.component.stacks.size() - 1; i >= 0; --i) {
            ItemStack nestedStack = this.component.stacks.get(i);
            if (!ItemStack.m_150942_((ItemStack)selectedStack, (ItemStack)nestedStack)) continue;
            return new QuiveredItemStack(nestedStack, this.quiverStack);
        }
        return new QuiveredItemStack(selectedStack, this.quiverStack);
    }

    public boolean isValid() {
        if (!this.component.isValid()) {
            return false;
        }
        return this.getTotalOccupancy().compareTo(this.getMaxQuiverOccupancy()) <= 0 && this.getStacks().size() <= this.getMaxQuiverStacks();
    }

    public void validate(Player player) {
        if (this.isValid()) {
            return;
        }
        ArrayList<ItemStack> removedStacks = new ArrayList<ItemStack>(this.getStacks().size());
        QuiverContents newContents = new QuiverContents(this.quiverStack, new QuiverContentsComponent());
        Builder builder = newContents.getBuilder();
        for (int i = this.getStacks().size() - 1; i >= 0; --i) {
            ItemStack stack = this.getStacks().get(i).m_41777_();
            builder.add(stack, 0);
            if (stack.m_41619_()) continue;
            removedStacks.add(stack);
        }
        builder.selectedIndex = builder.nextSelectedIndex(this.getSelectedStack(), this.getSelectedIndex());
        builder.apply();
        this.component = newContents.component;
        for (ItemStack stack : removedStacks) {
            if (player.m_150109_().m_36054_(stack)) continue;
            player.m_36176_(stack, false);
        }
    }

    @Override
    public List<ItemStack> getStacks() {
        return this.component.stacks;
    }

    @Override
    public int getSelectedIndex() {
        return this.component.selectedIndex;
    }

    @Override
    public ItemStack getQuiverStack() {
        return this.quiverStack;
    }

    @Override
    public Fraction getTotalOccupancy() {
        return this.component.getTotalOccupancy();
    }

    @Override
    public Builder getBuilder() {
        return new Builder();
    }

    public static boolean attemptPickup(ItemStack quiverStack, ItemStack stack) {
        QuiverContents contents = QuiverContents.of(quiverStack);
        if (contents == null) {
            return false;
        }
        contents.add(stack);
        return stack.m_41619_();
    }

    public class Builder
    extends ContainerItemContents.Builder
    implements QuiverContentsReader {
        public final List<ItemStack> stacks;
        public int selectedIndex;
        public Fraction totalOccupancy;

        public Builder() {
            this.stacks = new ArrayList<ItemStack>(QuiverContents.this.component.getStacks());
            this.selectedIndex = QuiverContents.this.component.selectedIndex;
            this.totalOccupancy = QuiverContents.this.component.getTotalOccupancy();
        }

        @Override
        public void apply() {
            QuiverContents.this.component = new QuiverContentsComponent(List.copyOf(this.stacks), this.clampIndex(this.selectedIndex));
            QuiverContents.this.component.setComponent(QuiverContents.this.quiverStack);
        }

        @Override
        public int add(ItemStack stack, int insertAt) {
            if (!this.canTryInsert(stack)) {
                return 0;
            }
            Fraction occupancy = QuiverHelper.getOccupancy(stack);
            int added = 0;
            int toAdd = Math.min(stack.m_41613_(), this.getMaxAllowedByOccupancy(stack));
            if (toAdd > 0) {
                for (int i = 0; i < this.stacks.size(); ++i) {
                    ItemStack nestedStack = this.stacks.get(i);
                    if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)nestedStack)) continue;
                    int amount = Math.min(toAdd, nestedStack.m_41741_() - nestedStack.m_41613_());
                    if (amount > 0) {
                        this.stacks.set(i, nestedStack.m_255036_(nestedStack.m_41613_() + amount));
                        stack.m_41774_(amount);
                        toAdd -= amount;
                        added += amount;
                        this.totalOccupancy = this.totalOccupancy.add(occupancy.multiplyBy(Fraction.getFraction((double)amount)));
                    }
                    if (toAdd > 0) continue;
                    return added;
                }
                if (this.canAddStack()) {
                    ++this.selectedIndex;
                    added += toAdd;
                    ItemStack newStack = stack.m_41620_(toAdd);
                    this.totalOccupancy = this.totalOccupancy.add(QuiverHelper.getOccupancyOfStack(newStack));
                    this.stacks.add(0, newStack);
                }
            }
            return added;
        }

        @Override
        public int remove(ItemStack stack, int toRemove) {
            if (this.isEmpty() || stack.m_41619_()) {
                return 0;
            }
            int removed = 0;
            Fraction occupancy = QuiverHelper.getOccupancy(stack);
            boolean removedSelected = false;
            for (int i = 0; i < this.stacks.size() && toRemove > 0; ++i) {
                ItemStack nestedStack = this.stacks.get(i);
                if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)nestedStack)) continue;
                if (toRemove >= nestedStack.m_41613_()) {
                    removed += nestedStack.m_41613_();
                    toRemove -= nestedStack.m_41613_();
                    this.totalOccupancy = this.totalOccupancy.subtract(occupancy.multiplyBy(Fraction.getFraction((double)nestedStack.m_41613_())));
                    this.stacks.remove(i);
                    if (i < this.selectedIndex) {
                        --this.selectedIndex;
                    } else if (i == this.selectedIndex) {
                        removedSelected = true;
                    }
                    --i;
                    continue;
                }
                removed += toRemove;
                this.totalOccupancy = this.totalOccupancy.subtract(occupancy.multiplyBy(Fraction.getFraction((double)toRemove)));
                this.stacks.set(i, nestedStack.m_255036_(nestedStack.m_41613_() - toRemove));
                toRemove = 0;
            }
            if (removedSelected) {
                this.selectedIndex = this.nextSelectedIndex(stack, this.selectedIndex);
            }
            return removed;
        }

        @Override
        public ItemStack popSelectedStack() {
            if (this.isEmpty()) {
                return ItemStack.f_41583_;
            }
            ItemStack selectedStack = this.stacks.remove(this.selectedIndex).m_41777_();
            this.selectedIndex = this.nextSelectedIndex(selectedStack, this.selectedIndex);
            this.totalOccupancy = this.totalOccupancy.subtract(QuiverHelper.getOccupancyOfStack(selectedStack));
            return selectedStack;
        }

        @Override
        public List<ItemStack> popAllStacks() {
            List copies = Lists.transform(this.stacks, ItemStack::m_41777_);
            this.stacks.clear();
            this.selectedIndex = -1;
            this.totalOccupancy = Fraction.ZERO;
            return copies;
        }

        @Override
        public ItemStack getQuiverStack() {
            return QuiverContents.this.quiverStack;
        }

        @Override
        public List<ItemStack> getStacks() {
            return this.stacks;
        }

        @Override
        public int getSelectedIndex() {
            return this.selectedIndex;
        }

        @Override
        public void setSelectedIndex(int selectedIndex) {
            this.selectedIndex = selectedIndex;
        }

        @Override
        public Fraction getTotalOccupancy() {
            return this.totalOccupancy;
        }
    }
}

