/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.quiver;

import derekahedron.invexp.item.QuiverItem;
import derekahedron.invexp.quiver.QuiverHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;

public class QuiverContentsComponent {
    public static final String COMPOUND_KEY = "InvExpQuiverContents";
    public static final String ITEMS_KEY = "Items";
    public static final String SELECTED_INDEX_KEY = "SelectedIndex";
    public static final String TOTAL_OCCUPANCY_KEY = "TotalOccupancy";
    public static final String NUMERATOR_KEY = "Numerator";
    public static final String DENOMINATOR_KEY = "Denominator";
    public final List<ItemStack> stacks;
    public final int selectedIndex;
    private final Fraction totalOccupancy;

    public QuiverContentsComponent(List<ItemStack> stacks, int selectedIndex) {
        this(stacks, selectedIndex, QuiverContentsComponent.calculateTotalOccupancy(stacks));
    }

    public QuiverContentsComponent(List<ItemStack> stacks, int selectedIndex, Fraction totalOccupancy) {
        this.stacks = stacks;
        this.selectedIndex = selectedIndex;
        this.totalOccupancy = totalOccupancy;
    }

    public QuiverContentsComponent() {
        this(List.of(), -1);
    }

    public List<ItemStack> getStacks() {
        return this.stacks;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public Fraction getTotalOccupancy() {
        return this.totalOccupancy;
    }

    public boolean isValid() {
        for (ItemStack nestedStack : this.stacks) {
            if (nestedStack.m_41720_().m_142095_() && nestedStack.m_204117_(ItemTags.f_13161_)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    public ItemStack getSelectedStack() {
        if (this.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return this.stacks.get(this.selectedIndex);
    }

    public void setComponent(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!this.isEmpty()) {
            CompoundTag quiverContents = new CompoundTag();
            ListTag contentsTag = new ListTag();
            for (ItemStack nestedStack : this.getStacks()) {
                CompoundTag itemTag = new CompoundTag();
                nestedStack.m_41739_(itemTag);
                contentsTag.add((Object)itemTag);
            }
            quiverContents.m_128365_(ITEMS_KEY, (Tag)contentsTag);
            quiverContents.m_128405_(SELECTED_INDEX_KEY, this.getSelectedIndex());
            CompoundTag occupancyTag = new CompoundTag();
            occupancyTag.m_128405_(NUMERATOR_KEY, this.totalOccupancy.getNumerator());
            occupancyTag.m_128405_(DENOMINATOR_KEY, this.totalOccupancy.getDenominator());
            quiverContents.m_128365_(TOTAL_OCCUPANCY_KEY, (Tag)occupancyTag);
            tag.m_128365_(COMPOUND_KEY, (Tag)quiverContents);
        } else {
            tag.m_128473_(COMPOUND_KEY);
        }
    }

    @Nullable
    public static QuiverContentsComponent getComponent(@Nullable ItemStack stack) {
        if (stack != null && !stack.m_41619_() && stack.m_41720_() instanceof QuiverItem) {
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128441_(COMPOUND_KEY)) {
                CompoundTag quiverContents = tag.m_128469_(COMPOUND_KEY);
                ListTag contentsTag = quiverContents.m_128437_(ITEMS_KEY, 10);
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(contentsTag.size());
                for (int i = 0; i < contentsTag.size(); ++i) {
                    stacks.add(ItemStack.m_41712_((CompoundTag)contentsTag.m_128728_(i)));
                }
                int selectedIndex = quiverContents.m_128451_(SELECTED_INDEX_KEY);
                if (quiverContents.m_128425_(TOTAL_OCCUPANCY_KEY, 10)) {
                    CompoundTag totalOccupancyTag = quiverContents.m_128469_(TOTAL_OCCUPANCY_KEY);
                    Fraction totalOccupancy = Fraction.getFraction((int)totalOccupancyTag.m_128451_(NUMERATOR_KEY), (int)totalOccupancyTag.m_128451_(DENOMINATOR_KEY));
                    return new QuiverContentsComponent(stacks, selectedIndex, totalOccupancy);
                }
                return new QuiverContentsComponent(stacks, selectedIndex);
            }
            return new QuiverContentsComponent();
        }
        return null;
    }

    public static Fraction calculateTotalOccupancy(List<ItemStack> stacks) {
        Fraction totalOccupancy = Fraction.ZERO;
        for (ItemStack nestedStack : stacks) {
            totalOccupancy = totalOccupancy.add(QuiverHelper.getOccupancyOfStack(nestedStack));
        }
        return totalOccupancy;
    }
}

