/*
 * Decompiled with CFR 0.152.
 */
package derekahedron.invexp.quiver;

import derekahedron.invexp.item.QuiverItem;
import derekahedron.invexp.quiver.QuiverHelper;
import derekahedron.invexp.util.ContainerItemContentsReader;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;

public interface QuiverContentsReader
extends ContainerItemContentsReader {
    public ItemStack getQuiverStack();

    public Fraction getTotalOccupancy();

    @Override
    default public boolean canTryInsert(ItemStack stack) {
        return stack.m_204117_(ItemTags.f_13161_) && stack.m_41720_().m_142095_();
    }

    @Override
    default public int getMaxAllowed(ItemStack stack) {
        if (!this.canTryInsert(stack)) {
            return 0;
        }
        int maxAllowedByOccupancy = this.getMaxAllowedByOccupancy(stack);
        if (maxAllowedByOccupancy == 0) {
            return 0;
        }
        if (this.canAddStack()) {
            return maxAllowedByOccupancy;
        }
        int maxAllowed = 0;
        for (ItemStack nestedStack : this.getStacks()) {
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)nestedStack) || (maxAllowed += nestedStack.m_41741_() - nestedStack.m_41613_()) < maxAllowedByOccupancy) continue;
            return maxAllowedByOccupancy;
        }
        return maxAllowed;
    }

    default public int getMaxAllowedByOccupancy(ItemStack stack) {
        Fraction openOccupancy = this.getMaxQuiverOccupancy().subtract(this.getTotalOccupancy());
        return Math.max(openOccupancy.divideBy(QuiverHelper.getOccupancy(stack)).intValue(), 0);
    }

    @Override
    default public boolean isFull() {
        return this.getTotalOccupancy().compareTo(this.getMaxQuiverOccupancy()) >= 0 || this.getStacks().size() >= this.getMaxQuiverStacks();
    }

    @Override
    default public Fraction getFillFraction() {
        if (this.isFull()) {
            return Fraction.ONE;
        }
        return this.getTotalOccupancy().divideBy(this.getMaxQuiverOccupancy());
    }

    @Override
    default public boolean canAddStack() {
        return this.getStacks().size() < this.getMaxQuiverStacks();
    }

    default public int getMaxQuiverStacks() {
        Item item = this.getQuiverStack().m_41720_();
        if (item instanceof QuiverItem) {
            QuiverItem quiverItem = (QuiverItem)item;
            return quiverItem.getMaxQuiverStacks();
        }
        return 0;
    }

    default public Fraction getMaxQuiverOccupancy() {
        return QuiverHelper.getMaxQuiverOccupancy(this.getQuiverStack());
    }
}

